/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.auth.AuthUser;
import org.eaglei.repository.auth.AuthUserFactory;
import org.eaglei.repository.auth.AuthUserTomcatFactory;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.Role;
import org.eaglei.repository.model.User;
import org.eaglei.repository.model.WritableObjectModel;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.FOAF;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * Exception performing whole class analysis ignored.
 */
public class User
extends WritableObjectModel {
    private static final Logger log = LogManager.getLogger(User.class);
    public static final URI USER_GRAPH = REPO.NG_USERS;
    public static final DatasetImpl USER_DATASET = SPARQL.copyDataset((Dataset)SPARQL.InternalGraphs);
    private static final AuthUserFactory authFactory;
    private URI uri;
    private String username;
    private String firstName = null;
    private String lastName = null;
    private String mbox = null;
    private Set<URI> roles = new HashSet();
    private AuthUser auth = null;
    private Boolean hasAuthUser = null;
    private static final String userForURIQuery;

    private User(URI uri, String username) {
        if (username == null) {
            throw new IllegalArgumentException("Cannot create User without username");
        }
        this.uri = uri;
        this.username = username;
        this.roles.addAll(REPO.IMPLICIT_ROLES);
    }

    public static User findByUsername(HttpServletRequest request, String pname) throws ServletException {
        return User.findOneUserInternal((HttpServletRequest)request, (String)pname, null);
    }

    public static User find(HttpServletRequest request, URI uri) throws ServletException {
        return User.findOneUserInternal((HttpServletRequest)request, null, (URI)uri);
    }

    private static User findOneUserInternal(HttpServletRequest request, String pname, URI uri) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            log.debug((Object)("Single user SPARQL query = " + userForURIQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)USER_DATASET);
            q.clearBindings();
            if (pname != null) {
                q.setBinding("hasPrincipalName", (Value)new LiteralImpl(pname));
            } else if (uri != null) {
                q.setBinding("uri", (Value)uri);
            } else {
                throw new ServletException("sanity check: findOneUserInternal called without either username OR uri");
            }
            q.setIncludeInferred(false);
            UserHandler h = new UserHandler(request, null);
            q.evaluate((TupleQueryResultHandler)h);
            User result = UserHandler.access$000((UserHandler)h);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User.findOneUserInternal(pname=\"" + pname + "\", uri=" + uri + "), SPARQL result => " + result));
            }
            if (pname != null) {
                AuthUser au;
                User temp = result;
                if (temp == null) {
                    temp = new User(null, pname);
                }
                if ((au = temp.getAuthUser()) != null) {
                    if (au.isSuperuser()) {
                        temp.roles.add(REPO.ROLE_SUPERUSER);
                    }
                    return temp;
                }
            }
            return result;
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public static List<User> findAll(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ArrayList<User> result = new ArrayList<User>();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("All user SPARQL query = " + userForURIQuery));
            }
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, userForURIQuery);
            q.setDataset((Dataset)USER_DATASET);
            q.setIncludeInferred(false);
            q.evaluate((TupleQueryResultHandler)new UserHandler(request, result));
            Map authUsers = authFactory.findAllAsMap();
            for (User ru : result) {
                log.debug((Object)("findAll: Found documented user: " + ru.username));
                AuthUser au = (AuthUser)authUsers.get(ru.username);
                if (au == null) continue;
                if (au.isSuperuser()) {
                    ru.roles.add(REPO.ROLE_SUPERUSER);
                }
                authUsers.remove(ru.username);
            }
            for (AuthUser au : authUsers.values()) {
                log.debug((Object)("findAll: Found undocumented user: " + au.getUsername()));
                User ru = new User(null, au.getUsername());
                if (au.isSuperuser()) {
                    ru.roles.add(REPO.ROLE_SUPERUSER);
                }
                result.add(ru);
            }
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        return result;
    }

    public static User create(HttpServletRequest request, String username, String password) throws ServletException {
        return User.createInternal((HttpServletRequest)request, (URI)User.newURI(), (String)username, (String)password, (boolean)false);
    }

    public static User createAsAdministrator(HttpServletRequest request, String username, String password) throws ServletException {
        return User.createInternal((HttpServletRequest)request, (URI)User.newURI(), (String)username, (String)password, (boolean)true);
    }

    public static User create(HttpServletRequest request, URI uri, String username, String password) throws ServletException {
        return User.createInternal((HttpServletRequest)request, (URI)uri, (String)username, (String)password, (boolean)false);
    }

    private static User createInternal(HttpServletRequest request, URI uri, String username, String password, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Access.hasPermissionOnUser((HttpServletRequest)request, (String)username)) {
            throw new ForbiddenException("Not allowed to create user: " + username);
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        User result = null;
        try {
            Literal lpname = vf.createLiteral(username);
            if (rc.hasStatement(null, REPO.HAS_PRINCIPAL_NAME, (Value)lpname, false, new Resource[]{REPO.NG_INTERNAL})) {
                throw new BadRequestException("Cannot create user: there is already a repository user with the login principal name (username) \"" + username + "\"");
            }
            result = new User(uri, username);
            if (uri != null) {
                result.initialStatements(rc);
            }
            if (password != null) {
                result.createAuthUser(password);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("create: created new User instance, username=" + username + ", uri=" + result.uri));
            }
            return result;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed creating user URI: ", (Throwable)e);
            throw new ServletException("Failed creating user URI: ", (Throwable)e);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getMbox() {
        return this.mbox;
    }

    public String getLabel() {
        if (this.username != null) {
            String pn = this.getPersonalName();
            return pn.length() > 0 ? this.username + " (" + pn + ")" : this.username;
        }
        return this.uri == null ? "(no username or uri)" : this.uri.getLocalName();
    }

    public String getPersonalName() {
        return this.firstName == null ? (this.lastName == null ? "" : this.lastName) : (this.lastName == null ? this.firstName : this.firstName + " " + this.lastName);
    }

    private Role[] getRoles(HttpServletRequest request) throws ServletException {
        Role[] result = new Role[this.roles.size()];
        int i = 0;
        for (URI ru : this.roles) {
            result[i] = Role.find((HttpServletRequest)request, (URI)ru);
            ++i;
        }
        return result;
    }

    public boolean hasRoleP(Role r) {
        return this.roles.contains(r.getURI());
    }

    public boolean hasRoleP(URI ru) {
        return this.roles.contains(ru);
    }

    public boolean isSuperuser() {
        return this.hasRoleP(REPO.ROLE_SUPERUSER);
    }

    public void setIsSuperuser(boolean su) {
        if (su != this.isSuperuser()) {
            if (su) {
                this.roles.add(REPO.ROLE_SUPERUSER);
            } else {
                this.roles.remove(REPO.ROLE_SUPERUSER);
            }
        }
    }

    public void setFirstName(HttpServletRequest request, String name) throws ServletException {
        this.firstName = name;
        this.setMetadataInternal(request, FOAF.FIRST_NAME, name);
    }

    public void setLastName(HttpServletRequest request, String name) throws ServletException {
        this.lastName = name;
        this.setMetadataInternal(request, FOAF.SURNAME, name);
    }

    public void setMbox(HttpServletRequest request, String mbox) throws ServletException {
        this.mbox = mbox;
        this.setMetadataInternal(request, FOAF.MBOX, mbox);
    }

    public boolean setProperty(HttpServletRequest request, URI property, String value) throws ServletException {
        if (FOAF.MBOX.equals(property)) {
            this.setMbox(request, value);
        } else if (FOAF.FIRST_NAME.equals(property)) {
            this.setFirstName(request, value);
        } else if (FOAF.SURNAME.equals(property)) {
            this.setLastName(request, value);
        } else {
            return false;
        }
        return true;
    }

    private void ensureURI(RepositoryConnection rc) throws RepositoryException {
        if (this.uri == null) {
            this.uri = User.newURI();
            log.debug((Object)("Created new URI for User username=" + this.username + ", uri=" + this.uri));
            this.initialStatements(rc);
        }
    }

    private void initialStatements(RepositoryConnection rc) throws RepositoryException {
        Literal luname = rc.getValueFactory().createLiteral(this.username);
        rc.add((Resource)this.uri, RDF.TYPE, (Value)REPO.PERSON, new Resource[]{USER_GRAPH});
        rc.add((Resource)this.uri, RDFS.LABEL, (Value)luname, new Resource[]{USER_GRAPH});
        rc.add((Resource)this.uri, REPO.HAS_PRINCIPAL_NAME, (Value)luname, new Resource[]{REPO.NG_INTERNAL});
        for (URI ruri : REPO.IMPLICIT_ROLES) {
            rc.add((Resource)this.uri, REPO.HAS_ROLE, (Value)ruri, new Resource[]{REPO.NG_INTERNAL});
        }
        AuthUser au = this.getAuthUser();
        if (au != null && au.isSuperuser()) {
            rc.add((Resource)this.uri, REPO.HAS_ROLE, (Value)REPO.ROLE_SUPERUSER, new Resource[]{REPO.NG_INTERNAL});
        }
        this.setDirty(true);
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, String newVal) throws ServletException {
        if (!Access.hasPermissionOnUser((HttpServletRequest)request, (String)this.username)) {
            throw new ForbiddenException("Not allowed to modify user: " + this.username);
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            this.ensureURI(rc);
            boolean hasProp = rc.hasStatement((Resource)this.uri, property, null, false, new Resource[]{USER_GRAPH});
            boolean hasLabel = rc.hasStatement((Resource)this.uri, RDFS.LABEL, null, false, new Resource[]{USER_GRAPH});
            ValueFactory vf = rc.getValueFactory();
            if (hasProp) {
                rc.remove((Resource)this.uri, property, null, new Resource[]{USER_GRAPH});
            }
            if (newVal != null) {
                rc.add((Resource)this.uri, property, (Value)vf.createLiteral(newVal), new Resource[]{USER_GRAPH});
            }
            String label = this.getLabel();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting User label, uri=" + this.uri + ", label=" + label));
            }
            if (hasLabel) {
                rc.remove((Resource)this.uri, RDFS.LABEL, null, new Resource[]{USER_GRAPH});
            }
            rc.add((Resource)this.uri, RDFS.LABEL, (Value)vf.createLiteral(label), new Resource[]{USER_GRAPH});
            this.setDirty(true);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void recreate(HttpServletRequest request, URI newURI, String newUsername, String pw) throws ServletException {
        if (!Access.hasPermissionOnUser((HttpServletRequest)request, (String)this.username)) {
            throw new ForbiddenException("Not allowed to modify user: " + this.username);
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (this.uri != null) {
                rc.remove((Resource)this.uri, null, null, new Resource[]{USER_GRAPH});
                rc.remove((Resource)this.uri, null, null, new Resource[]{REPO.NG_INTERNAL});
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("recreate: oldURI=" + this.uri + ", newURI=" + newURI + ", username=" + this.username));
            }
            this.uri = newURI;
            this.username = newUsername;
            this.roles.clear();
            this.roles.addAll(REPO.IMPLICIT_ROLES);
            this.firstName = null;
            this.lastName = null;
            this.mbox = null;
            if (this.uri != null) {
                this.initialStatements(rc);
            }
            if (pw != null) {
                if (this.isLoginable()) {
                    this.setPassword(request, pw);
                } else {
                    this.reinstate(pw);
                }
            }
            this.setDirty(true);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void addRole(HttpServletRequest request, URI ru) throws ServletException {
        this.addRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void addRole(HttpServletRequest request, Role r) throws ServletException {
        this.addRoleInternal(request, r, false);
    }

    public void addRoleAsAdministrator(HttpServletRequest request, Role r) throws ServletException {
        this.addRoleInternal(request, r, true);
    }

    private void addRoleInternal(HttpServletRequest request, Role r, boolean skipAccessCheck) throws ServletException {
        if (!skipAccessCheck && !Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (this.hasRoleP(r)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addRole: Already have role=" + r + ", skipping."));
            }
        } else {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            try {
                if (this.roles.add(r.getURI())) {
                    AuthUser au;
                    if (!r.isSuperuser()) {
                        this.ensureURI(rc);
                    }
                    if (this.uri != null) {
                        rc.add((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[]{REPO.NG_INTERNAL});
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Added hasRole statement: user=" + this + " => role=" + r));
                        }
                    }
                    if (r.isSuperuser() && (au = this.getAuthUser()) != null) {
                        au.setIsSuperuser(true);
                    }
                    this.setDirty(true);
                    log.debug((Object)("Added role: " + r));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Role " + r + " was already in Set."));
                }
            }
            catch (RepositoryException e) {
                log.error((Object)"Failed adding role ", (Throwable)e);
                throw new ServletException("Failed adding role ", (Throwable)e);
            }
        }
    }

    public void removeRole(HttpServletRequest request, URI ru) throws ServletException {
        this.removeRole(request, Role.find((HttpServletRequest)request, (URI)ru));
    }

    public void removeRole(HttpServletRequest request, Role r) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Only the administrator is allowed to modify user roles.");
        }
        if (!this.hasRoleP(r)) {
            return;
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            AuthUser au;
            if (!r.isSuperuser()) {
                this.ensureURI(rc);
            }
            if (this.uri != null) {
                rc.remove((Resource)this.uri, REPO.HAS_ROLE, (Value)r.getURI(), new Resource[0]);
            }
            this.roles.remove(r.getURI());
            if (r.isSuperuser() && (au = this.getAuthUser()) != null) {
                au.setIsSuperuser(false);
            }
            this.setDirty(true);
            log.debug((Object)("Removed role: " + r));
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed adding role ", (Throwable)e);
            throw new ServletException("Failed removing role ", (Throwable)e);
        }
    }

    public boolean setRoles(HttpServletRequest request, Role[] newRoles) throws ServletException {
        ArrayList<Role> addRoles = new ArrayList<Role>();
        HashSet<Role> deleteRoles = new HashSet<Role>();
        for (Role r : this.getRoles(request)) {
            if (r.isImplicit()) continue;
            deleteRoles.add(r);
        }
        for (Role r : newRoles) {
            if (deleteRoles.contains(r)) {
                deleteRoles.remove(r);
                continue;
            }
            addRoles.add(r);
        }
        if (deleteRoles.isEmpty() && addRoles.isEmpty()) {
            return false;
        }
        for (Role r : deleteRoles) {
            this.removeRole(request, r);
        }
        for (Role r : addRoles) {
            this.addRole(request, r);
        }
        return true;
    }

    public void commit(HttpServletRequest request) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        if (this.dirty) {
            if (this.auth != null) {
                this.auth.commit();
            }
            super.commit(request);
            Authentication.decacheAuthentication((HttpServletRequest)request, (User)this);
        }
        this.setDirty(false);
    }

    public static void commitMultiple(HttpServletRequest request, Collection<User> users) throws ServletException {
        try {
            ArrayList<AuthUser> aus = new ArrayList<AuthUser>();
            for (User u : users) {
                if (u.auth == null) continue;
                aus.add(u.auth);
            }
            authFactory.commitMultiple(request, aus);
            WithRepositoryConnection.get((ServletRequest)request).commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("commitMultiple: committed " + String.valueOf(users.size()) + " Users."));
            }
            for (User u : users) {
                u.setDirty(false);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("commitMultiple: clear dirty on " + u));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed in multiple commit: ", (Throwable)e);
            throw new ServletException("Failed in multiple commit ", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.dirty) {
            log.error((Object)("finalize: about to destroy a User with dirty flag set, CHANGES WILL BE LOST.  Current state: " + this.toString()));
        }
        super.finalize();
    }

    public String toString() {
        String rs = this.roles == null ? "{null}" : Arrays.deepToString(this.roles.toArray(new URI[this.roles.size()]));
        String uu = this.uri == null ? "(not set)" : this.uri.toString();
        return "<#User: uri=" + uu + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", mbox=" + this.mbox + ", roles=" + rs + ">";
    }

    public boolean equals(Object o) {
        return o instanceof User && (this.uri != null && this.uri.equals(((User)o).uri) || this.username != null && this.username.equals(((User)o).username));
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    private AuthUser getAuthUser() {
        if (this.hasAuthUser == null) {
            try {
                this.auth = authFactory.find(this.username);
            }
            catch (ServletException e) {
                log.error((Object)"failed getting authUser: ", (Throwable)e);
                throw new InternalServerErrorException((Throwable)e);
            }
            this.hasAuthUser = this.auth == null ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.auth;
    }

    private AuthUser createAuthUser(String pw) {
        this.auth = authFactory.create(this.username);
        this.auth.setPassword(pw);
        this.auth.setIsSuperuser(this.isSuperuser());
        this.hasAuthUser = Boolean.TRUE;
        return this.auth;
    }

    public boolean isLoginable() {
        if (this.hasAuthUser == null) {
            this.getAuthUser();
        }
        return this.hasAuthUser;
    }

    public boolean authenticate(String pw) {
        AuthUser au = this.getAuthUser();
        return au != null && au.authenticate(pw);
    }

    public String getPassword() {
        AuthUser au = this.getAuthUser();
        return au == null ? null : au.getPassword();
    }

    public void setPassword(HttpServletRequest request, String pw) {
        AuthUser au = this.getAuthUser();
        if (au == null) {
            log.warn((Object)("Cannot set password on user without authUser: " + this));
        } else {
            au.setPassword(pw);
            this.setDirty(true);
        }
    }

    public void disable() {
        AuthUser au = this.getAuthUser();
        if (au == null) {
            throw new IllegalStateException("Cannot disable a user who is already disabled.");
        }
        au.delete();
        this.setDirty(true);
    }

    public void reinstate(String pw) {
        if (pw == null) {
            throw new BadRequestException("Password is required to reinstate a user.");
        }
        AuthUser au = this.getAuthUser();
        if (au != null) {
            throw new IllegalStateException("Cannot reinstate a user who has not been disabled.");
        }
        au = this.createAuthUser(pw);
        this.setDirty(true);
    }

    public URI getAuthType() {
        return authFactory.getType();
    }

    public void setAuthType(HttpServletRequest request, URI uri) {
        if (!authFactory.getType().equals(uri)) {
            throw new IllegalArgumentException("Cannot accept any auth type but the built-in one, this is unacceptable: " + uri);
        }
    }

    private static URI newURI() {
        return new URIImpl(Configuration.getInstance().getDefaultNamespace() + RIDGenerator.getInstance().newID().toString());
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ String access$302(User x0, String x1) {
        x0.firstName = x1;
        return x0.firstName;
    }

    static /* synthetic */ String access$402(User x0, String x1) {
        x0.lastName = x1;
        return x0.lastName;
    }

    static /* synthetic */ String access$502(User x0, String x1) {
        x0.mbox = x1;
        return x0.mbox;
    }

    static /* synthetic */ String access$600(User x0) {
        return x0.username;
    }

    static /* synthetic */ Set access$700(User x0) {
        return x0.roles;
    }

    static {
        SPARQL.addGraph((DatasetImpl)USER_DATASET, (URI)USER_GRAPH);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User Dataset = " + Utils.prettyPrint((Dataset)USER_DATASET)));
        }
        authFactory = AuthUserTomcatFactory.getInstance();
        userForURIQuery = "SELECT * WHERE { ?uri a <" + REPO.PERSON + "> ; \n" + "<" + REPO.HAS_PRINCIPAL_NAME + "> ?hasPrincipalName .\n" + "  OPTIONAL { ?uri <" + FOAF.FIRST_NAME + "> ?firstName }\n" + "  OPTIONAL { ?uri <" + FOAF.SURNAME + "> ?surname }\n" + "  OPTIONAL { ?uri <" + FOAF.MBOX + "> ?mbox }\n" + "  OPTIONAL { ?uri <" + REPO.HAS_ROLE + "> ?hasRole . ?hasRole <" + RDFS.LABEL + "> ?roleLabel }\n" + " } ORDER BY ?hasPrincipalName";
    }
}

