/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model.workflow;

import java.util.HashSet;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.model.DataModel;
import org.eaglei.repository.model.View;
import org.eaglei.repository.model.workflow.WorkflowAction;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;

public class ActionMoveGraph
implements WorkflowAction {
    private static Logger log = LogManager.getLogger(ActionMoveGraph.class);
    private static final String statementsQuery = "CONSTRUCT { ?subject ?pred ?obj . ?obj ?eip ?eio }  WHERE { \n GRAPH ?homeGraph { ?subject ?pred ?obj } \n OPTIONAL { ?obj a ?eit . \n   ?eit <" + DataModel.EMBEDDED_INSTANCE_PREDICATE.toString() + "> <" + DataModel.EMBEDDED_INSTANCE_OBJECT.toString() + "> . \n" + "   GRAPH ?homeGraph { ?obj ?eip ?eio }}}\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransition(HttpServletRequest request, URI resource, Value param) throws Exception {
        if (param == null || !(param instanceof URI)) {
            throw new BadRequestException("ActionMoveGraph requires a valid URI parameter, naming the destination graph.");
        }
        URI newGraph = (URI)param;
        URI homeGraph = null;
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        homeGraph = Utils.getHomeGraph((RepositoryConnection)rc, (URI)resource);
        if (homeGraph == null) {
            log.error((Object)("Failed to find home graph for resource instance=" + resource));
            throw new InternalServerErrorException("Failed to find home graph for resource instance=" + resource);
        }
        if (homeGraph.equals(newGraph)) {
            log.warn((Object)("Tried to move resource inst=" + resource + " to the same named graph: " + homeGraph));
            return;
        }
        HashSet<URI> subjects = new HashSet<URI>();
        DatasetImpl qds = new DatasetImpl();
        View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)qds, (URI)homeGraph);
        GraphQuery sq = rc.prepareGraphQuery(QueryLanguage.SPARQL, statementsQuery);
        sq.setIncludeInferred(true);
        sq.setDataset((Dataset)qds);
        sq.setBinding("subject", (Value)resource);
        sq.setBinding("homeGraph", (Value)homeGraph);
        GraphQueryResult sqr = sq.evaluate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SPARQL Query to get statements, ?subject=" + resource + ", ?homeGraph=" + homeGraph + "\n" + statementsQuery));
            log.debug((Object)("Moving statements from " + homeGraph + " to " + newGraph));
        }
        try {
            while (sqr.hasNext()) {
                Statement s = (Statement)sqr.next();
                subjects.add((URI)s.getSubject());
                rc.add(s, new Resource[]{newGraph});
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Moving statement: { " + s.getSubject() + " " + s.getPredicate() + " " + s.getObject() + " }"));
            }
        }
        finally {
            sqr.close();
        }
        for (URI subject : subjects) {
            rc.remove((Resource)subject, null, null, new Resource[]{homeGraph});
        }
    }
}

