/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.model.ImmutableObjectModel;
import org.eaglei.repository.model.workflow.WorkflowState;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
@HasContentCache
public class WorkflowState
extends ImmutableObjectModel
implements Comparable {
    private static Logger log = LogManager.getLogger(WorkflowState.class);
    private URI uri;
    private String label = null;
    private String comment = null;
    private static volatile Map<URI, WorkflowState> cacheInternal = null;
    private static volatile List<WorkflowState> cacheListInternal = null;
    private static final String stateQuery = "SELECT DISTINCT * WHERE {  ?uri a <" + REPO.WORKFLOW_STATE + "> ; \n" + "  <" + RDFS.LABEL + "> ?label ; " + "  <" + REPO.ORDER + "> ?order \n" + " OPTIONAL { ?uri <" + RDFS.COMMENT + "> ?comment }" + "} ORDER BY ?order";

    private WorkflowState(URI uri, String label, String comment) {
        this.uri = uri;
        this.label = label;
        this.comment = comment;
    }

    public static WorkflowState find(HttpServletRequest request, URI uri) throws ServletException {
        Map cache = WorkflowState.getCache((HttpServletRequest)request);
        if (cache.containsKey(uri)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("State.find(" + uri.stringValue() + ") => " + cache.get(uri)));
            }
            return (WorkflowState)cache.get(uri);
        }
        throw new NotFoundException("There is no State of URI=" + uri);
    }

    public static List<WorkflowState> findAll(HttpServletRequest request) throws ServletException {
        return WorkflowState.getCacheList((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decache() {
        Class<WorkflowState> clazz = WorkflowState.class;
        synchronized (WorkflowState.class) {
            cacheInternal = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<URI, WorkflowState> getCache(HttpServletRequest request) throws ServletException {
        Class<WorkflowState> clazz = WorkflowState.class;
        synchronized (WorkflowState.class) {
            if (cacheInternal != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return cacheInternal;
            }
            cacheInternal = new HashMap();
            cacheListInternal = new ArrayList();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                log.debug((Object)("All State SPARQL query = " + stateQuery));
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, stateQuery);
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.setIncludeInferred(false);
                q.evaluate((TupleQueryResultHandler)new allStateHandler(cacheInternal, cacheListInternal));
            }
            catch (MalformedQueryException e) {
                log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
                throw new ServletException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            return cacheInternal;
        }
    }

    private static List<WorkflowState> getCacheList(HttpServletRequest request) throws ServletException {
        WorkflowState.getCache((HttpServletRequest)request);
        return cacheListInternal;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getLabel() {
        return this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object other) {
        return other instanceof WorkflowState && this.uri.equals(((WorkflowState)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "<#State: uri=" + this.uri.toString() + ", label=" + this.label + ">";
    }

    public int compareTo(Object o) {
        return this.label.compareTo(((WorkflowState)o).label);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

