/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.model.Transporter;
import org.eaglei.repository.model.View;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.Utils;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class ImportExport
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(ImportExport.class);
    private boolean isImport = false;
    private boolean isExport = false;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.isExport = sc.getInitParameter("export") != null;
        boolean bl = this.isImport = sc.getInitParameter("import") != null;
        if (!this.isExport && !this.isImport) {
            log.error((Object)"Servlet was initialized without either import or export mode set, THIS IS BAD.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mimeType;
        RDFFormat format;
        if (!this.isExport) {
            throw new HttpStatusException(501, "GET is not implemented by this service");
        }
        request.setCharacterEncoding("UTF-8");
        String rawFormat = this.getParameter(request, "format", false);
        String rawView = this.getParameter(request, "view", false);
        String rawWorkspace = this.getParameter(request, "workspace", false);
        String rawType = this.getParameter(request, "type", true);
        String include = this.getParameter(request, "include", false);
        String exclude = this.getParameter(request, "exclude", false);
        TypeArg type = (TypeArg)Utils.parseKeywordArg(TypeArg.class, (String)rawType, (String)"type", (boolean)true, null);
        View view = (View)Utils.parseKeywordArg(View.class, (String)rawView, (String)"view", (boolean)false, null);
        URI workspace = Utils.parseURI((String)rawWorkspace, (String)"workspace", (boolean)false);
        if (workspace != null && view != null) {
            throw new BadRequestException("Only one of the 'workspace' or 'view' args may be specified.");
        }
        if (workspace == null && view == null) {
            view = type == TypeArg.resource ? View.USER_RESOURCES : View.USER;
        }
        Set includes = this.parseXCludeList(include);
        Set excludes = this.parseXCludeList(exclude);
        if (log.isDebugEnabled()) {
            log.debug((Object)("INCLUDES = " + Arrays.deepToString(includes.toArray())));
            log.debug((Object)("EXCLUDES = " + Arrays.deepToString(excludes.toArray())));
        }
        if ((format = Formats.RDFOutputFormatForMIMEType((String)(mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)rawFormat)))) == null) {
            throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + mimeType + "\"");
        }
        if (!format.supportsContexts()) {
            throw new HttpStatusException(415, "Format does not support quad (graph) encoding: " + format);
        }
        log.debug((Object)("Output serialization format = " + format));
        Transporter tp = type.getTransporter();
        if (tp == null) {
            throw new HttpStatusException(501, "Export of " + type + " is not implemented.");
        }
        tp.authorizeExport(request);
        tp.doExport(request, response, format, includes, excludes);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isExport) {
            this.doGet(request, response);
            return;
        }
        if (!this.isImport) {
            throw new HttpStatusException(501, "Servlet must be configured for import or export.");
        }
        request.setCharacterEncoding("UTF-8");
        TypeArg type = (TypeArg)this.getParameterAsKeyword(request, "type", TypeArg.class, null, true);
        Reader content = this.getParameterAsReader(request, "content", true);
        String contentType = this.getParameterContentType(request, "content");
        String rawFormat = this.getParameter(request, "format", false);
        String include = this.getParameter(request, "include", false);
        String exclude = this.getParameter(request, "exclude", false);
        boolean transform = this.getParameterAsBoolean(request, "transform", false, true);
        boolean ignoreACL = this.getParameterAsBoolean(request, "ignoreACL", false, false);
        DuplicateArg duplicate = (DuplicateArg)this.getParameterAsKeyword(request, "duplicate", DuplicateArg.class, (Enum)DuplicateArg.abort, false);
        Set includes = this.parseXCludeList(include);
        Set excludes = this.parseXCludeList(exclude);
        if (log.isDebugEnabled()) {
            log.debug((Object)("INCLUDES = " + Arrays.deepToString(includes.toArray())));
            log.debug((Object)("EXCLUDES = " + Arrays.deepToString(excludes.toArray())));
            log.debug((Object)("duplicate = " + duplicate));
        }
        if (rawFormat == null) {
            rawFormat = contentType;
        }
        if (rawFormat == null) {
            throw new BadRequestException("Missing required argument: format (or content-type on input)");
        }
        String mime = Utils.contentTypeGetMIMEType((String)rawFormat);
        RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mime);
        if (format == null) {
            throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + mime + "\"");
        }
        if (!format.supportsContexts()) {
            throw new HttpStatusException(415, "Format does not support quad (graph) encoding: " + format);
        }
        log.debug((Object)("Input serialization format = " + format));
        SailRepository mr = null;
        RepositoryConnection mrc = null;
        try {
            mr = new SailRepository((Sail)new MemoryStore());
            mr.initialize();
            mrc = mr.getConnection();
            mrc.add(content, "", format, new Resource[0]);
            Transporter tp = type.getTransporter();
            if (tp == null) {
                throw new HttpStatusException(501, "Import of " + type + " is not implemented.");
            }
            tp.authorizeImport(request);
            tp.doImport(request, response, mrc, includes, excludes, duplicate, transform, ignoreACL);
            WithRepositoryConnection.get((ServletRequest)request).commit();
        }
        catch (OpenRDFException e) {
            log.error((Object)"Failed loading import content or calling import: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (mrc != null && mrc.isOpen()) {
                    mrc.close();
                }
                if (mr != null) {
                    mr.shutDown();
                }
            }
            catch (RepositoryException e) {
                log.error((Object)"Failed while closing temporary repo of import content: ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private Set<String> parseXCludeList(String s) {
        HashSet<String> result = new HashSet<String>();
        if (s != null) {
            for (String e : s.split("\\s*,\\s*")) {
                result.add(e);
            }
        }
        return result;
    }
}

