/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.model.DataModel;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.servlet.Model;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.util.AppendingRDFHandler;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class Model
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Model.class);
    private static final String SOURCE_JAR = "jar";
    private static final String SOURCE_MODEL = "model";

    public void init() {
    }

    private String getJarTopLevelPath() {
        return DataModel.VERSION_INFO_SOURCE.getString();
    }

    private String getLoadedVersion(RepositoryConnection rc) throws RepositoryException {
        return Utils.getVersionInfo((RepositoryConnection)rc, (URI)DataModel.VERSION_INFO_URI.getURI(), (URI)DataModel.GRAPH_URI.getURI());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        if (this.isParameterPresent(request, "action")) {
            throw new BadRequestException("The 'action' argument is not allowed in the GET method, use POST.");
        }
        String format = this.getParameter(request, "format", false);
        log.debug((Object)("/model GET, format=" + format));
        try {
            String availableJarVersion;
            String availableModelVersion;
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            String loadedVersion = this.getLoadedVersion(rc);
            if (loadedVersion == null) {
                loadedVersion = "(not loaded or not in ontology)";
            }
            if ((availableModelVersion = this.getAvailableModelVersionInfo()) == null) {
                availableModelVersion = "(failed or not in ontology)";
            }
            if ((availableJarVersion = this.getAvailableJarVersionInfo()) == null) {
                availableJarVersion = "(failed or not in Jar or War)";
            }
            ArrayList<MapBindingSet> results = new ArrayList<MapBindingSet>(1);
            MapBindingSet bs = new MapBindingSet(2);
            ValueFactory vf = rc.getValueFactory();
            bs.addBinding("loaded", (Value)vf.createLiteral(loadedVersion));
            bs.addBinding("availableJar", (Value)vf.createLiteral(availableJarVersion));
            bs.addBinding("availableModel", (Value)vf.createLiteral(availableModelVersion));
            results.add(bs);
            SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, results);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean force = false;
        long count = 0L;
        long modTime = -1L;
        String action = this.getParameter(request, "action", true);
        String source = this.getParameter(request, "source", true);
        log.debug((Object)("/model POST, action=" + action + ", source=" + source));
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        URI context = DataModel.GRAPH_URI.getURI();
        if (action.equals("load")) {
            force = true;
        } else if (!action.equals("update")) {
            throw new BadRequestException("Argument action must be one of: 'load', 'update'");
        }
        if (!Access.hasPermission((HttpServletRequest)request, (Resource)context, (Access)Access.ADD) || !Access.hasPermission((HttpServletRequest)request, (Resource)context, (Access)Access.REMOVE)) {
            throw new ForbiddenException("User is not permitted to replace the data model ontology graph");
        }
        if (source.equals(SOURCE_MODEL)) {
            throw new HttpStatusException(501, "Loading or updating from the OntModel source is no longer implemented.");
        }
        try {
            boolean created = rc.size(new Resource[]{context}) == 0L;
            String loadedVersion = this.getLoadedVersion(rc);
            String availableVersion = source.equals(SOURCE_JAR) ? this.getAvailableJarVersionInfo() : this.getAvailableModelVersionInfo();
            String sourceLoaded = null;
            log.debug((Object)("availableVersion=" + availableVersion + ", loadedVersion=" + loadedVersion));
            if (availableVersion == null) {
                throw new ServletException("Failed to get version of available data model ontology from chosen source, perhaps failed to load ontology.  Try force-loading instead.");
            }
            if (force || loadedVersion == null || this.versionNewer(availableVersion, loadedVersion)) {
                if (log.isDebugEnabled()) {
                    if (force) {
                        log.debug((Object)"Forced reload of data model ontology.");
                    } else {
                        log.debug((Object)("Updating data model ontology: loaded=" + loadedVersion + ", available=" + availableVersion));
                    }
                }
                rc.clear(new Resource[]{context});
                if (!source.equals(SOURCE_JAR)) {
                    throw new BadRequestException("Argument source must be one of: 'model', 'jar'");
                }
                String toplevel = this.getJarTopLevelPath();
                String jar = this.getDataModelJarSpec(toplevel);
                rc.commit();
                modTime = this.loadDataModelFromJar(rc, context, toplevel, jar);
                sourceLoaded = jar;
                NamedGraph ng = NamedGraph.findOrCreate((HttpServletRequest)request, (URI)context, (boolean)true);
                ng.setType(request, NamedGraphType.ontology);
                ng.setLabel(request, "eagle-i Data Model Ontology");
                AccessGrant.addGrant((HttpServletRequest)request, (URI)context, (URI)REPO.ROLE_ANONYMOUS, (URI)Access.READ.getURI());
                Date now = new Date();
                Provenance p = new Provenance(context);
                if (created) {
                    p.setCreated(request, now);
                } else {
                    p.setModified(request, now);
                }
                Date sourceModified = null;
                if (modTime != -1L) {
                    sourceModified = new Date(modTime);
                }
                p.setSource(request, sourceLoaded, sourceModified);
                rc.commit();
                response.setStatus(201);
            } else {
                response.setStatus(200);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    private String getAvailableJarVersionInfo() throws ServletException, IOException {
        String toplevel = this.getJarTopLevelPath();
        String jarURLspec = this.getDataModelJarSpec(toplevel);
        log.debug((Object)("Getting maven version from jar at: " + jarURLspec));
        return Utils.getMavenVersionFromJar((String)jarURLspec);
    }

    private String getAvailableModelVersionInfo() {
        return null;
    }

    private String getDataModelJarSpec(String toplevel) throws ServletException {
        URL ero = this.getClass().getClassLoader().getResource(toplevel);
        if (ero == null) {
            throw new ServletException("Cannot load data model OWL, since the top-level file \"" + toplevel + "\"  is not available as a resource.  Check your configuration.");
        }
        String eros = ero.toString();
        if (eros.startsWith("jar:")) {
            Pattern ep = Pattern.compile("jar:([^!]+)!/" + Pattern.quote(toplevel));
            log.debug((Object)("Groveling jar URL with pattern=\"" + ep.pattern() + "\""));
            Matcher em = ep.matcher(eros);
            if (em.matches()) {
                String jarURLspec = em.group(1);
                log.debug((Object)("Got jar URL = " + jarURLspec));
                return jarURLspec;
            }
            log.warn((Object)("Failed matching pattern=\"" + ep.pattern() + "\" against owl resource URL=" + eros));
            throw new ServletException("Failed to extract jar's URL from resource (see log for details): " + eros);
        }
        log.warn((Object)("Cannot load data model OWL, URL for the toplevel file is NOT in Jar scheme: " + eros));
        throw new ServletException("Cannot load data model OWL, URL for the toplevel file is NOT in Jar scheme: " + eros);
    }

    private long loadDataModelFromJar(RepositoryConnection rc, URI context, String toplevel, String jarURLspec) throws ServletException, IOException {
        long result = -1L;
        log.info((Object)("Loading data model from jar at: " + jarURLspec));
        ZipInputStream jis = null;
        File tmpFile = File.createTempFile("datamodel", ".txt", (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir"));
        AppendingRDFHandler ah = new AppendingRDFHandler((RDFHandler)Rio.createWriter((RDFFormat)RDFFormat.NTRIPLES, (Writer)new FileWriter(tmpFile)));
        RDFParser op = Rio.createParser((RDFFormat)RDFFormat.RDFXML);
        op.setRDFHandler((RDFHandler)ah);
        try {
            JarEntry je;
            URL jarURL = new URL(jarURLspec);
            jis = new JarInputStream(jarURL.openStream());
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                if (je.isDirectory()) continue;
                String fn = je.getName();
                if (fn.endsWith(".owl")) {
                    log.info((Object)("..Adding OWL statements from jar entry: " + fn));
                    try {
                        op.parse((InputStream)new UnclosableInputStream(this, (InputStream)jis, null), "");
                    }
                    catch (RDFParseException e) {
                        log.error((Object)("Skipping file=" + fn + ", failed parsing: " + (Object)((Object)e)));
                    }
                    if (!fn.equals(toplevel) && !fn.equals("/" + toplevel)) continue;
                    result = je.getTime();
                    log.debug((Object)("Found toplevel entry, setting mod time = " + result));
                    continue;
                }
                log.info((Object)("..Skipping non-OWL jar file = " + fn));
            }
            ah.reallyEndRDF();
            ah = null;
            rc.add(tmpFile, "", RDFFormat.NTRIPLES, new Resource[]{context});
            log.info((Object)("Loaded merged data model ontology, size = " + String.valueOf(rc.size(new Resource[]{context})) + " statements."));
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (jis != null) {
                jis.close();
            }
            if (ah != null) {
                try {
                    ah.reallyEndRDF();
                }
                catch (RDFHandlerException ie) {
                    log.warn((Object)("Failed closing merged ontology file: " + (Object)((Object)ie)));
                }
            }
            tmpFile.delete();
        }
        return result;
    }

    boolean versionNewer(String av1, String av2) throws NumberFormatException, ServletException {
        String[] v01 = av1.trim().split("\\s");
        String[] v02 = av2.trim().split("\\s");
        if (!v01[0].matches("^[0-9\\.]+$")) {
            throw new ServletException("Cannot compare badly formatted version number: \"" + v01[0] + "\"");
        }
        if (!v02[0].matches("^[0-9\\.]+$")) {
            throw new ServletException("Cannot compare badly formatted version number: \"" + v02[0] + "\"");
        }
        Object[] v1 = v01[0].split("\\.");
        Object[] v2 = v02[0].split("\\.");
        log.debug((Object)("versionNewer: Raw versions = " + Arrays.deepToString(v1) + ", " + Arrays.deepToString(v2)));
        int len = v1.length > v2.length ? v1.length : v2.length;
        for (int i = 0; i < len; ++i) {
            int c2;
            int c1 = i < v1.length ? Integer.parseInt((String)v1[i]) : 0;
            int n = c2 = i < v2.length ? Integer.parseInt((String)v2[i]) : 0;
            if (c1 > c2) {
                log.debug((Object)("versionNewer: " + v01[0] + " is newer than " + v02[0]));
                return true;
            }
            if (c2 <= c1) continue;
            log.debug((Object)("versionNewer: " + v01[0] + " is older than " + v02[0]));
            return false;
        }
        log.debug((Object)("versionNewer: " + v01[0] + " is equal to " + v02[0]));
        return false;
    }

    private void tryVersionNewer(String v1, String v2, boolean expected) {
        try {
            boolean result = this.versionNewer(v1, v2);
            log.debug((Object)("Trying versionNewer(\"" + v1 + "\", \"" + v2 + "\") => " + (result == expected ? "success" : "FAIL") + ", expected=" + expected));
        }
        catch (Exception e) {
            log.error((Object)"Failed with exception: ", (Throwable)e);
        }
    }
}

