/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Lifecycle;

public class RepositoryContextListener
implements ServletContextListener {
    private static Logger log = LogManager.getLogger(RepositoryContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        try {
            Lifecycle.initialize((ServletContext)sce.getServletContext());
        }
        catch (Exception e) {
            log.error((Object)"Got exception in Webapp context initialization, EXPECT NOTHING WILL WORK:", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Lifecycle lc = Lifecycle.getInstance();
        if (lc == null) {
            log.error((Object)"Data Repository was not successfully initialized, cannot destroy!");
        } else {
            try {
                lc.destroy(sce.getServletContext());
            }
            catch (Exception e) {
                log.error((Object)"Got exception in Webapp context finalization, but forging ahead:", (Throwable)e);
            }
        }
        LogManager.shutdown();
    }
}

