/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.User;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.util.SPARQL;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.impl.MapBindingSet;

public class WhoAmI
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WhoAmI.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        if (this.isParameterPresent(request, "create")) {
            throw new BadRequestException("'create' arg is only allowed with POST method");
        }
        this.whoami(request, response, this.getParameter(request, "format", false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        boolean create = this.getParameterAsBoolean(request, "create", false, false);
        String firstName = this.getParameter(request, "firstname", false);
        String lastName = this.getParameter(request, "lastname", false);
        String mbox = this.getParameter(request, "mbox", false);
        String format = this.getParameter(request, "format", false);
        if (create) {
            String login = Authentication.getAuthenticatedUsername((HttpServletRequest)request);
            User u = Authentication.getPrincipalUser((HttpServletRequest)request);
            if (login == null) {
                throw new BadRequestException("No authentication found.");
            }
            if (u == null) {
                throw new ServletException("Cannot create User for login=" + login);
            }
            if (u.getURI() != null) throw new ConflictException("There is already User metadata for login name = " + login);
            u = User.createAsAdministrator((HttpServletRequest)request, (String)login, null);
            if (firstName != null) {
                u.setFirstName(request, firstName);
            }
            if (lastName != null) {
                u.setLastName(request, lastName);
            }
            if (mbox != null) {
                u.setMbox(request, mbox);
            }
            u.commit(request);
            response.setStatus(201);
            return;
        } else {
            this.whoami(request, response, format);
        }
    }

    private void whoami(HttpServletRequest request, HttpServletResponse response, String format) throws ServletException, IOException {
        ArrayList<MapBindingSet> result = new ArrayList<MapBindingSet>();
        MapBindingSet nbs = new MapBindingSet(6);
        User u = Authentication.getPrincipalUser((HttpServletRequest)request);
        log.debug((Object)("authenticated User = " + u));
        if (u == null) {
            nbs.addBinding("uri", (Value)Authentication.getPrincipalURI((HttpServletRequest)request));
            nbs.addBinding("username", null);
            nbs.addBinding("firstname", null);
            nbs.addBinding("lastname", null);
            nbs.addBinding("mbox", null);
        } else {
            nbs.addBinding("uri", (Value)u.getURI());
            nbs.addBinding("username", (Value)new LiteralImpl(u.getUsername()));
            nbs.addBinding("firstname", (Value)(u.getFirstName() == null ? null : new LiteralImpl(u.getFirstName())));
            nbs.addBinding("lastname", (Value)(u.getLastName() == null ? null : new LiteralImpl(u.getLastName())));
            nbs.addBinding("mbox", (Value)(u.getMbox() == null ? null : new LiteralImpl(u.getMbox())));
        }
        nbs.addBinding("isSuperuser", (Value)(Authentication.isSuperuser((HttpServletRequest)request) ? BooleanLiteralImpl.TRUE : BooleanLiteralImpl.FALSE));
        result.add(nbs);
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, result);
    }
}

