/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.model.View;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public class SPARQL {
    private static Logger log = LogManager.getLogger(SPARQL.class);
    public static final DatasetImpl InternalGraphs = new DatasetImpl();
    private static DatasetImpl InternalAndMetadataGraphs;

    private SPARQL() {
    }

    public static Dataset getInternalAndMetadataGraphs(HttpServletRequest request) {
        if (InternalAndMetadataGraphs == null) {
            InternalAndMetadataGraphs = SPARQL.copyDataset((Dataset)InternalGraphs);
            View.addGraphs((HttpServletRequest)request, (DatasetImpl)InternalAndMetadataGraphs, (View)View.METADATA);
        }
        return InternalAndMetadataGraphs;
    }

    public static DatasetImpl copyDataset(Dataset src) {
        DatasetImpl result = new DatasetImpl();
        for (URI g : src.getDefaultGraphs()) {
            result.addDefaultGraph(g);
        }
        for (URI g : src.getNamedGraphs()) {
            result.addNamedGraph(g);
        }
        return result;
    }

    public static void addGraph(DatasetImpl ds, URI graphName) {
        ds.addDefaultGraph(graphName);
        ds.addNamedGraph(graphName);
    }

    public static void tupleQueryRequest(HttpServletRequest request, HttpServletResponse response, String query, String format, Dataset ds) throws ServletException, IOException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying SPARQL query = " + query));
            log.debug((Object)("Dataset for SPARQL query = " + Utils.prettyPrint((Dataset)ds)));
        }
        TupleQuery q = null;
        try {
            q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query);
        }
        catch (MalformedQueryException e) {
            log.info((Object)"Rejecting malformed query.");
            throw new InternalServerErrorException("Malformed query was generated internally: " + e.toString(), (Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        q.setIncludeInferred(true);
        q.setDataset(ds);
        String mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format);
        TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
        if (tqf == null) {
            log.error((Object)("Failed to get tuple query format, for mime=" + mimeType));
            throw new ServletException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
        }
        response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
        try {
            q.evaluate((TupleQueryResultHandler)QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream()));
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public static void sendTupleQueryResults(HttpServletRequest request, HttpServletResponse response, String format, Iterable<BindingSet> bindings) throws ServletException, IOException {
        String mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format);
        TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
        if (tqf == null) {
            log.error((Object)("Failed to get tuple query format, for mime=" + mimeType));
            throw new ServletException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
        }
        response.setContentType(Utils.makeContentType((String)mimeType, (String)"UTF-8"));
        try {
            TupleQueryResultWriter h = QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream());
            Iterator<BindingSet> bi = bindings.iterator();
            if (bi.hasNext()) {
                BindingSet first = bi.next();
                Set bns = first.getBindingNames();
                h.startQueryResult(Arrays.asList(bns.toArray(new String[bns.size()])));
                h.handleSolution(first);
                while (bi.hasNext()) {
                    h.handleSolution(bi.next());
                }
                h.endQueryResult();
            } else {
                h.startQueryResult(new ArrayList(0));
                h.endQueryResult();
            }
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static {
        SPARQL.addGraph((DatasetImpl)InternalGraphs, (URI)REPO.NAMESPACE_URI);
        SPARQL.addGraph((DatasetImpl)InternalGraphs, (URI)REPO.NG_INTERNAL);
        InternalAndMetadataGraphs = null;
    }
}

