package org.eaglei.repository.vocabulary;

import java.util.List;
import java.util.ArrayList;
import java.util.Collections;

import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.URI;

/**
 * Constants from the Repository RDF namespace;
 * URIs of useful classes and properties.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class REPO
{
    private REPO()
    {
    }

    /** Repository Ontology Namespace Preifx (and URI of Named Graph) */
    public static final String NAMESPACE = "http://eagle-i.org/ont/repo/1.0/";
    /** Constant <code>NAMESPACE_URI</code> */
    public static final URI NAMESPACE_URI =  new URIImpl(NAMESPACE);

    /** --------------------- Named Graph URIs */

    /** NamedGraph type */
    public static final URI NAMED_GRAPH =  makeURI("NamedGraph");

    /** Repo Ontology graph */
    public static final URI NG_REPO_ONTOLOGY =  makeURI("");

    /** like owl:versionInfo  */
    public static final URI VERSION_INFO =  makeURI("versionInfo");

    /** Internal Metadata graph */
    public static final URI NG_INTERNAL =  makeURI("NG_Internal");

    /** Publically-Visible Metadata graph */
    public static final URI NG_METADATA =  makeURI("NG_Metadata");

    /** Published Data graph */
    public static final URI NG_PUBLISHED =  makeURI("NG_Published");

    /** Withdrawn Data graph */
    public static final URI NG_WITHDRAWN =  makeURI("NG_Withdrawn");

    /** Repository Users (like published, but separate) graph */
    public static final URI NG_USERS =  makeURI("NG_Users");

    /** Default Workspace graph */
    public static final URI NG_DEFAULT_WORKSPACE =  makeURI("NG_DefaultWorkspace");

    /** Graph for inferred statements */
    public static final URI NG_INFERRED =  makeURI("NG_Inferred");

    /** Constant <code>NG_QUERY</code> */
    public static final URI NG_QUERY =  makeURI("NG_Query");

    /** Functional Property describing type of a named graph */
    public static final URI NG_TYPE =  makeURI("ngType");

    /** Type of named graph that contains ontology data */
    public static final URI NGTYPE_ONTOLOGY =  makeURI("NGType_Ontology");

    /** Type of named graph */
    public static final URI NGTYPE_METADATA =  makeURI("NGType_Metadata");

    /** Type of named graph */
    public static final URI NGTYPE_WORKSPACE =  makeURI("NGType_Workspace");

    /** Type of named graph */
    public static final URI NGTYPE_PUBLISHED =  makeURI("NGType_Published");

    /** Type of named graph */
    public static final URI NGTYPE_INTERNAL =  makeURI("NGType_Internal");

    /** wildcard URI for update servlet */
    public static final URI MATCH_ANYTHING =  makeURI("MatchAnything");

    /** ------------- Useful URIs */
    /** :hasPrincipalName property */
    public static final URI HAS_PRINCIPAL_NAME = makeURI("hasPrincipalName");

    /** the Authenticated meta-role */
    public static final URI ROLE_AUTHENTICATED = makeURI("Role_Authenticated");

    /** the Anonymous meta-role */
    public static final URI ROLE_ANONYMOUS = makeURI("Role_Anonymous");

    /** the Superuser role */
    public static final URI ROLE_SUPERUSER = makeURI("Role_Superuser");

    /** "implicit" role URIs that should be added to EVERY user as statements. */
    public static final List<URI> IMPLICIT_ROLES = new ArrayList<URI>();
    static {
        Collections.addAll(IMPLICIT_ROLES,
                           REPO.ROLE_AUTHENTICATED, REPO.ROLE_ANONYMOUS);
    };

    /** Role Class */
    public static final URI ROLE = makeURI("Role");

    /** hasRole property */
    public static final URI HAS_ROLE = makeURI("hasRole");

    /** isImplicit property */
    public static final URI IS_IMPLICIT = makeURI("isImplicit");

    /** Person class */
    public static final URI PERSON = makeURI("Person");

    /** Agent class */
    public static final URI AGENT = makeURI("Agent");

    /** Access properties */

    /** Constant <code>HAS_ANY_ACCESS</code> */
    public static final URI HAS_ANY_ACCESS    = makeURI("hasAnyAccess");
    /** Constant <code>HAS_READ_ACCESS</code> */
    public static final URI HAS_READ_ACCESS   = makeURI("hasReadAccess");
    /** Constant <code>HAS_ADD_ACCESS</code> */
    public static final URI HAS_ADD_ACCESS    = makeURI("hasAddAccess");
    /** Constant <code>HAS_REMOVE_ACCESS</code> */
    public static final URI HAS_REMOVE_ACCESS = makeURI("hasRemoveAccess");
    /** Constant <code>HAS_ADMIN_ACCESS</code> */
    public static final URI HAS_ADMIN_ACCESS  = makeURI("hasAdminAccess");

    /** hasEditToken property */
    public static final URI HAS_EDIT_TOKEN = makeURI("hasEditToken");

    /**
     * Utility to create a URI in the REPO namespace out of the given suffix.
     *
     * @param id a {@link java.lang.String} object.
     * @return a {@link org.openrdf.model.URI} object.
     */
    public static URI makeURI(String id)
    {
        return new URIImpl(NAMESPACE+id);
    }

    /** Fake Workflow properties */
    public static final URI HAS_WORKFLOW_STATE  = makeURI("hasWorkflowState");
    /** Constant <code>HAS_WORKFLOW_OWNER</code> */
    public static final URI HAS_WORKFLOW_OWNER  = makeURI("hasWorkflowOwner");

    /** class */
    public static final URI WORKFLOW_STATE  = makeURI("WorkflowState");

    /** workflow state instances */
    public static final URI WFS_NEW = makeURI("WFS_New");
    public static final URI WFS_DRAFT = makeURI("WFS_Draft");
    /** Constant <code>WFS_CURATION</code> */
    public static final URI WFS_CURATION = makeURI("WFS_Curation");
    /** Constant <code>WFS_PUBLISHED</code> */
    public static final URI WFS_PUBLISHED = makeURI("WFS_Published");
    /** Constant <code>WFS_WITHDRAWN</code> */
    public static final URI WFS_WITHDRAWN = makeURI("WFS_Withdrawn");

    /** query macro type and properties */
    public static final URI QUERY_MACRO = makeURI("QueryMacro");
    /** Constant <code>QUERY</code> */
    public static final URI QUERY = makeURI("query");

    /** special keyword used in /harvest results as predicate in deleted flag */
    public static final URI IS_DELETED = makeURI("isDeleted");

    /** workflow transition class */
    public static final URI WORKFLOW_TRANSITION  = makeURI("WorkflowTransition");

    /** some properties of workflow transition class */
    public static final URI INITIAL  = makeURI("initial");
    public static final URI FINAL  = makeURI("final");
    public static final URI ACTION = makeURI("action");
    public static final URI ACTION_PARAMETER = makeURI("actionParameter");
    public static final URI WORKSPACE =  makeURI("workspace");
    public static final URI ORDER =  makeURI("order");

}
