/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.auth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.AuthUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthUserTomcat
implements AuthUser {
    private static Logger log = LogManager.getLogger(AuthUserTomcat.class);
    private static final String AUTH_DATASOURCE = "jdbc/eaglei";
    private String username;
    private String password;
    private boolean isSuperuser;
    private String oldPassword;
    private boolean oldIsSuperuser;
    private boolean isCreated = false;
    private boolean isDeleted = false;
    private boolean dirty = false;

    public AuthUserTomcat(String u, String p, boolean s) {
        this.username = u;
        this.oldPassword = this.password = p;
        this.oldIsSuperuser = this.isSuperuser = s;
    }

    public void create() {
        this.isCreated = true;
        this.dirty = true;
    }

    private static void nameCheck(String s, String field) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) && c < '\u0100' || c == '~' || c == '@' || c == '#' || c == '$' || c == '%' || c == '_' || c == '-' || c == '.') continue;
            throw new IllegalArgumentException(field + " contains an illegal character: '" + c + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreate(Connection c) throws NamingException, SQLException {
        AuthUserTomcat.nameCheck((String)this.username, (String)"Username");
        if (this.password != null) {
            AuthUserTomcat.nameCheck((String)this.password, (String)"Password");
        }
        if (this.username.length() == 0) {
            throw new IllegalArgumentException("Username may not be empty.");
        }
        PreparedStatement iu = null;
        Statement ia = null;
        Statement ir = null;
        try {
            iu = c.prepareStatement("INSERT INTO Users (Username, Password) VALUES (?, ?)");
            iu.setString(1, this.username);
            iu.setString(2, this.password);
            if (iu.executeUpdate() != 1) {
                throw new SQLException("INSERT INTO Users failed, row count incorrect.");
            }
            ia = c.prepareStatement("INSERT INTO Roles (RoleName, Username) VALUES ('authenticated', ?)");
            ia.setString(1, this.username);
            if (ia.executeUpdate() != 1) {
                throw new SQLException("INSERT INTO Roles failed, row count incorrect.");
            }
            if (this.isSuperuser) {
                ir = c.prepareStatement("INSERT INTO Roles (RoleName, Username) VALUES (?, ?)");
                ir.setString(1, "superuser");
                ir.setString(2, this.username);
                if (ir.executeUpdate() != 1) {
                    throw new SQLException("INSERT INTO Roles failed, row count incorrect.");
                }
            }
            log.debug((Object)("Created Auth DB entries for user=" + this.username));
            this.isCreated = false;
        }
        finally {
            if (iu != null) {
                iu.close();
            }
            if (ia != null) {
                ia.close();
            }
            if (ir != null) {
                ir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Connection c) throws NamingException, SQLException {
        if (this.password.equals(this.oldPassword) && this.isSuperuser == this.oldIsSuperuser) {
            return;
        }
        Statement iu = null;
        Statement ir = null;
        try {
            if (!this.password.equals(this.oldPassword)) {
                iu = c.prepareStatement("UPDATE Users SET Password = ? WHERE Username = ?");
                iu.setString(1, this.password);
                iu.setString(2, this.username);
                if (iu.executeUpdate() != 1) {
                    throw new SQLException("UPDATE Users failed, row count incorrect.");
                }
            }
            if (this.isSuperuser != this.oldIsSuperuser) {
                ir = c.prepareStatement(this.isSuperuser ? "INSERT INTO Roles (Username, RoleName) VALUES (?, ?)" : "DELETE FROM Roles WHERE (Username = ?) AND (rolename = ?)");
                ir.setString(1, this.username);
                ir.setString(2, "superuser");
                if (ir.executeUpdate() != 1) {
                    throw new SQLException("Update: Modification of Roles failed, row count incorrect.");
                }
            }
            log.debug((Object)("Updated Auth DB entries for user=" + this.username));
        }
        finally {
            if (iu != null) {
                iu.close();
            }
            if (ir != null) {
                ir.close();
            }
        }
    }

    public void delete() {
        this.isDeleted = true;
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(Connection c) throws NamingException, SQLException {
        Statement du = null;
        PreparedStatement dr = null;
        try {
            dr = c.prepareStatement("DELETE FROM Roles WHERE Username = ?");
            du = c.prepareStatement("DELETE FROM Users WHERE Username = ?");
            du.setString(1, this.username);
            dr.setString(1, this.username);
            dr.executeUpdate();
            if (du.executeUpdate() != 1) {
                throw new SQLException("Update: Modification of Users failed, row count incorrect.");
            }
            this.isDeleted = false;
        }
        finally {
            if (du != null) {
                du.close();
            }
            if (dr != null) {
                dr.close();
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSuperuser() {
        return this.isSuperuser;
    }

    public boolean authenticate(String pw) {
        return this.password != null && this.password.equals(pw);
    }

    public void setPassword(String pw) {
        AuthUserTomcat.nameCheck((String)pw, (String)"Password");
        this.password = pw;
        this.dirty = true;
    }

    public void setIsSuperuser(boolean su) {
        if (this.isSuperuser != su) {
            this.isSuperuser = su;
            this.dirty = true;
        }
    }

    private static Connection getConnection() throws NamingException, SQLException {
        InitialContext initContext = new InitialContext();
        Context envContext = (Context)initContext.lookup("java:/comp/env");
        DataSource ds = (DataSource)envContext.lookup("jdbc/eaglei");
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(Connection c) throws ServletException {
        boolean bl;
        block6: {
            PreparedStatement s = null;
            try {
                s = c.prepareStatement("SELECT Users.Username FROM Users WHERE Users.Username = ?");
                s.setString(1, this.username);
                ResultSet r = s.executeQuery();
                boolean count = false;
                boolean result = r.next();
                log.debug((Object)("exists(" + this.username + ") => " + result));
                bl = result;
                if (s == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        s.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error((Object)"Failed in query for exists(): ", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            }
            s.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws ServletException {
        if (this.dirty) {
            try {
                Connection c = null;
                try {
                    c = AuthUserTomcat.getConnection();
                    c.setAutoCommit(false);
                    this.flush(c);
                    c.commit();
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
            }
            catch (NamingException e) {
                log.error((Object)"Failed in single commit(): ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (SQLException e) {
                log.error((Object)"Failed in single commit(): ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void flush(Connection c) throws ServletException, NamingException, SQLException {
        if (this.dirty) {
            if (this.isCreated && !this.exists(c)) {
                this.doCreate(c);
            } else if (this.isDeleted) {
                this.doDelete(c);
            } else {
                this.doUpdate(c);
            }
            this.dirty = false;
        }
    }

    public boolean equals(Object o) {
        return o instanceof AuthUserTomcat && this.username != null && this.username.equals(((AuthUserTomcat)o).username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }
}

