/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.auth;

import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.model.User;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.URI;

/*
 * Exception performing whole class analysis ignored.
 */
public class Authentication {
    private static Logger log = LogManager.getLogger(Authentication.class);
    private static final String S_USER = "org.eaglei.repository.authentication.User";
    private static final String S_REMOTE_IP = "org.eaglei.repository.authentication.REMOTE_IP";
    public static final String SUPERUSER_ROLE_NAME = "superuser";

    public static URI getPrincipalURI(HttpServletRequest request) {
        User u = Authentication.getPrincipalUser((HttpServletRequest)request);
        if (u == null || u.getURI() == null) {
            URI result = request.isUserInRole("superuser") ? REPO.ROLE_SUPERUSER : REPO.ROLE_ANONYMOUS;
            log.debug((Object)("getPrincipalURI: Undocumented user, returning Role: " + result));
            return result;
        }
        return u.getURI();
    }

    public static void decacheAuthentication(HttpServletRequest request, User u) {
        HttpSession session = Authentication.getValidatedSession((HttpServletRequest)request);
        User cu = (User)session.getAttribute("org.eaglei.repository.authentication.User");
        if (cu != null && cu.equals((Object)u)) {
            session.removeAttribute("org.eaglei.repository.authentication.User");
            log.debug((Object)"Decached authenticated user from Session.");
            Authentication.logout((HttpServletRequest)request);
        }
    }

    public static String getAuthenticatedUsername(HttpServletRequest request) {
        Principal p = request.getUserPrincipal();
        return p == null ? null : p.getName();
    }

    public static User getPrincipalUser(HttpServletRequest request) {
        User result = (User)request.getAttribute("org.eaglei.repository.authentication.User");
        if (result != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning Request-cached user = " + result));
            }
            return result;
        }
        Principal p = request.getUserPrincipal();
        if (p == null) {
            return null;
        }
        String pname = p.getName();
        String anonUser = Configuration.getInstance().getConfigurationProperty("eaglei.repository.anonymous.user");
        if (anonUser != null && anonUser.equals(pname)) {
            log.info((Object)("Anonymous login because of configured anonymous user: " + pname));
            return null;
        }
        HttpSession session = Authentication.getValidatedSession((HttpServletRequest)request);
        if (Lifecycle.getInstance().isSessionStale(session)) {
            session.removeAttribute("org.eaglei.repository.authentication.User");
            log.debug((Object)("Invalidating cached user URI in stale session, principal=" + pname));
        } else {
            result = (User)session.getAttribute("org.eaglei.repository.authentication.User");
            if (result != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Returning cached user for principal=" + pname + " from session context: " + result));
                }
                request.setAttribute("org.eaglei.repository.authentication.User", (Object)result);
                return result;
            }
        }
        try {
            User u = User.findByUsername((HttpServletRequest)request, (String)pname);
            if (u != null) {
                if (request.isUserInRole("superuser") && !u.isSuperuser()) {
                    u.setIsSuperuser(true);
                }
                session.setAttribute("org.eaglei.repository.authentication.User", (Object)u);
                request.setAttribute("org.eaglei.repository.authentication.User", (Object)u);
            }
            return u;
        }
        catch (ServletException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isSuperuser(HttpServletRequest request) {
        User u = Authentication.getPrincipalUser((HttpServletRequest)request);
        if (u == null) {
            return request.isUserInRole("superuser");
        }
        return u.isSuperuser();
    }

    public static void logout(HttpServletRequest request) {
        HttpSession s = request.getSession(false);
        if (s == null) {
            log.debug((Object)"Logout finds no session to destroy!");
        } else {
            s.invalidate();
            log.debug((Object)("Logout is destroying session ID=" + s.getId()));
        }
    }

    private static HttpSession getValidatedSession(HttpServletRequest request) {
        HttpSession result = request.getSession(false);
        String remoteIP = request.getRemoteAddr();
        if (result == null) {
            result = request.getSession(true);
            result.setAttribute("org.eaglei.repository.authentication.REMOTE_IP", (Object)remoteIP);
        } else {
            String testIP = (String)result.getAttribute("org.eaglei.repository.authentication.REMOTE_IP");
            if (testIP == null) {
                log.debug((Object)("Initializing session's record of remote address, IP=" + remoteIP));
                result.setAttribute("org.eaglei.repository.authentication.REMOTE_IP", (Object)remoteIP);
            } else if (!testIP.equals(remoteIP)) {
                log.error((Object)("POSSIBLE SESSION HIJACKING: session created by IP=" + testIP + ", but is being accessed by IP=" + remoteIP));
                throw new BadRequestException("Authentication denied, this session may only be accessed from the address that created it. Please login again.");
            }
        }
        return result;
    }
}

