/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.inferencer;

import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.inferencer.TBoxInferencer;
import org.eaglei.repository.model.DataModel;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.SailException;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.Version;

/*
 * Exception performing whole class analysis ignored.
 */
public class TBoxInferencer {
    private static Logger log = LogManager.getLogger(TBoxInferencer.class);
    private static TBoxInferencer singleton = null;
    private Set<URI> tboxGraphs = new HashSet();
    private static String[] defaultTBoxGraphs = new String[]{DataModel.GRAPH_URI.toString()};
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private int inferredCount = 0;

    private TBoxInferencer() {
        this.manager.setSilentMissingImportsHandling(true);
        this.manager.clearIRIMappers();
        this.manager.addIRIMapper((OWLOntologyIRIMapper)new /* Unavailable Anonymous Inner Class!! */);
        String[] tbgs = Configuration.getInstance().getConfigurationPropertyArray("eaglei.repository.tbox.graphs", defaultTBoxGraphs);
        this.tboxGraphs.add(REPO.NG_REPO_ONTOLOGY);
        for (String tb : tbgs) {
            try {
                this.tboxGraphs.add(new URIImpl(tb));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Malformed URI in configuration \"eaglei.repository.tbox.graphs\", skipping: " + tb));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initialzed TBox graphs = " + Arrays.deepToString(this.tboxGraphs.toArray())));
        }
    }

    public static TBoxInferencer getInstance() {
        if (singleton == null) {
            singleton = new TBoxInferencer();
        }
        return singleton;
    }

    public Set<URI> getTBoxGraphs() {
        return this.tboxGraphs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doTBoxInference(InferencerConnection rc, URI graphName) throws IOException, RDFHandlerException, SailException {
        OWLOntology ontology;
        block14: {
            this.inferredCount = 0;
            ontology = null;
            PelletReasoner reasoner = null;
            try {
                rc.clearInferred(new Resource[]{graphName});
                PipedOutputStream out = new PipedOutputStream();
                PipedInputStream in = new PipedInputStream(out);
                long startMs = System.currentTimeMillis();
                InferenceRunner ir = new InferenceRunner(this, (InputStream)in, null);
                ir.start();
                RDFWriter w = Rio.createWriter((RDFFormat)RDFFormat.RDFXML, (Writer)new OutputStreamWriter((OutputStream)out, "UTF-8"));
                w.startRDF();
                CloseableIteration si = rc.getStatements(null, null, null, false, new Resource[]{graphName});
                try {
                    while (si.hasNext()) {
                        w.handleStatement((Statement)si.next());
                    }
                }
                finally {
                    si.close();
                }
                w.endRDF();
                out.close();
                try {
                    ir.join(30000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Ontology reading thread was unexpectedly interrupted!", (Throwable)e);
                }
                ontology = InferenceRunner.access$100((InferenceRunner)ir);
                if (ontology == null) {
                    throw new SailException("Failed to load TBox ontology from graph = " + graphName);
                }
                log.debug((Object)("Loaded Ontology: " + ontology.getAxiomCount() + " axioms, ID=" + ontology.getOntologyID() + ", elapsed time: " + String.valueOf(System.currentTimeMillis() - startMs) + " mSec"));
                reasoner = PelletReasonerFactory.getInstance().createReasoner(ontology);
                Version v = reasoner.getReasonerVersion();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Created OWLAPI reasoner: \"%s\" version %d.%d.%d.%d, preparing...", reasoner.getReasonerName(), v.getMajor(), v.getMinor(), v.getPatch(), v.getBuild()));
                }
                long reasonerStartMs = System.currentTimeMillis();
                reasoner.flush();
                reasoner.prepareReasoner();
                log.debug((Object)("..done preparing reasoner, spent " + String.valueOf(System.currentTimeMillis() - reasonerStartMs) + " mSec"));
                this.crawlTBox(rc, graphName, (OWLReasoner)reasoner);
                log.info((Object)("Rebuilt inferred statements on TBox graph = " + graphName + ", total time = " + String.valueOf(System.currentTimeMillis() - startMs) + " mSec"));
                if (reasoner == null) break block14;
            }
            catch (Throwable throwable) {
                if (reasoner != null) {
                    reasoner.dispose();
                }
                if (ontology != null) {
                    this.manager.removeOntology(ontology);
                }
                throw throwable;
            }
            reasoner.dispose();
        }
        if (ontology != null) {
            this.manager.removeOntology(ontology);
        }
        return this.inferredCount;
    }

    private void crawlTBox(InferencerConnection rc, URI graphName, OWLReasoner reasoner) throws IOException, RDFHandlerException, SailException {
        OWLOntology ontology = reasoner.getRootOntology();
        Set ac = ontology.getClassesInSignature(true);
        for (OWLClass c : ac) {
            URIImpl cls = new URIImpl(c.getIRI().toString());
            NodeSet nsups = reasoner.getSuperClasses((OWLClassExpression)c, false);
            for (Node nsup : nsups) {
                URIImpl obj;
                if (!nsup.isSingleton()) {
                    log.error((Object)("Superclass Node is not singleton: " + nsup));
                    continue;
                }
                OWLClass sup = (OWLClass)nsup.getRepresentativeElement();
                if (sup.isAnonymous() || !rc.addInferredStatement((Resource)cls, RDFS.SUBCLASSOF, (Value)(obj = new URIImpl(sup.asOWLClass().getIRI().toString())), new Resource[]{graphName})) continue;
                ++this.inferredCount;
            }
        }
        OWLObjectProperty bottomObjectProp = (OWLObjectProperty)reasoner.getBottomObjectPropertyNode().getRepresentativeElement();
        OWLDataProperty bottomDataProp = (OWLDataProperty)reasoner.getBottomDataPropertyNode().getRepresentativeElement();
        Set ap = ontology.getObjectPropertiesInSignature(true);
        for (OWLObjectProperty p : ap) {
            URIImpl puri = new URIImpl(p.getIRI().toString());
            Set ta = ontology.getTransitiveObjectPropertyAxioms((OWLObjectPropertyExpression)p);
            boolean isTransitive = ta != null && !ta.isEmpty();
            NodeSet nsubs = reasoner.getSubObjectProperties((OWLObjectPropertyExpression)p, false);
            for (Node nsub : nsubs) {
                OWLObjectProperty sub;
                if (!nsub.isSingleton()) {
                    log.error((Object)("SubObjectProperty Node is not singleton: " + nsub));
                    continue;
                }
                if (nsub.contains((OWLLogicalEntity)bottomObjectProp) || (sub = (OWLObjectProperty)nsub.getRepresentativeElement()).isAnonymous()) continue;
                URIImpl obj = new URIImpl(sub.getIRI().toString());
                if (rc.addInferredStatement((Resource)obj, RDFS.SUBPROPERTYOF, (Value)puri, new Resource[]{graphName})) {
                    ++this.inferredCount;
                }
                if (!isTransitive) continue;
                log.debug((Object)("NOT ADDING: <" + obj + "> a owl:TransitiveProperty ."));
            }
        }
        Set dp = ontology.getDataPropertiesInSignature(true);
        for (OWLDataProperty p : dp) {
            URIImpl puri = new URIImpl(p.getIRI().toString());
            NodeSet nsubs = reasoner.getSubDataProperties(p, false);
            for (Node nsub : nsubs) {
                URIImpl obj;
                OWLDataProperty sub;
                if (!nsub.isSingleton()) {
                    log.error((Object)("SubDataProperty Node is not singleton: " + nsub));
                    continue;
                }
                if (nsub.contains((OWLLogicalEntity)bottomDataProp) || (sub = (OWLDataProperty)nsub.getRepresentativeElement()).isAnonymous() || !rc.addInferredStatement((Resource)(obj = new URIImpl(sub.getIRI().toString())), RDFS.SUBPROPERTYOF, (Value)puri, new Resource[]{graphName})) continue;
                ++this.inferredCount;
            }
        }
        for (OWLNamedIndividual ni : ontology.getIndividualsInSignature(true)) {
            URIImpl suri = new URIImpl(ni.getIRI().toString());
            Set assertedTypes = ni.getTypes(ontology);
            NodeSet nclasses = reasoner.getTypes(ni, false);
            for (Node nclass : nclasses) {
                URIImpl turi;
                if (!nclass.isSingleton()) {
                    log.error((Object)("OWLClass Node is not singleton: " + nclass));
                    continue;
                }
                OWLClass cls = (OWLClass)nclass.getRepresentativeElement();
                if (assertedTypes.contains(cls) || cls.isAnonymous() || !rc.addInferredStatement((Resource)suri, RDF.TYPE, (Value)(turi = new URIImpl(cls.getIRI().toString())), new Resource[]{graphName})) continue;
                ++this.inferredCount;
            }
        }
    }

    static /* synthetic */ OWLOntologyManager access$200(TBoxInferencer x0) {
        return x0.manager;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }
}

