/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.model.ImmutableObjectModel;
import org.eaglei.repository.model.QueryMacro;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;

public class QueryMacro
extends ImmutableObjectModel
implements Comparable {
    private static Logger log = LogManager.getLogger(QueryMacro.class);
    private final String label;
    private final String macro;
    private static final String macroQuery = "SELECT DISTINCT ?label ?text WHERE { ?s a <" + REPO.QUERY_MACRO + ">; <" + RDFS.LABEL + "> ?label; <" + REPO.QUERY + "> ?text }";

    private QueryMacro(String l, String m) {
        this.label = l;
        this.macro = m;
    }

    public static List<QueryMacro> findAll(HttpServletRequest request) throws ServletException {
        ArrayList<QueryMacro> result = new ArrayList<QueryMacro>();
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, macroQuery);
            DatasetImpl ds = new DatasetImpl();
            ds.addDefaultGraph(REPO.NG_QUERY);
            q.setDataset((Dataset)ds);
            q.evaluate((TupleQueryResultHandler)new MacroHandler(rc, result));
            return result;
        }
        catch (MalformedQueryException e) {
            log.info((Object)("Rejecting malformed query: " + (Object)((Object)e)));
            throw new ServletException("Malformed query was generated internally: " + e.toString());
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public int compareTo(Object o) {
        return this.label.compareTo(((QueryMacro)o).label);
    }

    public static QueryMacro find(HttpServletRequest request, URI resource) {
        log.error((Object)"Someone should not have called unimplemented find()!");
        return null;
    }

    public URI getURI() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMacro() {
        return this.macro;
    }

    public String toString() {
        return "<#QueryMacro: label=" + this.label + ", macro=" + this.macro + ">";
    }

    public boolean equals(Object o) {
        return o instanceof QueryMacro && this.label != null && this.label.equals(((QueryMacro)o).label);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

