/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.DataModel;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.model.View;
import org.eaglei.repository.servlet.Disseminate;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
@HasContentCache
public class Disseminate
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Disseminate.class);
    private static final String XHTML = "http://www.w3.org/1999/xhtml";
    private static final Namespace XHTML_NS = Namespace.getNamespace((String)"http://www.w3.org/1999/xhtml");
    private static final URI[] labelPredicate = DataModel.LABEL_PREDICATE.getArrayOfURI();
    private static final boolean hideContactsEnabled = Boolean.parseBoolean(Configuration.getInstance().getConfigurationProperty("eaglei.repository.hideContacts", Boolean.FALSE.toString()));
    private static final String[] defaultScriptURLs = new String[]{"http://ajax.googleapis.com/ajax/libs/jquery/1.4.1/jquery.min.js", "/repository/styles/i.js"};
    private static final String[] scriptURLs = Configuration.getInstance().getConfigurationPropertyArray("eaglei.repository.instance.js", defaultScriptURLs);
    private boolean authenticated;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        String a = sc.getInitParameter("authenticated");
        this.authenticated = a != null && Boolean.parseBoolean(a);
    }

    public static void decache() {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block53: {
            request.setCharacterEncoding("UTF-8");
            String format = this.getParameter(request, "format", false);
            String rawView = this.getParameter(request, "view", false);
            URI uri = this.getParameterAsURI(request, "uri", false);
            URI workspace = this.getParameterAsURI(request, "workspace", false);
            boolean noinferred = this.isParameterPresent(request, "noinferred");
            boolean forceRDF = this.isParameterPresent(request, "forceRDF");
            if (uri == null) {
                String pi = request.getPathInfo();
                if (pi == null || pi.length() == 0) {
                    throw new BadRequestException("Missing required instance URI to disseminate.");
                }
                uri = Utils.parseURI((String)(Configuration.getInstance().getDefaultNamespace() + pi.substring(1)), (String)"Resource URI", (boolean)true);
            }
            log.debug((Object)("Got requested resource uri=" + uri.stringValue()));
            if (workspace != null && rawView != null) {
                throw new BadRequestException("The 'view' and 'workspace' arguments are mutually exclusive.  Choose only one.");
            }
            try {
                int i;
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                if (labelPredicate == null) {
                    throw new ServletException("Configuration failure, no label predicates found.");
                }
                DatasetImpl ds = new DatasetImpl();
                View view = null;
                if (workspace != null) {
                    View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)workspace);
                } else {
                    View view2 = view = rawView == null ? View.USER : View.parseView((String)rawView);
                    if (view == null) {
                        throw new BadRequestException("Unknown view: " + rawView);
                    }
                    View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)view);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dataset derived from initial 'view' or 'workspace' args = " + Utils.prettyPrint((Dataset)ds)));
                }
                RepositoryResult rr = null;
                boolean goodResource = false;
                boolean exists = false;
                boolean visible = false;
                boolean any = false;
                URI[] contexts = View.NULL.equals((Object)view) ? new URI[1] : ds.getDefaultGraphs().toArray(new URI[ds.getDefaultGraphs().size()]);
                URI homeGraph = null;
                try {
                    rr = rc.getStatements((Resource)uri, RDF.TYPE, null, false, (Resource[])contexts);
                    if (!rr.hasNext()) {
                        log.debug((Object)"Probing for rdf:type in ALL graphs, after failing in allowed ones");
                        exists = rc.hasStatement((Resource)uri, RDF.TYPE, null, false, new Resource[0]);
                        any = rc.hasStatement((Resource)uri, null, null, false, (Resource[])contexts);
                    }
                    while (rr.hasNext()) {
                        NamedGraphType cngt;
                        Statement s = (Statement)rr.next();
                        Resource ctx = s.getContext();
                        log.debug((Object)("Found statement: " + uri + " rdf:type " + s.getObject() + ", in graph " + ctx));
                        exists = true;
                        if (ctx == null || !(ctx instanceof URI) || !(View.NULL.equals((Object)view) ? Access.hasPermission((HttpServletRequest)request, (Resource)((URI)ctx), (Access)Access.READ) : ds.getDefaultGraphs().contains((URI)ctx))) continue;
                        visible = true;
                        NamedGraph cng = NamedGraph.find((HttpServletRequest)request, (URI)((URI)ctx));
                        NamedGraphType namedGraphType = cngt = cng == null ? null : cng.getType();
                        if (cngt != NamedGraphType.published && cngt != NamedGraphType.workspace) continue;
                        log.debug((Object)("...approving resource because of rdf:type statement in graph=" + ctx));
                        goodResource = true;
                        homeGraph = (URI)ctx;
                        break;
                    }
                }
                finally {
                    rr.close();
                }
                log.debug((Object)("Probe results: exists=" + exists + ", any=" + any + ", visible=" + visible + ", goodResource=" + goodResource));
                if (exists && !visible) {
                    log.info((Object)("Resource exists but is not visible to user, so returning 404.  User=" + Authentication.getPrincipalURI((HttpServletRequest)request) + ", resource=" + uri));
                    throw new NotFoundException("Subject not found in this repository: " + uri.toString());
                }
                if (!exists) {
                    if (any) {
                        throw new HttpStatusException(410, "Subject was deleted or is not a well formed eagle-i resource: " + uri.toString());
                    }
                    throw new NotFoundException("Subject not found in this repository: " + uri.toString());
                }
                if (!(goodResource && homeGraph != null || Authentication.isSuperuser((HttpServletRequest)request))) {
                    throw new NotFoundException("Subject exists but is not available as an Eagle-I resource: " + uri.toString());
                }
                String mimeType = Formats.negotiateHTMLorRDFContent((HttpServletRequest)request, (String)format);
                boolean html = !forceRDF && (mimeType.equals("text/html") || mimeType.equals("application/xhtml+xml"));
                String contentType = Utils.makeContentType((String)(html ? "application/xhtml+xml" : mimeType), (String)"UTF-8");
                log.debug((Object)("Preparing query for authenticated=" + this.authenticated + ", hideContactsEnabled=" + hideContactsEnabled));
                StringBuilder query = new StringBuilder();
                if (html) {
                    query.append("SELECT DISTINCT ?g ?p ?v");
                    for (i = 0; i < labelPredicate.length; ++i) {
                        query.append(" ?pl").append(String.valueOf(i)).append(" ?vl").append(String.valueOf(i));
                    }
                } else {
                    query.append("CONSTRUCT { ?subject ?p ?v . ");
                    for (i = 0; i < labelPredicate.length; ++i) {
                        query.append(" ?p <").append(labelPredicate[i]).append("> ?pl").append(String.valueOf(i)).append(" .").append(" ?v <").append(labelPredicate[i]).append("> ?vl").append(String.valueOf(i)).append(" .").append(" ?vo <").append(labelPredicate[i]).append("> ?vol").append(String.valueOf(i)).append(" .");
                    }
                    query.append(" ?v ?vp ?vo }\n");
                }
                query.append(" WHERE { \n");
                query.append("{ GRAPH ?g { ?subject ?p ?v } \n");
                for (i = 0; i < labelPredicate.length; ++i) {
                    query.append(" OPTIONAL { ?p <").append(labelPredicate[i]).append("> ?pl").append(String.valueOf(i)).append(" } \n").append(" OPTIONAL { ?v <").append(labelPredicate[i]).append("> ?vl").append(String.valueOf(i)).append(" } \n");
                }
                if (!html) {
                    query.append("OPTIONAL { ?v a ?vt . ?vt <").append(DataModel.EMBEDDED_INSTANCE_PREDICATE.toString()).append("> <").append(DataModel.EMBEDDED_INSTANCE_OBJECT.toString()).append("> . ");
                    if (noinferred) {
                        query.append("GRAPH ?eg ");
                    }
                    query.append("{?v ?vp ?vo}\n");
                    if (noinferred) {
                        query.append(" FILTER( ?eg != <").append(REPO.NG_INFERRED).append(">)\n");
                    }
                    if (!this.authenticated) {
                        this.addPropertyFilters(query, "vp", !this.authenticated);
                    }
                    for (i = 0; i < labelPredicate.length; ++i) {
                        query.append(" OPTIONAL { ?vo <").append(labelPredicate[i]).append("> ?vol").append(String.valueOf(i)).append(" } \n");
                    }
                    query.append("}\n");
                }
                if (!this.authenticated) {
                    this.addPropertyFilters(query, "p", !this.authenticated);
                }
                query.append(" }");
                if (noinferred) {
                    query.append(" FILTER( ?g != <").append(REPO.NG_INFERRED).append(">)\n");
                }
                query.append("}");
                if (html) {
                    query.append(" ORDER BY ?p ?v");
                }
                log.debug((Object)("SPARQL Query for Dissemination: ?subject=" + uri + ", query=\n" + query));
                DatasetImpl qds = null;
                if (rawView == null && workspace == null) {
                    qds = new DatasetImpl();
                    View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)qds, (URI)homeGraph);
                } else {
                    qds = ds;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Home graph = " + homeGraph));
                    log.debug((Object)("Dataset for QUERY FOR RESOURCE PROPERTIES = " + Utils.prettyPrint((Dataset)qds)));
                }
                if (html) {
                    Document result;
                    Element root = new Element("html", XHTML_NS);
                    Element head = new Element("head", XHTML_NS);
                    root.addContent((Content)head);
                    head.addContent((Content)new Element("meta", XHTML_NS).setAttribute("http-equiv", "Content-Type").setAttribute("content", contentType));
                    head.addContent((Content)new Element("meta", XHTML_NS).setAttribute("name", "eaglei.version").setAttribute("content", Configuration.getInstance().getProjectVersion()));
                    head.addContent((Content)new Element("title", XHTML_NS).addContent("Resource " + uri.toString()));
                    head.addContent((Content)new Element("link", XHTML_NS).setAttribute("rel", "schema.DCTERMS").setAttribute("href", "http://purl.org/dc/terms/"));
                    head.addContent((Content)new Element("meta", XHTML_NS).setAttribute("name", "eaglei.repository.title").setAttribute("content", Configuration.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property eaglei.repository.title needs to be set)")));
                    String cssURL = Configuration.getInstance().getConfigurationProperty("eaglei.repository.instance.css");
                    if (cssURL != null) {
                        head.addContent((Content)new Element("link", XHTML_NS).setAttribute("rel", "stylesheet").setAttribute("type", "text/css").setAttribute("href", cssURL));
                    }
                    for (String scriptURL : scriptURLs) {
                        head.addContent((Content)new Element("script", XHTML_NS).setAttribute("language", "javascript").setAttribute("type", "text/javascript").setAttribute("src", scriptURL));
                    }
                    Element body = new Element("body", XHTML_NS);
                    root.addContent((Content)body);
                    Element header = new Element("div", XHTML_NS).setAttribute("id", "header").setAttribute("class", "container_12 ");
                    String logoURL = Configuration.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_logo.png");
                    header.addContent((Content)new Element("div", XHTML_NS).setAttribute("logo", "header_container").setAttribute("class", "grid_6 alpha ").addContent((Content)new Element("a", XHTML_NS).setAttribute("href", "#").setAttribute("title", "eagle-1 consortium").addContent((Content)new Element("img", XHTML_NS).setAttribute("src", logoURL).setAttribute("alt", ""))));
                    body.addContent((Content)new Element("div", XHTML_NS).setAttribute("id", "header_container").addContent((Content)header));
                    Element hlabel = new Element("h2", XHTML_NS).setAttribute("class", "eaglei_resourceLabel ");
                    body.addContent((Content)hlabel);
                    Element subTitle = new Element("h3", XHTML_NS).setAttribute("class", "eaglei_resourceURI ").addContent("Resource " + uri.toString());
                    body.addContent((Content)subTitle);
                    Element contactLink = null;
                    if (hideContactsEnabled) {
                        contactLink = new Element("a", XHTML_NS);
                        body.addContent((Content)contactLink);
                    }
                    body.addContent((Content)new Element("h3", XHTML_NS).setAttribute("class", "eaglei_resourceTypes directTypes ").addContent("Direct Types"));
                    Element directTypes = new Element("ol", XHTML_NS).setAttribute("class", "eaglei_resourceTypes ");
                    body.addContent((Content)directTypes);
                    body.addContent((Content)new Element("h3", XHTML_NS).setAttribute("class", "eaglei_resourceTypes inferredTypes").addContent("Inferred Types"));
                    Element inferredTypes = new Element("ol", XHTML_NS).setAttribute("class", "eaglei_resourceTypes ");
                    body.addContent((Content)inferredTypes);
                    body.addContent((Content)new Element("h3", XHTML_NS).setAttribute("class", "eaglei_resourceProperties").addContent("Properties"));
                    Element props = new Element("ol", XHTML_NS).setAttribute("class", "eaglei_resourceProperties ");
                    body.addContent((Content)props);
                    body.addContent((Content)new Element("h3", XHTML_NS).setAttribute("class", "eaglei_provenanceProperties").addContent("Provenance Metadata"));
                    Element provenance = new Element("ol", XHTML_NS).setAttribute("class", "eaglei_provenanceProperties ");
                    body.addContent((Content)provenance);
                    TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
                    q.setBinding("subject", (Value)uri);
                    if (!View.NULL.equals((Object)view)) {
                        q.setDataset((Dataset)qds);
                    }
                    StringBuilder labelBuf = new StringBuilder();
                    propsHandler handler = new propsHandler(labelBuf, directTypes, inferredTypes, props, provenance, head);
                    q.evaluate((TupleQueryResultHandler)handler);
                    String label = labelBuf.toString();
                    hlabel.addContent((Content)new Element("span", XHTML_NS).setAttribute("class", "rdf_literal ").addContent(label));
                    if (contactLink != null) {
                        String emailURL = "/repository/contact?uri=" + Utils.urlEncode((String)uri.stringValue()) + "&label=" + Utils.urlEncode((String)label);
                        Element popupDiv = new Element("div", XHTML_NS).setAttribute("id", "popup1").setAttribute("class", "popup_block");
                        Element popupIframe = new Element("iframe", XHTML_NS).setAttribute("width", "590").setAttribute("height", "450").setAttribute("src", emailURL).setAttribute("scrolling", "no").setAttribute("class", "mailframe").setAttribute("frameborder", "0").setAttribute("name", "popupframe");
                        popupDiv.addContent((Content)popupIframe);
                        body.addContent((Content)popupDiv);
                        contactLink.addContent("Contact the owner of this resource!").setAttribute("rel", "popup1").setAttribute("class", "poplight").setAttribute("href", "#?w=600").setAttribute("onclick", "window.frames[0].location.href='" + emailURL + "'");
                    }
                    if (propsHandler.access$000((propsHandler)handler) != null) {
                        try {
                            XMLGregorianCalendar mc = propsHandler.access$000((propsHandler)handler).calendarValue();
                            log.debug((Object)("Got last-modified date = " + mc.toString()));
                            response.addDateHeader("Last-Modified", mc.toGregorianCalendar().getTime().getTime());
                        }
                        catch (IllegalArgumentException e) {
                            log.warn((Object)("Failed to parse dcterms:created or dcterms:modified as date; value=" + propsHandler.access$000((propsHandler)handler)));
                        }
                    }
                    if (Access.hasPermission((HttpServletRequest)request, (Resource)uri, (Access)Access.ADMIN)) {
                        Element acl = new Element("form", XHTML_NS).setAttribute("method", "POST").setAttribute("action", "/repository/admin/editGrants.jsp");
                        acl.addContent((Content)new Element("input", XHTML_NS).setAttribute("type", "hidden").setAttribute("name", "uri").setAttribute("value", uri.toString()));
                        acl.addContent((Content)new Element("input", XHTML_NS).setAttribute("type", "hidden").setAttribute("name", "type").setAttribute("value", "Resource Instance"));
                        acl.addContent((Content)new Element("input", XHTML_NS).setAttribute("type", "hidden").setAttribute("name", "label").setAttribute("value", label));
                        acl.addContent((Content)new Element("button", XHTML_NS).setAttribute("type", "submit").addContent("Edit Access Controls"));
                        body.addContent((Content)acl);
                    }
                    if (!(result = new Document(root)).hasRootElement()) {
                        log.error((Object)"No root element in doc, this will be bad.");
                    }
                    XSLTransformer xfrm = null;
                    String xslPath = Configuration.getInstance().getConfigurationProperty("eaglei.repository.instance.xslt");
                    if (xslPath != null) {
                        File xslFile = new File(xslPath);
                        Reader xis = xslFile.isAbsolute() ? new FileReader(xslFile) : Lifecycle.getInstance().getWebappResourceAsReader(xslPath);
                        xfrm = new XSLTransformer(xis);
                        log.debug((Object)("Using XSL transformation stylesheet from: " + xslPath));
                        result = xfrm.transform(result);
                        if (!result.hasRootElement()) {
                            log.error((Object)"No root element in transformed doc, this will be bad.");
                        }
                    }
                    result.setDocType(new DocType("HTML", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"));
                    XMLOutputter out = new XMLOutputter();
                    out.setFormat(Format.getPrettyFormat());
                    response.setContentType(contentType);
                    out.output(result, (OutputStream)response.getOutputStream());
                    break block53;
                }
                RDFFormat rf = Formats.RDFOutputFormatForMIMEType((String)mimeType);
                if (rf == null) {
                    log.error((Object)("Failed to get RDF serialization format, for mime=" + mimeType));
                    throw new ServletException("Failed to get RDF serialization format that SHOULD have been available, for mime=" + mimeType);
                }
                long startMs = System.currentTimeMillis();
                response.setContentType(contentType);
                GraphQuery q = rc.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
                q.setBinding("subject", (Value)uri);
                q.setDataset((Dataset)qds);
                q.evaluate((RDFHandler)Rio.createWriter((RDFFormat)rf, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")));
                log.debug((Object)String.format("SPARQL query completed in %,d mSec.", System.currentTimeMillis() - startMs));
            }
            catch (XSLTransformException e) {
                log.error((Object)"Failed in XSL transformation: ", (Throwable)e);
                throw new ServletException("Failed in XSL transformation: ", (Throwable)e);
            }
            catch (MalformedQueryException e) {
                log.error((Object)"Malformed query generated internally: ", (Throwable)e);
                throw new ServletException("Malformed query generated internally: " + e.toString(), (Throwable)e);
            }
            catch (UnsupportedOperationException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void addPropertyFilters(StringBuilder query, String propName, boolean hide) {
        String hideObj = propName + "_hide";
        String contactObj = propName + "_contact";
        if (hide) {
            query.append(" OPTIONAL { ?").append(propName).append(" <").append(DataModel.HIDE_PROPERTY_PREDICATE.toString()).append("> ?").append(hideObj).append("\n");
            query.append("  FILTER(?").append(hideObj).append(" = <").append(DataModel.HIDE_PROPERTY_OBJECT.toString()).append(">)}\n");
        }
        if (hideContactsEnabled) {
            query.append(" OPTIONAL { ?").append(propName).append(" <").append(DataModel.CONTACT_PROPERTY_PREDICATE.toString()).append("> ?").append(contactObj).append("\n");
            query.append("  FILTER(?").append(contactObj).append(" = <").append(DataModel.CONTACT_PROPERTY_OBJECT.toString()).append(">)}\n");
        }
        query.append("FILTER(!(BOUND(?").append(hideObj).append(")");
        if (hideContactsEnabled) {
            query.append(" || BOUND(?").append(contactObj).append(")");
        }
        query.append("))\n");
    }

    static /* synthetic */ Namespace access$100() {
        return XHTML_NS;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ URI[] access$300() {
        return labelPredicate;
    }
}

