/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.inferencer.TBoxInferencer;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.servlet.Graph;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.AppendingRDFHandler;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.util.RDFRemover;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class Graph
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Graph.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        URI name = this.getParameterAsURI(request, "name", false);
        boolean all = this.isParameterPresent(request, "all");
        Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
        String format = this.getParameter(request, "format", false);
        String source = this.getParameter(request, "source", false);
        String sourceModified = this.getParameter(request, "sourceModified", false);
        String label = this.getParameter(request, "label", false);
        NamedGraphType type = (NamedGraphType)this.getParameterAsKeyword(request, "type", NamedGraphType.class, null, false);
        Reader content = this.getParameterAsReader(request, "content", true);
        String contentType = this.getParameterContentType(request, "content");
        if (format == null || format.length() == 0) {
            format = contentType;
        }
        this.putGraphInternal(request, response, name, all, action, format, content, source, sourceModified, type, label);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding;
        String sourceModified;
        URI name = this.getParameterAsURI(request, "name", false);
        boolean all = this.isParameterPresent(request, "all");
        Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
        String source = this.getParameter(request, "source", false);
        String label = this.getParameter(request, "label", false);
        NamedGraphType type = (NamedGraphType)this.getParameterAsKeyword(request, "type", NamedGraphType.class, null, false);
        String format = this.getParameter(request, "format", false);
        if (format == null || format.length() == 0) {
            format = request.getContentType();
        }
        if ((sourceModified = this.getParameter(request, "sourceModified", false)) == null) {
            sourceModified = request.getHeader("Last-Modified");
        }
        if ((encoding = request.getCharacterEncoding()) == null) {
            encoding = "UTF-8";
        }
        try {
            InputStreamReader content = new InputStreamReader((InputStream)request.getInputStream(), Charset.forName(encoding));
            this.putGraphInternal(request, response, name, all, action, format, (Reader)content, source, sourceModified, type, label);
        }
        catch (IllegalCharsetNameException e) {
            throw new BadRequestException("Illegal character set name in content-type spec: " + e);
        }
        catch (UnsupportedCharsetException e) {
            throw new BadRequestException("Unsupported character set name in content-type spec: " + e);
        }
    }

    private void putGraphInternal(HttpServletRequest request, HttpServletResponse response, URI name, boolean all, Action action, String rawFormat, Reader content, String source, String sourceModified, NamedGraphType type, String label) throws ServletException, IOException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        if (rawFormat == null) {
            throw new BadRequestException("Missing required argument: format (or content-type)");
        }
        if (all && name != null) {
            throw new BadRequestException("You may not specify both a named graph and the 'all' keyword");
        }
        if (!all && name == null) {
            throw new BadRequestException("Missing required argument: name");
        }
        if (content == null) {
            throw new BadRequestException("No input source, either remote URI or content must be specified");
        }
        String mime = Utils.contentTypeGetMIMEType((String)rawFormat);
        RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mime);
        if (format == null) {
            throw new HttpStatusException(415, "MIME type of serialized RDF is not supported: \"" + mime + "\"");
        }
        log.debug((Object)("RDF format derived from arg (" + rawFormat + ") = " + format));
        if (all && !format.supportsContexts()) {
            throw new BadRequestException("'All' may not be specified with a format that does not support quads");
        }
        if (all && Authentication.isSuperuser((HttpServletRequest)request) || name != null && (action != Action.add && action != Action.replace || Access.hasPermission((HttpServletRequest)request, (Resource)name, (Access)Access.ADD)) && (action != Action.delete && action != Action.replace || Access.hasPermission((HttpServletRequest)request, (Resource)name, (Access)Access.REMOVE))) {
            try {
                boolean created;
                boolean bl = created = action == Action.replace || action == Action.add && !all && rc.size(new Resource[]{name}) == 0L;
                if (action == Action.add || action == Action.replace) {
                    long before;
                    if (action == Action.replace) {
                        if (all) {
                            rc.clear(new Resource[0]);
                        } else {
                            rc.clear(new Resource[]{name});
                        }
                    }
                    if (all) {
                        before = rc.size(new Resource[0]);
                        rc.add(content, "", format, new Resource[0]);
                        log.info((Object)("Added " + String.valueOf(rc.size(new Resource[0]) - before) + " statements to all graphs."));
                        Lifecycle.getInstance().notifyDataReplaced();
                    } else {
                        before = rc.size(new Resource[]{name});
                        rc.add(content, "", format, new Resource[]{name});
                        log.info((Object)("Added " + String.valueOf(rc.size(new Resource[]{name}) - before) + " statements to graph:" + name.toString()));
                    }
                    if (!all && !rc.hasStatement((Resource)name, RDF.TYPE, (Value)REPO.NAMED_GRAPH, true, new Resource[0])) {
                        rc.add((Resource)name, RDF.TYPE, (Value)REPO.NAMED_GRAPH, new Resource[]{REPO.NG_INTERNAL});
                        log.debug((Object)("Declaring rdf:type of named graph URI = " + name));
                    }
                    if (!(all || type == null && label == null)) {
                        NamedGraph ng = NamedGraph.findOrCreate((HttpServletRequest)request, (URI)name, (boolean)true);
                        if (type != null) {
                            ng.setType(request, type.getURI());
                        }
                        if (label != null) {
                            ng.setLabel(request, label);
                        }
                    }
                } else if (action == Action.delete) {
                    long before = rc.size(new Resource[]{name});
                    RDFParser parser = Rio.createParser((RDFFormat)format, (ValueFactory)vf);
                    RDFRemover rr = new RDFRemover(rc);
                    if (!all) {
                        rr.enforceContext((Resource)name);
                    }
                    parser.setRDFHandler((RDFHandler)rr);
                    parser.parse(content, "");
                    log.info((Object)("Deleted " + String.valueOf(before - rc.size(new Resource[]{name})) + " statements to graph:" + name.toString()));
                }
                if (!all) {
                    Date now = new Date();
                    Provenance p = new Provenance(name);
                    if (created) {
                        p.setCreated(request, now);
                    }
                    p.setModified(request, now);
                    if (source != null) {
                        Date smDate = null;
                        if (sourceModified != null) {
                            smDate = Utils.parseXMLDate((String)sourceModified).toGregorianCalendar().getTime();
                            log.debug((Object)("Got sourceModified date, parsed date = " + smDate));
                        }
                        p.setSource(request, source, smDate);
                    }
                }
                rc.commit();
                response.setStatus(created ? 201 : 200);
            }
            catch (OpenRDFException e) {
                log.error((Object)"Failed parsing user-supplied graph content: ", (Throwable)e);
                throw new BadRequestException((Throwable)e);
            }
        } else {
            throw new ForbiddenException("User is not permitted to " + action + " this graph");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block22: {
            request.setCharacterEncoding("UTF-8");
            String rawFormat = this.getParameter(request, "format", false);
            String mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)rawFormat);
            RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mimeType);
            if (format == null) {
                throw new BadRequestException("Unrecognized MIME type for serialized RDF format: \"" + mimeType + "\"");
            }
            log.debug((Object)("Negotiated output format = " + format));
            boolean force = this.isParameterPresent(request, "force");
            boolean inferred = this.isParameterPresent(request, "inferred");
            URI name = this.getParameterAsURI(request, "name", false);
            boolean all = this.isParameterPresent(request, "all");
            if (all) {
                if (name != null) {
                    throw new BadRequestException("You may not specify both a named graph and the 'all' keyword");
                }
                if (!format.supportsContexts() && !force) {
                    throw new BadRequestException("'All' may not be specified with a format that does not support quads");
                }
            } else if (name == null) {
                throw new BadRequestException("Missing required argument, either 'name' or 'arg' is required.");
            }
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            try {
                if (all) {
                    ArrayList<Object> graphs = new ArrayList<Object>();
                    ArrayList<Resource> later = new ArrayList<Resource>();
                    RepositoryResult rr = null;
                    Set tboxGraphs = TBoxInferencer.getInstance().getTBoxGraphs();
                    try {
                        rr = rc.getContextIDs();
                        while (rr.hasNext()) {
                            Resource ctx = (Resource)rr.next();
                            if (ctx instanceof URI && tboxGraphs.contains((URI)ctx)) {
                                graphs.add(ctx);
                                continue;
                            }
                            later.add(ctx);
                        }
                    }
                    finally {
                        rr.close();
                    }
                    graphs.addAll(later);
                    for (Resource resource : graphs) {
                        if (resource instanceof URI && Access.hasPermission((HttpServletRequest)request, (Resource)resource, (Access)Access.READ)) continue;
                        throw new ForbiddenException("You are not allowed to read graph " + resource.stringValue());
                    }
                    response.setContentType(Utils.makeContentType((String)format.getDefaultMIMEType(), (String)"UTF-8"));
                    AppendingRDFHandler writer = new AppendingRDFHandler((RDFHandler)Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")));
                    try {
                        for (Resource resource : graphs) {
                            rc.exportStatements(null, null, null, inferred, (RDFHandler)writer, new Resource[]{resource});
                        }
                        break block22;
                    }
                    finally {
                        writer.reallyEndRDF();
                    }
                }
                if (!Access.hasPermission((HttpServletRequest)request, (Resource)name, (Access)Access.READ)) {
                    throw new ForbiddenException("You are not allowed to read this graph: " + name.stringValue());
                }
                if (rc.hasStatement((Resource)name, RDF.TYPE, (Value)REPO.NAMED_GRAPH, true, new Resource[0])) {
                    response.setContentType(Utils.makeContentType((String)format.getDefaultMIMEType(), (String)"UTF-8"));
                    rc.exportStatements(null, null, null, inferred, (RDFHandler)Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")), new Resource[]{name});
                    break block22;
                }
                throw new NotFoundException("This URI is not a named graph: " + name);
            }
            catch (OpenRDFException e) {
                log.error((Object)"Failed exporting graph content: ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }
}

