/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet.admin;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.servlet.admin.UpdateGrants;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.util.Utils;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;

public class UpdateGrants
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(UpdateGrants.class);
    private static final String[] PASS_THRU_ARGS = new String[]{"type", "label", "lock_access", "backLink", "backLabel"};

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        URI uri = this.getParameterAsURI(request, "uri", true);
        Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
        URI access = this.getParameterAsURI(request, "access", true);
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("This service is only for use by administrators.");
        }
        URI agent = null;
        for (String a : this.getParameters(request, "agent", true)) {
            if (a.trim().length() <= 0) continue;
            if (agent != null) {
                throw new BadRequestException("Only one value is allowed for the 'agent' argument");
            }
            agent = Utils.parseURI((String)a, (String)"agent", (boolean)true);
        }
        if (agent == null) {
            throw new BadRequestException("Missing required argument: agent");
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        String message = "";
        try {
            if (action == Action.add) {
                AccessGrant.addGrant((HttpServletRequest)request, (URI)uri, (URI)agent, (URI)access);
                message = "New grant has been added.";
            } else if (action == Action.remove) {
                message = AccessGrant.removeGrant((HttpServletRequest)request, (URI)uri, (URI)agent, (URI)access) ? "Grant has been removed." : "Specified grant was not found.";
            }
            rc.commit();
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        this.redirectToJSP(request, response, message, PASS_THRU_ARGS, new String[]{"uri", uri.stringValue()});
    }
}

