/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet.admin;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Role;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.servlet.admin.UpdateRole;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.NotFoundException;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;

public class UpdateRole
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(UpdateRole.class);
    private static final String[] PASS_THRU_ARGS = new String[0];

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        URI uri = this.getParameterAsURI(request, "uri", false);
        Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
        String label = this.getParameter(request, "label", false);
        String comment = this.getParameter(request, "comment", false);
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("This service is only for use by administrators.");
        }
        if (label == null) {
            label = "";
        }
        if (comment == null) {
            comment = "";
        }
        if (uri == null && action != Action.create) {
            throw new BadRequestException("Value for 'uri' is required when action is not create.");
        }
        if (action == Action.create && label == null) {
            throw new BadRequestException("Value for 'label' is required when action is create.");
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        String message = "";
        Role r = null;
        if (action == Action.create) {
            r = Role.create((HttpServletRequest)request, (URI)uri, (String)label, (String)comment, (boolean)false);
            uri = r.getURI();
            message = "Created new Role.";
        } else {
            r = Role.find((HttpServletRequest)request, (URI)uri);
            if (r == null) {
                throw new NotFoundException("No such role, uri=" + uri);
            }
            if (action == Action.update) {
                r.setLabel(request, label);
                r.setComment(request, comment);
                message = "Modified role \"" + r.getLabel() + "\"";
            } else if (action == Action.delete) {
                r.delete(request);
                message = "Deleted role \"" + r.getLabel() + "\"";
            }
        }
        if (r != null) {
            r.commit(request);
        }
        this.redirectToJSP(request, response, message, PASS_THRU_ARGS, new String[]{"uri", uri.stringValue()});
    }
}

