/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Dataset;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static Logger log = LogManager.getLogger(Utils.class);
    private static final int BUFSIZ = 8192;
    private static final int MILLISEC_MINUTE = 60000;
    private static final int BYTE_MASK = 255;
    private static final SimpleDateFormat preciseHTTPDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss.SSS zzz");

    private Utils() {
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static String prettyPrint(Dataset ds) {
        StringBuilder result = new StringBuilder();
        for (URI u : ds.getDefaultGraphs()) {
            result.append("FROM ").append(u == null ? "{null}" : "<" + u.toString() + ">").append("\n");
        }
        for (URI u : ds.getNamedGraphs()) {
            result.append("FROM NAMED ").append(u == null ? "{null}" : "<" + u.toString() + ">").append("\n");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static boolean isValidURI(String s) {
        try {
            new URIImpl(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static URI parseURI(String s, String argName, boolean required) {
        if (s == null || s.trim().length() == 0) {
            if (required) {
                throw new BadRequestException("Missing required argument: " + argName);
            }
            return null;
        }
        try {
            return new URIImpl(s);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Argument '" + argName + "' is not a valid URI: " + e);
        }
    }

    public static Enum parseKeywordArg(Class et, String name, String argName, boolean required, Enum defaultValue) {
        if (name == null) {
            if (required) {
                throw new BadRequestException("Missing required argument: " + argName);
            }
            return defaultValue;
        }
        try {
            return Enum.valueOf(et, name);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Illegal value for '" + argName + "', must be one of: " + Arrays.deepToString(Utils.getKeywordValues((Class)et)), (Throwable)e);
        }
    }

    private static Enum[] getKeywordValues(Class et) {
        try {
            return (Enum[])et.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Failed generating list of acceptable values for keyword: " + et.getName()), (Throwable)e);
            throw new InternalServerErrorException("Failed generating list of acceptable values for keyword: " + et.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Failed generating list of acceptable values for keyword: " + et.getName()), (Throwable)e);
            throw new InternalServerErrorException("Failed generating list of acceptable values for keyword: " + et.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Failed generating list of acceptable values for keyword: " + et.getName()), (Throwable)e);
            throw new InternalServerErrorException("Failed generating list of acceptable values for keyword: " + et.getName(), (Throwable)e);
        }
    }

    public static boolean parseBooleanParameter(String name, String argName, boolean required, boolean defaultValue) {
        BooleanArg b = null;
        if (name == null) {
            if (required) {
                throw new BadRequestException("Missing required argument: " + argName);
            }
            b = defaultValue ? BooleanArg.true1 : BooleanArg.false1;
        } else {
            for (BooleanArg ba : BooleanArg.values()) {
                if (!BooleanArg.access$000((BooleanArg)ba).equals(name)) continue;
                b = ba;
                break;
            }
            if (b == null) {
                throw new BadRequestException("Illegal value for '" + argName + "', must be one of: " + Arrays.deepToString(BooleanArg.values()));
            }
        }
        return b.getBooleanValue();
    }

    public static XMLGregorianCalendar parseXMLDate(String raw) {
        XMLGregorianCalendar result = null;
        try {
            result = XMLDatatypeUtil.parseCalendar((String)raw);
            if (result.getDay() == Integer.MIN_VALUE) {
                throw new BadRequestException("This date/time argument is incomplete, it must include at least complete date: " + raw);
            }
            if (result.getHour() == Integer.MIN_VALUE) {
                result.setHour(0);
            }
            if (result.getMinute() == Integer.MIN_VALUE) {
                result.setMinute(0);
            }
            if (result.getSecond() == Integer.MIN_VALUE) {
                result.setSecond(0);
            }
            if (result.getTimezone() == Integer.MIN_VALUE) {
                TimeZone td = TimeZone.getDefault();
                int tzMinutes = td.getRawOffset() / 60000;
                if (td.inDaylightTime(new Date())) {
                    tzMinutes += td.getDSTSavings() / 60000;
                }
                result.setTimezone(tzMinutes);
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Illegal date format in this date/time argument: " + e.toString(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseXMLDate: given string = \"" + raw + "\", interpreted as = " + result + ", as java.util.Date = " + result.toGregorianCalendar().getTime().toString()));
        }
        return result;
    }

    public static String makeContentType(String mimeType, String charset) {
        if (mimeType.indexOf("charset=") < 0) {
            return mimeType + "; charset=" + charset;
        }
        return mimeType;
    }

    public static String contentTypeGetCharset(String ct, String dflt) {
        int lastQuote;
        if (ct == null) {
            return dflt;
        }
        String[] e = ct.split(";\\s*[cC][hH][aA][rR][sS][eE][tT]=", 2);
        if (e.length < 2) {
            return dflt;
        }
        String result = e[1];
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if ((lastQuote = result.indexOf(34)) >= 0) {
            result = result.substring(0, lastQuote);
        }
        return result;
    }

    public static String contentTypeGetMIMEType(String ct) {
        String[] e = ct.split(";\\s*", 2);
        return e[0];
    }

    public static String toString(byte[] ba) {
        StringBuilder result = new StringBuilder("[");
        boolean first = true;
        for (byte b : ba) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            String h = Integer.toHexString(b & 0xFF);
            if (h.length() < 2) {
                result.append("0");
            }
            result.append(h);
        }
        result.append("]");
        return result.toString();
    }

    public static String valueAsString(Value val) {
        return val == null ? "{null}" : (val instanceof Literal ? ((Literal)val).getLabel() : val.stringValue());
    }

    public static String urlEncode(String in) throws IOException {
        try {
            byte[] bb = in.getBytes("UTF-8");
            StringBuilder result = new StringBuilder();
            for (byte b : bb) {
                char c = (char)b;
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '~') {
                    result.append(c);
                    continue;
                }
                String hex = Integer.toHexString(b & 0xFF);
                result.append(hex.length() < 2 ? "%0" : "%");
                result.append(hex);
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static String escapeHTMLAttribute(String in) {
        return in.replace("&", "&amp;").replace("\"", "&quot;");
    }

    public static String getMavenVersionFromJar(String jarURLspec) throws IOException {
        ZipInputStream jis = null;
        try {
            JarEntry je;
            URL jarURL = new URL(jarURLspec);
            Properties pp = new Properties();
            jis = new JarInputStream(jarURL.openStream());
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                if (je.isDirectory()) continue;
                String fn = je.getName();
                if (!fn.startsWith("META-INF/maven/") || !fn.endsWith("/pom.properties")) continue;
                log.debug((Object)("..found POM properties: " + fn));
                pp.load(jis);
                if (pp.containsKey("version")) {
                    String string = pp.getProperty("version");
                    return string;
                }
                log.warn((Object)("Cannot find 'version' property in jar's POM properties, jar URL=" + jarURL + ", entry=" + fn));
                String string = null;
                return string;
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new IOException(e);
        }
        finally {
            if (jis != null) {
                jis.close();
            }
        }
        log.warn((Object)("Cannot find Maven POM properties file in jar, resource URL=" + jarURLspec));
        return null;
    }

    public static String getVersionInfo(RepositoryConnection rc, URI subject, URI graph) throws RepositoryException {
        String result = Utils.getVersionInfoInternal((RepositoryConnection)rc, (URI)subject, (URI)OWL.VERSIONINFO, (URI)graph);
        if (result == null) {
            result = Utils.getVersionInfoInternal((RepositoryConnection)rc, (URI)subject, (URI)REPO.VERSION_INFO, (URI)graph);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionInfoInternal(RepositoryConnection rc, URI subject, URI predicate, URI graph) throws RepositoryException {
        RepositoryResult rr = rc.getStatements((Resource)subject, predicate, null, false, new Resource[]{graph});
        try {
            Value version;
            if (rr.hasNext() && (version = ((Statement)rr.next()).getObject()) instanceof Literal) {
                String string = ((Literal)version).getLabel();
                return string;
            }
        }
        finally {
            rr.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI getHomeGraph(RepositoryConnection rc, URI resource) throws RepositoryException {
        RepositoryResult rr = null;
        try {
            rr = rc.getStatements((Resource)resource, RDF.TYPE, null, false, new Resource[0]);
            while (rr.hasNext()) {
                Statement s = (Statement)rr.next();
                Resource ctx = s.getContext();
                log.debug((Object)("Found statement: " + resource + " rdf:type " + s.getObject() + ", in graph " + ctx));
                if (!(ctx instanceof URI)) continue;
                URI uRI = (URI)ctx;
                return uRI;
            }
        }
        finally {
            rr.close();
        }
        return null;
    }

    public static String collectionDeepToString(Collection<? extends Object> c) {
        StringBuilder result = new StringBuilder("{");
        boolean first = true;
        Iterator<? extends Object> ci = c.iterator();
        while (ci.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            Object cin = ci.next();
            if (cin instanceof String) {
                result.append("\"").append(cin).append("\"");
                continue;
            }
            result.append(cin);
        }
        result.append("}");
        return result.toString();
    }

    public static String makePreciseHTTPDate(Date d) {
        return preciseHTTPDate.format(d);
    }

    public static String join(String glue, String[] as) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : as) {
            if (first) {
                first = false;
            } else {
                result.append(glue);
            }
            result.append(s);
        }
        return result.toString();
    }

    static {
        preciseHTTPDate.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT"), Locale.getDefault()));
    }
}

