<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -
   - Users Admin - present a list of users with 4 columns:
   -   1. username (login name), also a link to edit user/roles
   -   2. personal name, if any
   -   3. is administrator flag?
   -   4. button/link to disable or enable
   -
   -  Args:
   -   action=disable -- handle a disable action on one user
   -    (default action is just to list users; create and reinstate
   -     are done in the user-edit page since they require password entry.)
   -   username -- principal (login) name of new user to disable
  --%>
<%@ page import="java.util.Arrays" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.HashMap" %>
<%@ page import="java.util.Set" %>

<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.model.User" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>

  <head>
    <%@ include file="../head.jsp" %>
    <title>Eagle-I Data Repository Admin - Manage User Accounts</title>
  </head>
<%
    // feedback message about status of any chosen operation
    request.setCharacterEncoding("UTF-8");
    String message = request.getParameter("message");
    boolean messageSuccess = true;

    try {
        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Manage User Accounts</h2>

<%
        if (message != null) {
%>
    <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
    </h3>
<%
        }
%>
     <h3>&#x26ab; <a href="/repository/admin/editUserPortlet.jsp?standalone&amp;create_auth">
         Create a New User Account</a>
     </h3>
    <h3>&#x26ab; Manage Existing User Accounts</h3>
    <!-- columns: username, personal name, enabled? -->
    <div style="margin: 0px 0px 0px 30px;">
    <table border="1">
    <tr>
      <th>Login</th>
      <th>Personal Name</th>
      <th>Admin?</th>
      <th>Action</th>
    </tr>
<%
    Map<String,User> username2user = new HashMap<String,User>();
    for (User u : User.findAll(request)) {
        username2user.put(u.getUsername(), u);
    }
    Set<String> userSet = username2user.keySet();
    String users[] = userSet.toArray(new String[userSet.size()]);
    Arrays.sort(users);
    for (String uu : users) {
        String eu = Utils.escapeHTMLAttribute(Utils.urlEncode(uu));
        User u = username2user.get(uu);
        String epn = null;
        if (u == null || u.getURI() == null) {
            epn = "<i>Undocumented</i>";
        } else {
            epn = u.getPersonalName() == null ? null :
                    StringEscapeUtils.escapeHtml(u.getPersonalName());
        }
 %>
        <tr>
          <td>
            <a href="/repository/admin/editUserPortlet.jsp?standalone=true&username=<%= eu %>">
                  <tt><%= uu %></tt>
            </a>
          </td>
          <td><%= epn == null ? "&nbsp;" : epn %></td>
          <td><%= (u == null ? false : u.isSuperuser()) ? "Yes" : "&nbsp;" %></td>
          <!-- skull == unicode &#x2620; heart=&#x2661, solidheart 2665  -->
          <td>
<%
        if (u.isLoginable()) {
%>
           <form action="/repository/admin/updateUser" method="POST">
            <input type="hidden" name="username" value="<%= eu %>"/>
            <input type="hidden" name="action" value="disable"/>
            <button name="submit" value="submit" type="submit">&#x2620 Disable</button>
           </form>
<%
        } else {
%>
           <form action="/repository/admin/editUserPortlet.jsp" method="GET">
            <input type="hidden" name="standalone"/>
            <input type="hidden" name="only_password"/>
            <input type="hidden" name="username" value="<%= eu %>"/>
            <input type="hidden" name="create_auth" value="true"/>
            <button name="submit" value="submit" type="submit">&#x2665 Reinstate</button>
           </form>
<%
        }
%>
          </td>
        </tr>
<%
    }
%>
    </table>
    <i>Click on username to edit user's properties, change password, etc.</i>
    </div>
    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
