/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model.workflow;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.User;
import org.eaglei.repository.model.WritableObjectModel;
import org.eaglei.repository.model.workflow.ErrorAction;
import org.eaglei.repository.model.workflow.WorkflowAction;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WorkflowTransition
extends WritableObjectModel {
    private static Logger log = LogManager.getLogger(WorkflowTransition.class);
    private URI uri;
    private String label = null;
    private String comment = null;
    private URI workspace = null;
    private URI initialState = null;
    private URI finalState = null;
    private WorkflowAction action = null;
    private Value actionParameter = null;
    private Literal order = null;
    private String workspaceLabel = null;
    private String initialLabel = null;
    private String finalLabel = null;
    private static final String transitionQueryPrefix = "{?uri a <" + REPO.WORKFLOW_TRANSITION + "> ; \n" + " <" + RDFS.LABEL + "> ?label ;\n" + " <" + REPO.INITIAL + "> ?initial; \n" + " <" + REPO.FINAL + "> ?final. \n" + " OPTIONAL { ?uri <" + REPO.ACTION + "> ?action . \n" + "   OPTIONAL { ?uri <" + REPO.ACTION_PARAMETER + "> ?actionParameter }} \n" + " OPTIONAL { ?uri <" + RDFS.COMMENT + "> ?comment }\n" + " OPTIONAL { ?uri <" + REPO.WORKSPACE + "> ?workspace \n" + "   OPTIONAL { ?workspace <" + RDFS.LABEL + "> ?workspaceLabel }}\n" + " OPTIONAL { ?initial <" + RDFS.LABEL + "> ?initialLabel }\n" + " OPTIONAL { ?final <" + RDFS.LABEL + "> ?finalLabel }\n" + " OPTIONAL { ?uri <" + REPO.ORDER + "> ?order } \n";
    private static final String transitionQuerySuffix = "ORDER BY ?order ?label";
    public static final String SIMPLE_TRANSITION_QUERY = "SELECT DISTINCT * WHERE " + transitionQueryPrefix + "}" + "ORDER BY ?order ?label";

    private WorkflowTransition(URI uri, String label, String comment, URI initialState, URI finalState) {
        this.uri = uri;
        this.label = label;
        this.comment = comment;
        this.initialState = initialState;
        this.finalState = finalState;
    }

    public static WorkflowTransition find(HttpServletRequest request, URI uri) throws ServletException {
        List result = WorkflowTransition.findAccessibleByAttributes((HttpServletRequest)request, (URI)uri, null, null, null);
        if (result.isEmpty()) {
            throw new NotFoundException("There is no Transition of URI=" + uri);
        }
        return (WorkflowTransition)result.get(0);
    }

    public static List<WorkflowTransition> findAll(HttpServletRequest request) throws ServletException {
        return WorkflowTransition.findAccessibleByAttributes((HttpServletRequest)request, null, null, null, null);
    }

    public static List<WorkflowTransition> findAccessibleByAttributes(HttpServletRequest request, URI single, URI initialStateMatch, URI workspaceMatch, URI accessible) throws ServletException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            StringBuilder qb = new StringBuilder(transitionQueryPrefix);
            if (workspaceMatch != null) {
                qb.append(" FILTER (!BOUND(?workspace) || ?workspace = <").append(workspaceMatch).append(">)\n");
            }
            qb.append("}");
            ArrayList<WorkflowTransition> result = new ArrayList<WorkflowTransition>();
            WFTHandler hdl = new WFTHandler(result);
            boolean superuser = false;
            if (accessible != null) {
                if (REPO.ROLE_SUPERUSER.equals(accessible)) {
                    superuser = true;
                } else {
                    User au = User.find((HttpServletRequest)request, (URI)accessible);
                    boolean bl = superuser = au != null && au.isSuperuser();
                }
                if (superuser) {
                    log.debug((Object)"findAccessibleByAttr: Eliding filter because accessor is superuser");
                }
            }
            if (accessible == null || superuser) {
                qb.insert(0, "SELECT DISTINCT * WHERE ");
                qb.append("ORDER BY ?order ?label");
                String qs = qb.toString();
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
                q.clearBindings();
                if (single != null) {
                    q.setBinding("uri", (Value)single);
                }
                if (initialStateMatch != null) {
                    q.setBinding("initial", (Value)initialStateMatch);
                }
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.setIncludeInferred(false);
                SPARQL.evaluateTupleQuery((String)qs, (TupleQuery)q, (TupleQueryResultHandler)hdl);
            } else {
                MapBindingSet bs = new MapBindingSet(2);
                if (single != null) {
                    bs.addBinding("uri", (Value)single);
                }
                if (initialStateMatch != null) {
                    bs.addBinding("initial", (Value)initialStateMatch);
                }
                Access.filterByPermission((HttpServletRequest)request, (URI)accessible, (String)"uri", (String)" * ", (String)qb.toString(), (Access)Access.READ, (Dataset)SPARQL.InternalGraphs, (BindingSet)bs, (TupleQueryResultHandler)hdl);
            }
            log.debug((Object)("findAccessibleByAttributes: Got result count=" + String.valueOf(result.size())));
            return result;
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getLabel() {
        return this.label == null ? this.uri.stringValue() : this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public URI getWorkspace() {
        return this.workspace;
    }

    public String getWorkspaceLabel() {
        return this.workspaceLabel;
    }

    public URI getInitial() {
        return this.initialState;
    }

    public String getInitialLabel() {
        return this.initialLabel;
    }

    public URI getFinal() {
        return this.finalState;
    }

    public String getFinalLabel() {
        return this.finalLabel;
    }

    public String getOrder() {
        return this.order == null ? null : Utils.valueAsString((Value)this.order);
    }

    public WorkflowAction getAction() {
        return this.action;
    }

    public boolean isErrorAction() {
        return this.action instanceof ErrorAction;
    }

    public Value getActionParameter() {
        return this.actionParameter;
    }

    public static WorkflowTransition create(HttpServletRequest request, URI prefURI, String label, String comment, URI initialState, URI finalState) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to create a new Transition.");
        }
        if (label == null || label.trim().length() == 0) {
            throw new BadRequestException("Label is required when creating a new Transition.");
        }
        if (initialState == null || finalState == null) {
            throw new BadRequestException("Initial and Final WorkflowStates are required when creating a new Transition.");
        }
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        ValueFactory vf = rc.getValueFactory();
        URI subject = prefURI != null ? prefURI : vf.createURI(Configuration.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
        WorkflowTransition result = new WorkflowTransition(subject, label, comment, initialState, finalState);
        log.debug((Object)("Created new transition: " + result));
        result.setDirty(true);
        result.write(request, false);
        return result;
    }

    public URI write(HttpServletRequest request, boolean makeURI) throws ServletException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ValueFactory vf = rc.getValueFactory();
            if (makeURI) {
                this.uri = vf.createURI(Configuration.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
            }
            log.debug((Object)("Writing to RDF database: " + this));
            rc.add((Resource)this.uri, RDF.TYPE, (Value)REPO.WORKFLOW_TRANSITION, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)this.uri, RDFS.LABEL, (Value)vf.createLiteral(this.label), new Resource[]{REPO.NG_INTERNAL});
            if (this.comment != null) {
                rc.add((Resource)this.uri, RDFS.COMMENT, (Value)vf.createLiteral(this.comment), new Resource[]{REPO.NG_INTERNAL});
            }
            rc.add((Resource)this.uri, REPO.INITIAL, (Value)this.initialState, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)this.uri, REPO.FINAL, (Value)this.finalState, new Resource[]{REPO.NG_INTERNAL});
            if (this.workspace != null) {
                rc.add((Resource)this.uri, REPO.WORKSPACE, (Value)this.workspace, new Resource[]{REPO.NG_INTERNAL});
            }
            if (this.action != null) {
                rc.add((Resource)this.uri, REPO.ACTION, (Value)vf.createLiteral(this.action.getClass().getName()), new Resource[]{REPO.NG_INTERNAL});
            }
            if (this.actionParameter != null) {
                rc.add((Resource)this.uri, REPO.ACTION_PARAMETER, this.actionParameter, new Resource[]{REPO.NG_INTERNAL});
            }
            if (this.order != null) {
                rc.add((Resource)this.uri, REPO.ORDER, (Value)this.order, new Resource[]{REPO.NG_INTERNAL});
            }
            return this.uri;
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void delete(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to delete a Transition.");
        }
        log.debug((Object)("Deleting: " + this));
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.uri, null, null, new Resource[]{REPO.NG_INTERNAL});
            this.setDirty(true);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setLabel(HttpServletRequest request, String val) throws ServletException {
        if (val == null || val.length() == 0) {
            throw new BadRequestException("Label must be a non-empty string.");
        }
        this.label = val;
        this.setMetadataInternal(request, RDFS.LABEL, (Value)new LiteralImpl(val));
    }

    public void setComment(HttpServletRequest request, String val) throws ServletException {
        this.comment = val;
        this.setMetadataInternal(request, RDFS.COMMENT, (Value)(val == null ? null : new LiteralImpl(val)));
    }

    public void setWorkspace(HttpServletRequest request, URI val) throws ServletException {
        this.workspace = val;
        this.setMetadataInternal(request, REPO.WORKSPACE, (Value)val);
    }

    public void setInitial(HttpServletRequest request, URI val) throws ServletException {
        if (val == null) {
            throw new BadRequestException("New state value may not be null");
        }
        this.initialState = val;
        this.setMetadataInternal(request, REPO.INITIAL, (Value)val);
    }

    public void setFinal(HttpServletRequest request, URI val) throws ServletException {
        if (val == null) {
            throw new BadRequestException("New state value may not be null");
        }
        this.finalState = val;
        this.setMetadataInternal(request, REPO.FINAL, (Value)val);
    }

    public void setOrder(HttpServletRequest request, String val) throws ServletException {
        NumericLiteralImpl litVal;
        block3: {
            litVal = null;
            try {
                if (val != null) {
                    litVal = new NumericLiteralImpl((Number)Integer.decode(val), XMLSchema.INTEGER);
                }
            }
            catch (NumberFormatException e) {
                log.debug((Object)("setOrder: got non-integer value = \"" + val + "\""));
                if (val == null) break block3;
                litVal = new LiteralImpl(val);
            }
        }
        this.order = litVal;
        this.setMetadataInternal(request, REPO.ORDER, (Value)litVal);
    }

    public void setAction(HttpServletRequest request, String val) throws ServletException {
        if (val != null) {
            try {
                Object newAction = Class.forName(val).newInstance();
                if (!(newAction instanceof WorkflowAction)) {
                    throw new BadRequestException("Action class does not implement WorkflowAction: " + val);
                }
                this.action = (WorkflowAction)newAction;
            }
            catch (Exception e) {
                throw new BadRequestException("Failed to instantiate Action class: " + val + ": " + e);
            }
        }
        this.setMetadataInternal(request, REPO.ACTION, (Value)(val == null ? null : new LiteralImpl(val)));
    }

    public void setActionParameter(HttpServletRequest request, String str) throws ServletException {
        Object val = null;
        if (str != null) {
            val = Utils.isValidURI((String)str) ? new URIImpl(str) : new LiteralImpl(str);
        }
        this.setActionParameter(request, val);
    }

    public void setActionParameter(HttpServletRequest request, Value val) throws ServletException {
        this.actionParameter = val;
        this.setMetadataInternal(request, REPO.ACTION_PARAMETER, val);
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, Value newVal) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must be an Administrator to modify Transitions.");
        }
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.uri, property, null, new Resource[]{REPO.NG_INTERNAL});
            if (newVal != null) {
                rc.add((Resource)this.uri, property, newVal, new Resource[]{REPO.NG_INTERNAL});
                log.debug((Object)("Setting Transition uri=" + this.uri + ", property=" + property + " to value=" + newVal));
            } else {
                log.debug((Object)("Clearing Transition uri=" + this.uri + ", property=" + property));
            }
            this.setDirty(true);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String toString() {
        return "<#Transition: uri=" + this.uri.toString() + ", label=" + this.label + ">";
    }

    public boolean equals(Object other) {
        return other instanceof WorkflowTransition && this.uri.equals(((WorkflowTransition)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ URI access$202(WorkflowTransition x0, URI x1) {
        x0.workspace = x1;
        return x0.workspace;
    }

    static /* synthetic */ String access$302(WorkflowTransition x0, String x1) {
        x0.workspaceLabel = x1;
        return x0.workspaceLabel;
    }

    static /* synthetic */ String access$402(WorkflowTransition x0, String x1) {
        x0.initialLabel = x1;
        return x0.initialLabel;
    }

    static /* synthetic */ String access$502(WorkflowTransition x0, String x1) {
        x0.finalLabel = x1;
        return x0.finalLabel;
    }

    static /* synthetic */ Literal access$602(WorkflowTransition x0, Literal x1) {
        x0.order = x1;
        return x0.order;
    }

    static /* synthetic */ Value access$702(WorkflowTransition x0, Value x1) {
        x0.actionParameter = x1;
        return x0.actionParameter;
    }

    static /* synthetic */ WorkflowAction access$802(WorkflowTransition x0, WorkflowAction x1) {
        x0.action = x1;
        return x0.action;
    }
}

