/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.workflow.Workflow;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;

public class WorkflowClaim
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WorkflowClaim.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        URI uri = this.getParameterAsURI(request, "uri", true);
        URI userURI = this.getParameterAsURI(request, "user", false);
        URI myself = Authentication.getPrincipalURI((HttpServletRequest)request);
        if (userURI == null) {
            userURI = myself;
        } else if (!myself.equals(userURI) && !Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Claiming on behalf of another user requires administrator access.");
        }
        Workflow wf = Workflow.find((HttpServletRequest)request, (URI)uri);
        if (log.isDebugEnabled()) {
            log.debug((Object)("CLAIM PARAMETERS:\nresource=" + uri + "\nowner=" + userURI + "\nstate=" + wf.getState() + "\nhome graph=" + wf.getHomeGraph()));
        }
        wf.assertClaim(request, userURI);
        try {
            WithRepositoryConnection.get((ServletRequest)request).commit();
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

