<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
 xmlns="http://www.w3.org/1999/xhtml"
 xmlns:repo="http://eagle-i.org/xsd/repo/"
 xmlns:xhtml="http://www.w3.org/1999/xhtml"
 xmlns:xml="http://www.w3.org/XML/1998/namespace"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:param name="__repo_version" select="'(Need to set the __repo_version parameter)'"/>

  <xsl:param name="__repo_css" select="'(Need to set the __repo_css parameter)'"/>

  <xsl:param name="__repo_logo" select="'(Need to set the __repo_logo parameter)'"/>

  <xsl:param name="__repo_title" select="'(Need to set the __repo_title parameter)'"/>

  <xsl:variable name="label" select="/repo:instance/repo:resource/text()"/>

  <xsl:variable name="uri" select="/repo:instance/repo:resource/@uri"/>

  <xsl:template match="/repo:instance">
   <html>
     <head>
       <meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
       <meta name="eaglei.version">
         <xsl:attribute name="content">
           <xsl:value-of select="$__repo_version"/>
         </xsl:attribute>
       </meta>
       <title><xsl:value-of select="$label"/></title>
       <meta name="eaglei.repository.title">
         <xsl:attribute name="content">
           <xsl:value-of select="$__repo_title"/>
         </xsl:attribute>
       </meta>
       <link rel="stylesheet" type="text/css">
         <xsl:attribute name="href">
           <xsl:value-of select="$__repo_css"/>
         </xsl:attribute>
       </link>
     </head>
     <body>
       <hr/>
       <table>
         <tr>
           <td width="30%">
             <img border="0" alt="Institutional Logo" align="right">
               <xsl:attribute name="src">
                 <xsl:value-of select="$__repo_logo"/>
               </xsl:attribute>
             </img>
           </td>
           <td width="70%">
             <div align="center">
                <font size="+1" color="black">
                  <xsl:value-of select="$__repo_title"/>
                </font>
             </div>
           </td>
         </tr>
       </table>
       <hr/>
       <h2><xsl:value-of select="$label"/></h2>
       <h3><xsl:value-of select="$uri"/></h3>

       <!-- simple contact link -->
       <a target="new">
         <xsl:attribute name="href">
           <xsl:value-of select="concat('/repository/contact?uri=',$uri)"/>
         </xsl:attribute>
         Contact the owner of this resource!
       </a>

       <h3>Direct Types</h3>
       <ol>
         <xsl:apply-templates select="repo:asserted-types/*" mode="typeList"/>
       </ol>

       <h3>Inferred Types</h3>
       <ol>
         <xsl:apply-templates select="repo:inferred-types/*" mode="typeList"/>
       </ol>

       <h3>Properties</h3>
       <ol>
         <xsl:apply-templates select="repo:properties/*" mode="propertyList"/>
       </ol>

       <h3>Provenance Metadata</h3>
       <ol>
         <xsl:apply-templates select="repo:metadata/*" mode="propertyList"/>
       </ol>

       <!-- links to edit and/or mung rights -->
       <xsl:apply-templates select="repo:permission"/>

     </body>
   </html>
  </xsl:template>

  <xsl:template match="repo:resource" mode="typeList">
    <li>
      <xsl:apply-templates select="."/>
    </li>
  </xsl:template>

  <xsl:template match="repo:property" mode="propertyList">
    <li>
      <xsl:apply-templates select="."/>
    </li>
  </xsl:template>

  <xsl:template match="repo:property">
    <dl>
      <dt>
        <xsl:apply-templates select="repo:predicate/*"/>
      </dt>
      <dd>
        <xsl:apply-templates select="repo:object/*"/>
      </dd>
    </dl>
  </xsl:template>


  <!-- General rendering of Resource: make a link out of it -->
  <xsl:template match="repo:resource">
    <a>
      <xsl:attribute name="href">
        <xsl:value-of select="@uri"/>
      </xsl:attribute>
      <xsl:value-of select="text()"/>
    </a>
  </xsl:template>

  <!-- Render a Literal
       1. if it is a URL (type == xsd:anyURI), show it as a link
          (could optionally check for starting with "http(s?):")
       2. otherwise show as text, passing through any xml:lang attribute.
   -->
  <xsl:template match="repo:literal">
    <xsl:choose>
      <xsl:when test="@type = 'http://www.w3.org/2001/XMLSchema#anyURI'">
        <a>
          <xsl:attribute name="href">
            <xsl:value-of select="text()"/>
          </xsl:attribute>
          <xsl:value-of select="text()"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <span>
          <xsl:if test="@xml:lang">
            <xsl:attribute name="xml:lang">
              <xsl:value-of select="@xml:lang"/>
            </xsl:attribute>
          </xsl:if>
          <xsl:value-of select="text()"/>
        </span>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- links to edit and/or mung rights -->
  <xsl:template match="repo:permission">
    <xsl:if test="@admin = 'true'">
      <form method="POST" action="/repository/admin/editGrants.jsp">
        <input type="hidden" name="type" value="Resource Instance" />
        <input type="hidden" name="uri">
          <xsl:attribute name="value">
            <xsl:value-of select="$uri"/>
          </xsl:attribute>
        </input>
        <input type="hidden" name="label">
          <xsl:attribute name="value">
            <xsl:value-of select="$label"/>
          </xsl:attribute>
        </input>
        <button type="submit">Edit Access Controls</button>
      </form>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
