/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.inferencer.MinimalInferencer;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.Sail;
import org.openrdf.sail.nativerdf.NativeStore;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Lifecycle {
    private static Logger log = LogManager.getLogger(Lifecycle.class);
    private static final String ATTR_LAST_MODIFIED = "org.eaglei.repository.lastModified";
    private static final String SCTX_REPOSITORY = "org.eaglei.repository.SesameRepository";
    private static final String SCTX_GENERATION = "org.eaglei.repository.Generation";
    private static final Map<URI, String> graphInitFile = new HashMap();
    public static final Date STARTUP;
    private ServletContext servletContext = null;
    private Date lastModified = new Date();
    private static Lifecycle instance;

    public Lifecycle(ServletContext sc) {
        this.servletContext = sc;
    }

    public static Lifecycle getInstance() {
        return instance;
    }

    public static void initialize(ServletContext sc) {
        if (instance == null) {
            try {
                Configuration.getInstance().initialize();
                instance = new Lifecycle(sc);
                instance.finishInitialize();
            }
            catch (Exception e) {
                log.fatal((Object)"Got exception in Webapp context initialization, DO NOT EXPECT ANYTHING TO WORK NOW:", (Throwable)e);
            }
        } else {
            log.fatal((Object)"Initialize was called after Lifecycle already initialized!");
        }
    }

    public void finishInitialize() throws IOException, OpenRDFException {
        File sesDir = Configuration.getInstance().getSesameDirectory();
        NativeStore ns = new NativeStore(sesDir);
        SailRepository r = new SailRepository((Sail)new MinimalInferencer((NotifyingSail)ns));
        String[] indexes = Configuration.getInstance().getConfigurationPropertyArray("eaglei.repository.sesame.indexes", null);
        if (indexes != null) {
            String si = Utils.join((String)", ", (String[])indexes);
            log.debug((Object)("Setting Sesame NativeStore indexes to: \"" + si + "\""));
            ns.setTripleIndexes(si);
        }
        r.initialize();
        if (!r.isWritable()) {
            log.fatal((Object)"Sesame repo is not writable, this is going to cause trouble soon!");
        }
        this.servletContext.setAttribute("org.eaglei.repository.SesameRepository", (Object)r);
        log.info((Object)("Sesame Repository open, directory=" + sesDir.toString()));
        this.servletContext.setAttribute("org.eaglei.repository.Generation", (Object)1);
        log.debug((Object)"Generation initialized to 1.");
        for (URI key : graphInitFile.keySet()) {
            this.loadEmptyGraphFromInit((Repository)r, key, true);
        }
    }

    public void destroy(ServletContext sc) throws RepositoryException {
        Repository r = (Repository)sc.getAttribute("org.eaglei.repository.SesameRepository");
        sc.removeAttribute("org.eaglei.repository.SesameRepository");
        if (r != null) {
            r.shutDown();
            log.info((Object)"Sesame Repository closed.");
        }
        instance = null;
    }

    public static String getInitFileVersion(URI uri) throws IOException, RDFParseException, RDFHandlerException {
        String resourcePath = (String)graphInitFile.get(uri);
        if (resourcePath != null) {
            RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.forFileName((String)resourcePath, (RDFFormat)RDFFormat.N3));
            VersionFinder vf = new VersionFinder(uri, null);
            parser.setRDFHandler((RDFHandler)vf);
            parser.parse((Reader)new InputStreamReader(Lifecycle.class.getClassLoader().getResourceAsStream(resourcePath), "UTF-8"), "");
            return VersionFinder.access$100((VersionFinder)vf);
        }
        log.warn((Object)("No resource path found for uri=" + uri));
        return null;
    }

    public static String getGraphInitFile(URI uri) {
        return (String)graphInitFile.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEmptyGraphFromInit(Repository r, URI graphURI, boolean ifEmpty) throws RepositoryException, IOException, RDFParseException {
        RepositoryConnection rc = null;
        try {
            rc = r.getConnection();
            this.loadEmptyGraphFromInit(rc, graphURI, ifEmpty);
        }
        finally {
            if (rc != null) {
                rc.close();
            }
        }
    }

    public void loadEmptyGraphFromInit(RepositoryConnection rc, URI graphURI, boolean ifEmpty) throws RepositoryException, IOException, RDFParseException {
        if (!ifEmpty || rc.size(new Resource[]{graphURI}) == 0L) {
            String resourcePath = (String)graphInitFile.get(graphURI);
            if (resourcePath == null) {
                log.error((Object)("No local resource path found (NOT loading anything) for URI=" + graphURI));
                return;
            }
            URL rurl = this.getClass().getClassLoader().getResource(resourcePath);
            if (rurl == null) {
                log.error((Object)("Cannot find webapp resource at path=" + resourcePath));
            } else {
                URLConnection ruc = rurl.openConnection();
                long rdate = ruc.getLastModified();
                log.debug((Object)("Loading graph=" + graphURI.toString() + " from URL=" + rurl.toString() + ", mod-date=" + rdate));
                InputStreamReader is = new InputStreamReader(ruc.getInputStream(), "UTF-8");
                if (is == null) {
                    log.error((Object)("Cannot open webapp resource at url=" + rurl));
                } else {
                    rc.add((Reader)is, graphURI.toString(), RDFFormat.forFileName((String)resourcePath, (RDFFormat)RDFFormat.N3), new Resource[]{graphURI});
                    Provenance gp = new Provenance(graphURI);
                    gp.setProvenanceStatement(rc, DCTERMS.CREATED, (Value)Provenance.makeDateTime((Date)new Date()));
                    gp.setProvenanceStatement(rc, DCTERMS.CREATOR, (Value)REPO.ROLE_SUPERUSER);
                    gp.setSourceStatements(rc, (Value)rc.getValueFactory().createURI(rurl.toString()), (Value)Provenance.makeDateTime((Date)new Date(rdate)));
                    rc.commit();
                    log.info((Object)("Initialized the empty named graph, name=" + graphURI + ", from resource path=" + resourcePath));
                }
            }
        }
    }

    public Repository getSesameRepository() throws ServletException {
        Repository result = (Repository)this.servletContext.getAttribute("org.eaglei.repository.SesameRepository");
        if (result == null) {
            throw new ServletException("No RDF database connection, probably because of a failure in initialization.");
        }
        return result;
    }

    public void notifyDataReplaced() {
        this.incrementGeneration();
        Lifecycle.decacheAll();
    }

    private void incrementGeneration() {
        int gen = 1 + (Integer)this.servletContext.getAttribute("org.eaglei.repository.Generation");
        this.servletContext.setAttribute("org.eaglei.repository.Generation", (Object)gen);
        log.debug((Object)("Generation is incremented to " + gen));
    }

    public boolean isSessionStale(HttpSession session) {
        Integer sessionGen = (Integer)session.getAttribute("org.eaglei.repository.Generation");
        Integer ctxGen = (Integer)this.servletContext.getAttribute("org.eaglei.repository.Generation");
        boolean result = sessionGen != null && sessionGen < ctxGen;
        session.setAttribute("org.eaglei.repository.Generation", (Object)ctxGen);
        return result;
    }

    public Reader getWebappResourceAsReader(String path) throws ServletException {
        if (this.servletContext == null) {
            log.error((Object)"getWebappResourceAsStream: currentContext not set!");
            return null;
        }
        try {
            return new InputStreamReader(this.servletContext.getResourceAsStream(path), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException("Unsupported encoding content-type spec: " + e);
        }
        catch (IllegalCharsetNameException e) {
            throw new ServletException("Illegal character set name in content-type spec: " + e);
        }
        catch (UnsupportedCharsetException e) {
            throw new ServletException("Unsupported character set name in content-type spec: " + e);
        }
    }

    public void updateLastModified(HttpServletRequest request, Date lm) {
        Date nextLastModified = (Date)request.getAttribute("org.eaglei.repository.lastModified");
        if (nextLastModified == null || nextLastModified.before(lm)) {
            request.setAttribute("org.eaglei.repository.lastModified", (Object)lm);
        }
    }

    public void clearLastModified(HttpServletRequest request) {
        request.setAttribute("org.eaglei.repository.lastModified", null);
    }

    public synchronized void commitLastModified(HttpServletRequest request) {
        Date nextLastModified = (Date)request.getAttribute("org.eaglei.repository.lastModified");
        if (nextLastModified != null && nextLastModified.after(this.lastModified)) {
            this.lastModified = nextLastModified;
            nextLastModified = null;
            log.debug((Object)("Committed new global lastModified == " + this.lastModified));
        }
    }

    public synchronized Date getLastModified() {
        return this.lastModified;
    }

    public static void decacheAll() {
        log.info((Object)"Decaching all content caches..");
        Reflections r = new Reflections("org.eaglei.repository", new Scanner[0]);
        for (Class c : r.getTypesAnnotatedWith(HasContentCache.class)) {
            log.debug((Object)("  Decaching " + c.getName()));
            try {
                c.getMethod("decache", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)("Class is marked as content cacher but has no static decache() method - " + c.getName() + ": " + e));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Failed calling decache() on content cacher class=" + c.getName() + ": " + e));
            }
            catch (InvocationTargetException e) {
                log.error((Object)("Failed calling decache() on content cacher class=" + c.getName() + ": " + e));
            }
        }
    }

    static {
        graphInitFile.put(REPO.NAMESPACE_URI, "repository-ont.n3");
        graphInitFile.put(REPO.NG_INTERNAL, "repository-internal.n3");
        graphInitFile.put(REPO.NG_QUERY, "query-macros.n3");
        STARTUP = new Date();
        instance = null;
    }
}

