/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.EditToken;
import org.eaglei.repository.model.ImmutableObjectModel;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public final class EditToken
extends ImmutableObjectModel {
    private static Logger log = LogManager.getLogger(EditToken.class);
    private URI resource = null;
    private URI uri = null;
    private URI creator = null;
    private String creatorLabel = null;
    private String created = null;
    private static final String etQuery = "SELECT * WHERE { \n?instance <" + REPO.HAS_EDIT_TOKEN + "> ?editToken . \n" + "OPTIONAL { ?editToken <" + DCTERMS.CREATOR + "> ?creator  \n" + " OPTIONAL { ?creator <" + RDFS.LABEL + "> ?creatorLabel } } \n" + "OPTIONAL { ?editToken <" + DCTERMS.CREATED + "> ?created } }";

    private EditToken(URI resource) {
        this.resource = resource;
    }

    public static EditToken find(HttpServletRequest request, URI resource) {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, etQuery);
            q.setBinding("instance", (Value)resource);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(false);
            EditTokenHandler eh = new EditTokenHandler(resource);
            SPARQL.evaluateTupleQuery((String)etQuery, (TupleQuery)q, (TupleQueryResultHandler)eh);
            EditToken result = eh.getResult();
            if (result != null && result.uri != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found edit token = " + result.uri + " for Resource Instance = " + resource));
                }
                return result;
            }
            return null;
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static EditToken create(HttpServletRequest request, URI resource) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (rc.hasStatement((Resource)resource, REPO.HAS_EDIT_TOKEN, null, false, new Resource[]{REPO.NG_INTERNAL})) {
                throw new ConflictException("There is already an edit token for resource instance: " + resource);
            }
            if (!Access.hasPermission((HttpServletRequest)request, (Resource)resource, (Access)Access.ADD) && !Access.hasPermission((HttpServletRequest)request, (Resource)resource, (Access)Access.REMOVE)) {
                throw new ForbiddenException("No permission to modify this resource instance: " + resource);
            }
            EditToken result = new EditToken(resource);
            result.creator = Authentication.getPrincipalURI((HttpServletRequest)request);
            Literal now = Provenance.makeDateTime((Date)new Date());
            result.created = now.getLabel();
            ValueFactory vf = rc.getValueFactory();
            result.uri = vf.createURI(Configuration.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
            rc.add((Resource)resource, REPO.HAS_EDIT_TOKEN, (Value)result.uri, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)result.uri, DCTERMS.CREATOR, (Value)result.creator, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)result.uri, DCTERMS.CREATED, (Value)now, new Resource[]{REPO.NG_INTERNAL});
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created edit token = " + result.uri + " for Resource Instance = " + resource));
            }
            return result;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed creating edit token: ", (Throwable)e);
            throw new InternalServerErrorException("Failed creating edit token: ", (Throwable)e);
        }
    }

    public void clear(HttpServletRequest request) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.resource, REPO.HAS_EDIT_TOKEN, (Value)this.uri, new Resource[]{REPO.NG_INTERNAL});
            rc.remove((Resource)this.uri, null, null, new Resource[]{REPO.NG_INTERNAL});
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed clearing edit token: ", (Throwable)e);
            throw new InternalServerErrorException("Failed clearing edit token: ", (Throwable)e);
        }
    }

    public URI getResource() {
        return this.resource;
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getCreator() {
        return this.creator;
    }

    public String getCreatorLabel() {
        return this.creatorLabel == null ? this.creator.getLocalName() : this.creatorLabel;
    }

    public String getCreated() {
        return this.created;
    }

    public String getLabel() {
        return "EditToken for " + this.resource;
    }

    public String toString() {
        return "<#EditToken: resource=" + this.resource + ", uri=" + this.uri + ", creator=" + this.creator + ", creatorLabel=" + this.creatorLabel + ", created=" + this.created + ">";
    }

    public boolean equals(Object o) {
        return o instanceof EditToken && this.uri != null && this.uri.equals(((EditToken)o).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    static /* synthetic */ URI access$100(EditToken x0) {
        return x0.uri;
    }

    static /* synthetic */ URI access$200(EditToken x0) {
        return x0.resource;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ URI access$102(EditToken x0, URI x1) {
        x0.uri = x1;
        return x0.uri;
    }

    static /* synthetic */ URI access$402(EditToken x0, URI x1) {
        x0.creator = x1;
        return x0.creator;
    }

    static /* synthetic */ String access$502(EditToken x0, String x1) {
        x0.creatorLabel = x1;
        return x0.creatorLabel;
    }

    static /* synthetic */ String access$602(EditToken x0, String x1) {
        x0.created = x1;
        return x0.created;
    }
}

