/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.DataModel;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.model.View;
import org.eaglei.repository.servlet.Disseminate;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
@HasContentCache
public class Disseminate
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Disseminate.class);
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final String REPO_XML = "http://eagle-i.org/xsd/repo/";
    private static final Namespace REPO_XML_NS = Namespace.getNamespace((String)"http://eagle-i.org/xsd/repo/");
    private static final Namespace XSI_NAMESPACE = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final String INSTANCE_SCHEMA_PATH = "repository/schemas/instance.xsd";
    private static final URI[] labelPredicate = DataModel.LABEL_PREDICATE.getArrayOfURI();
    private static final boolean hideContactsEnabled = Boolean.parseBoolean(Configuration.getInstance().getConfigurationProperty("eaglei.repository.hideContacts", Boolean.FALSE.toString()));
    private static final String[] defaultScriptURLs = new String[]{"http://ajax.googleapis.com/ajax/libs/jquery/1.4.1/jquery.min.js", "/repository/styles/i.js"};
    private static final String[] scriptURLs = Configuration.getInstance().getConfigurationPropertyArray("eaglei.repository.instance.js", defaultScriptURLs);
    private boolean authenticated;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        String a = sc.getInitParameter("authenticated");
        this.authenticated = a != null && Boolean.parseBoolean(a);
    }

    public static void decache() {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block52: {
            request.setCharacterEncoding("UTF-8");
            String format = this.getParameter(request, "format", false);
            String rawView = this.getParameter(request, "view", false);
            URI uri = this.getParameterAsURI(request, "uri", false);
            URI workspace = this.getParameterAsURI(request, "workspace", false);
            boolean noinferred = this.isParameterPresent(request, "noinferred");
            boolean forceRDF = this.isParameterPresent(request, "forceRDF");
            boolean forceXML = this.isParameterPresent(request, "forceXML");
            if (uri == null) {
                String pi = request.getPathInfo();
                if (pi == null || pi.length() == 0) {
                    throw new BadRequestException("Missing required instance URI to disseminate.");
                }
                uri = Utils.parseURI((String)(Configuration.getInstance().getDefaultNamespace() + pi.substring(1)), (String)"Resource URI", (boolean)true);
            }
            log.debug((Object)("Got requested resource uri=" + uri.stringValue()));
            if (workspace != null && rawView != null) {
                throw new BadRequestException("The 'view' and 'workspace' arguments are mutually exclusive.  Choose only one.");
            }
            try {
                int i;
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                if (labelPredicate == null) {
                    throw new ServletException("Configuration failure, no label predicates found.");
                }
                DatasetImpl ds = new DatasetImpl();
                View view = null;
                if (workspace != null) {
                    View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)workspace);
                } else {
                    View view2 = view = rawView == null ? View.USER : View.parseView((String)rawView);
                    if (view == null) {
                        throw new BadRequestException("Unknown view: " + rawView);
                    }
                    View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)view);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dataset derived from initial 'view' or 'workspace' args =\n" + Utils.prettyPrint((Dataset)ds, (int)2)));
                }
                RepositoryResult rr = null;
                boolean goodResource = false;
                boolean exists = false;
                boolean visible = false;
                boolean any = false;
                URI[] contexts = View.NULL.equals((Object)view) ? new URI[1] : ds.getDefaultGraphs().toArray(new URI[ds.getDefaultGraphs().size()]);
                URI homeGraph = null;
                try {
                    rr = rc.getStatements((Resource)uri, RDF.TYPE, null, false, (Resource[])contexts);
                    if (!rr.hasNext()) {
                        log.debug((Object)"Probing for rdf:type in ALL graphs, after failing in allowed ones");
                        exists = rc.hasStatement((Resource)uri, RDF.TYPE, null, false, new Resource[0]);
                        any = rc.hasStatement((Resource)uri, null, null, false, (Resource[])contexts);
                    }
                    while (rr.hasNext()) {
                        NamedGraphType cngt;
                        Statement s = (Statement)rr.next();
                        Resource ctx = s.getContext();
                        log.debug((Object)("Found statement: " + uri + " rdf:type " + s.getObject() + ", in graph " + ctx));
                        exists = true;
                        if (!(ctx instanceof URI) || !(View.NULL.equals((Object)view) ? Access.hasPermission((HttpServletRequest)request, (Resource)((URI)ctx), (Access)Access.READ) : ds.getDefaultGraphs().contains((URI)ctx))) continue;
                        visible = true;
                        NamedGraph cng = NamedGraph.find((HttpServletRequest)request, (URI)((URI)ctx));
                        NamedGraphType namedGraphType = cngt = cng == null ? null : cng.getType();
                        if (cngt != NamedGraphType.published && cngt != NamedGraphType.workspace) continue;
                        log.debug((Object)("...approving resource because of rdf:type statement in graph=" + ctx));
                        goodResource = true;
                        homeGraph = (URI)ctx;
                        break;
                    }
                }
                finally {
                    rr.close();
                }
                log.debug((Object)("Probe results: exists=" + exists + ", any=" + any + ", visible=" + visible + ", goodResource=" + goodResource));
                if (exists && !visible) {
                    log.info((Object)("Resource exists but is not visible to user, so returning 404.  User=" + Authentication.getPrincipalURI((HttpServletRequest)request) + ", resource=" + uri));
                    throw new NotFoundException("Subject not found in this repository: " + uri.toString());
                }
                if (!exists) {
                    if (any) {
                        throw new HttpStatusException(410, "Subject was deleted or is not a well formed eagle-i resource: " + uri.toString());
                    }
                    throw new NotFoundException("Subject not found in this repository: " + uri.toString());
                }
                if (!(goodResource && homeGraph != null || Authentication.isSuperuser((HttpServletRequest)request))) {
                    throw new NotFoundException("Subject exists but is not available as an Eagle-I resource: " + uri.toString());
                }
                String mimeType = Formats.negotiateHTMLorRDFContent((HttpServletRequest)request, (String)format);
                boolean html = !forceRDF && (mimeType.equals("text/html") || mimeType.equals("application/xhtml+xml"));
                String contentType = Utils.makeContentType((String)(html ? "application/xhtml+xml" : mimeType), (String)"UTF-8");
                log.debug((Object)("Preparing query for authenticated=" + this.authenticated + ", hideContactsEnabled=" + hideContactsEnabled));
                StringBuilder query = new StringBuilder();
                if (html) {
                    query.append("SELECT DISTINCT ?g ?p ?v");
                    for (i = 0; i < labelPredicate.length; ++i) {
                        query.append(" ?pl").append(String.valueOf(i)).append(" ?vl").append(String.valueOf(i));
                    }
                } else {
                    query.append("CONSTRUCT { ?subject ?p ?v . ");
                    for (i = 0; i < labelPredicate.length; ++i) {
                        query.append(" ?p <").append(labelPredicate[i]).append("> ?pl").append(String.valueOf(i)).append(" .").append(" ?v <").append(labelPredicate[i]).append("> ?vl").append(String.valueOf(i)).append(" .").append(" ?vo <").append(labelPredicate[i]).append("> ?vol").append(String.valueOf(i)).append(" .");
                    }
                    query.append(" ?v ?vp ?vo }\n");
                }
                query.append(" WHERE { \n");
                query.append("{ GRAPH ?g { ?subject ?p ?v } \n");
                for (i = 0; i < labelPredicate.length; ++i) {
                    query.append(" OPTIONAL { ?p <").append(labelPredicate[i]).append("> ?pl").append(String.valueOf(i)).append(" } \n").append(" OPTIONAL { ?v <").append(labelPredicate[i]).append("> ?vl").append(String.valueOf(i)).append(" } \n");
                }
                if (!html) {
                    query.append("OPTIONAL { ?v a ?vt . ?vt <").append(DataModel.EMBEDDED_INSTANCE_PREDICATE.toString()).append("> <").append(DataModel.EMBEDDED_INSTANCE_OBJECT.toString()).append("> . ");
                    if (noinferred) {
                        query.append("GRAPH ?eg ");
                    }
                    query.append("{?v ?vp ?vo}\n");
                    if (noinferred) {
                        query.append(" FILTER( ?eg != <").append(REPO.NG_INFERRED).append(">)\n");
                    }
                    if (!this.authenticated) {
                        this.addPropertyFilters(query, "vp", !this.authenticated);
                    }
                    for (i = 0; i < labelPredicate.length; ++i) {
                        query.append(" OPTIONAL { ?vo <").append(labelPredicate[i]).append("> ?vol").append(String.valueOf(i)).append(" } \n");
                    }
                    query.append("}\n");
                }
                if (!this.authenticated) {
                    this.addPropertyFilters(query, "p", !this.authenticated);
                }
                query.append(" }");
                if (noinferred) {
                    query.append(" FILTER( ?g != <").append(REPO.NG_INFERRED).append(">)\n");
                }
                query.append("}");
                if (html) {
                    query.append(" ORDER BY ?p ?v");
                }
                DatasetImpl qds = null;
                if (rawView == null && workspace == null) {
                    qds = new DatasetImpl();
                    View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)qds, (URI)homeGraph);
                } else {
                    qds = ds;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Home graph = " + homeGraph));
                }
                if (html) {
                    Element assertedTypes = new Element("asserted-types", REPO_XML_NS);
                    Element inferredTypes = new Element("inferred-types", REPO_XML_NS);
                    Element properties = new Element("properties", REPO_XML_NS);
                    Element metadata = new Element("metadata", REPO_XML_NS);
                    String qs = query.toString();
                    TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
                    q.setBinding("subject", (Value)uri);
                    if (!View.NULL.equals((Object)view)) {
                        q.setDataset((Dataset)qds);
                    }
                    PropsHandler handler = new PropsHandler(this, assertedTypes, inferredTypes, properties, metadata, null);
                    SPARQL.evaluateTupleQuery((String)qs, (TupleQuery)q, (TupleQueryResultHandler)handler);
                    Element root = new Element("instance", REPO_XML_NS);
                    root.addNamespaceDeclaration(Namespace.XML_NAMESPACE);
                    root.addNamespaceDeclaration(XSI_NAMESPACE);
                    root.setAttribute("schemaLocation", "http://eagle-i.org/xsd/repo/ " + this.makeFileURL(request, "repository/schemas/instance.xsd"), XSI_NAMESPACE);
                    root.addContent((Content)this.makeResource(uri, PropsHandler.access$100((PropsHandler)handler)));
                    root.addContent((Content)new Element("permission", REPO_XML_NS).setAttribute("write", String.valueOf(Access.hasPermission((HttpServletRequest)request, (Resource)uri, (Access)Access.ADD))).setAttribute("admin", String.valueOf(Access.hasPermission((HttpServletRequest)request, (Resource)uri, (Access)Access.ADMIN))));
                    root.addContent((Content)assertedTypes);
                    root.addContent((Content)inferredTypes);
                    root.addContent((Content)properties);
                    root.addContent((Content)metadata);
                    Document result = new Document(root);
                    if (!result.hasRootElement()) {
                        log.error((Object)"No root element in doc, this will be bad.");
                    }
                    try {
                        XMLGregorianCalendar mc = PropsHandler.access$200((PropsHandler)handler);
                        if (mc != null) {
                            log.debug((Object)("Got last-modified date = " + mc.toString()));
                            response.addDateHeader("Last-Modified", mc.toGregorianCalendar().getTime().getTime());
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)("Failed to parse dcterms:created or dcterms:modified as date; value=" + PropsHandler.access$300((PropsHandler)handler)));
                    }
                    String xslPath = Configuration.getInstance().getConfigurationProperty("eaglei.repository.instance.xslt");
                    if (xslPath != null && !forceXML) {
                        String repoTitle;
                        String logo;
                        log.debug((Object)("Transforming result with XSLT in file = " + xslPath));
                        File xslFile = new File(xslPath);
                        Reader xis = xslFile.isAbsolute() ? new FileReader(xslFile) : Lifecycle.getInstance().getWebappResourceAsReader(xslPath);
                        Transformer xf = transformerFactory.newTransformer(new StreamSource(xis));
                        xf.setParameter("__repo_version", Configuration.getInstance().getProjectVersion());
                        String css = Configuration.getInstance().getConfigurationProperty("eaglei.repository.instance.css");
                        if (css != null) {
                            xf.setParameter("__repo_css", css);
                        }
                        if ((logo = Configuration.getInstance().getConfigurationProperty("eaglei.repository.logo")) != null) {
                            xf.setParameter("__repo_logo", logo);
                        }
                        if ((repoTitle = Configuration.getInstance().getConfigurationProperty("eaglei.repository.title")) != null) {
                            xf.setParameter("__repo_title", repoTitle);
                        }
                        JDOMResult xresult = new JDOMResult();
                        xf.transform((Source)new JDOMSource(result), (Result)xresult);
                        result = xresult.getDocument();
                    } else {
                        log.debug((Object)"No XSLT stylesheet configured or forceXML, returning raw XML.");
                        contentType = "application/xml";
                    }
                    XMLOutputter out = new XMLOutputter();
                    out.setFormat(Format.getPrettyFormat());
                    response.setContentType(contentType);
                    out.output(result, (OutputStream)response.getOutputStream());
                    break block52;
                }
                RDFFormat rf = Formats.getRDFOutputFormatForMIMEType((String)mimeType);
                if (rf == null) {
                    log.error((Object)("Failed to get RDF serialization format, for mime=" + mimeType));
                    throw new ServletException("Failed to get RDF serialization format that SHOULD have been available, for mime=" + mimeType);
                }
                response.setContentType(contentType);
                Provenance p = new Provenance(uri);
                String modified = p.getField(request, DCTERMS.MODIFIED);
                if (modified != null) {
                    XMLGregorianCalendar mc = Utils.parseXMLDate((String)modified);
                    log.debug((Object)("Got last-modified date = " + mc.toString()));
                    response.addDateHeader("Last-Modified", mc.toGregorianCalendar().getTime().getTime());
                }
                String gqs = query.toString();
                GraphQuery q = rc.prepareGraphQuery(QueryLanguage.SPARQL, gqs);
                q.setBinding("subject", (Value)uri);
                q.setDataset((Dataset)qds);
                SPARQL.evaluateGraphQuery((String)gqs, (GraphQuery)q, (RDFHandler)Rio.createWriter((RDFFormat)rf, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")));
            }
            catch (TransformerException e) {
                log.error((Object)("Failed transforming instance result, uri=" + uri), (Throwable)e);
                throw new ServletException("Failed in XSL Transformation:", (Throwable)e);
            }
            catch (MalformedQueryException e) {
                log.error((Object)"Malformed query generated internally: ", (Throwable)e);
                throw new ServletException("Malformed query generated internally: " + e.toString(), (Throwable)e);
            }
            catch (UnsupportedOperationException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void addPropertyFilters(StringBuilder query, String propName, boolean hide) {
        String hideObj = propName + "_hide";
        String contactObj = propName + "_contact";
        if (hide) {
            query.append(" OPTIONAL { ?").append(propName).append(" <").append(DataModel.HIDE_PROPERTY_PREDICATE.toString()).append("> ?").append(hideObj).append("\n");
            query.append("  FILTER(?").append(hideObj).append(" = <").append(DataModel.HIDE_PROPERTY_OBJECT.toString()).append(">)}\n");
        }
        if (hideContactsEnabled) {
            query.append(" OPTIONAL { ?").append(propName).append(" <").append(DataModel.CONTACT_PROPERTY_PREDICATE.toString()).append("> ?").append(contactObj).append("\n");
            query.append("  FILTER(?").append(contactObj).append(" = <").append(DataModel.CONTACT_PROPERTY_OBJECT.toString()).append(">)}\n");
        }
        query.append("FILTER(!(BOUND(?").append(hideObj).append(")");
        if (hideContactsEnabled) {
            query.append(" || BOUND(?").append(contactObj).append(")");
        }
        query.append("))\n");
    }

    private Element makeResource(URI uri, String label) {
        return new Element("resource", REPO_XML_NS).setAttribute("uri", uri.stringValue()).addContent(label == null ? uri.getLocalName() : label);
    }

    private String makeFileURL(HttpServletRequest request, String path) throws ServletException {
        try {
            StringBuilder result = new StringBuilder();
            URL from = new URL(request.getRequestURL().toString());
            result.append(from.getProtocol()).append("://").append(from.getHost());
            if (from.getPort() >= 0) {
                result.append(":").append(String.valueOf(from.getPort()));
            }
            result.append("/").append(path);
            return result.toString();
        }
        catch (MalformedURLException e) {
            log.error((Object)"Failed reading request URL", (Throwable)e);
            throw new ServletException("Failed reading request URL", (Throwable)e);
        }
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }

    static /* synthetic */ URI[] access$500() {
        return labelPredicate;
    }

    static /* synthetic */ Element access$600(Disseminate x0, URI x1, String x2) {
        return x0.makeResource(x1, x2);
    }

    static /* synthetic */ Namespace access$700() {
        return REPO_XML_NS;
    }
}

