/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class ListGraphs
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(ListGraphs.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String format = this.getParameter(request, "format", false);
        NamedGraphType type = (NamedGraphType)this.getParameterAsKeyword(request, "type", NamedGraphType.class, null, false);
        log.debug((Object)("Got graph type filter = " + type));
        List ngs = NamedGraph.findAll((HttpServletRequest)request);
        Collections.sort(ngs);
        ArrayList<MapBindingSet> result = new ArrayList<MapBindingSet>();
        boolean superuser = Authentication.isSuperuser((HttpServletRequest)request);
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            for (NamedGraph ng : ngs) {
                String loadedVersion;
                NamedGraphType ngt = ng.getType();
                if (type != null && !type.equals((Object)ngt)) continue;
                MapBindingSet nbs = new MapBindingSet(9);
                URI uri = ng.getURI();
                nbs.addBinding("namedGraphURI", (Value)uri);
                nbs.addBinding("namedGraphLabel", (Value)new LiteralImpl(ng.getLabel()));
                if (ngt != null) {
                    nbs.addBinding("typeURI", (Value)ngt.getURI());
                    nbs.addBinding("typeLabel", (Value)new LiteralImpl(ngt.getLabel()));
                }
                nbs.addBinding("version", (Value)((loadedVersion = Utils.getVersionInfo((RepositoryConnection)rc, (URI)uri, (URI)uri)) == null ? null : new LiteralImpl(loadedVersion)));
                nbs.addBinding("size", (Value)new NumericLiteralImpl(rc.size(new Resource[]{uri})));
                if (superuser) {
                    nbs.addBinding("read", (Value)BooleanLiteralImpl.TRUE);
                    nbs.addBinding("add", (Value)BooleanLiteralImpl.TRUE);
                    nbs.addBinding("remove", (Value)BooleanLiteralImpl.TRUE);
                } else {
                    BooleanLiteralImpl hasRead = BooleanLiteralImpl.FALSE;
                    BooleanLiteralImpl hasRemove = BooleanLiteralImpl.FALSE;
                    BooleanLiteralImpl hasAdd = BooleanLiteralImpl.FALSE;
                    for (AccessGrant g : AccessGrant.getMyGrants((HttpServletRequest)request, (URI)uri)) {
                        if (g.getAccessURI().equals(REPO.HAS_READ_ACCESS)) {
                            hasRead = BooleanLiteralImpl.TRUE;
                            continue;
                        }
                        if (g.getAccessURI().equals(REPO.HAS_ADD_ACCESS)) {
                            hasAdd = BooleanLiteralImpl.TRUE;
                            continue;
                        }
                        if (!g.getAccessURI().equals(REPO.HAS_REMOVE_ACCESS)) continue;
                        hasRemove = BooleanLiteralImpl.TRUE;
                    }
                    nbs.addBinding("read", (Value)hasRead);
                    nbs.addBinding("add", (Value)hasAdd);
                    nbs.addBinding("remove", (Value)hasRemove);
                }
                result.add(nbs);
            }
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, result);
    }
}

