/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.View;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.WorkflowResources;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;

public class WorkflowResources
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WorkflowResources.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String rawState = this.getParameter(request, "state", false);
        URI type = this.getParameterAsURI(request, "type", false);
        OwnerArg owner = (OwnerArg)this.getParameterAsKeyword(request, "owner", OwnerArg.class, (Enum)OwnerArg.self, false);
        boolean unclaimed = this.getParameterAsBoolean(request, "unclaimed", true, false);
        URI workspace = this.getParameterAsURI(request, "workspace", false);
        String format = this.getParameter(request, "format", false);
        DetailArg detail = (DetailArg)this.getParameterAsKeyword(request, "detail", DetailArg.class, (Enum)DetailArg.full, false);
        String addPattern = this.getParameter(request, "addPattern", false);
        String addResults = this.getParameter(request, "addResults", false);
        String addModifiers = this.getParameter(request, "addModifiers", false);
        URI state = null;
        state = rawState == null || rawState.equals("all") ? null : Utils.parseURI((String)rawState, (String)"state", (boolean)false);
        StringBuilder qb = new StringBuilder();
        qb.append("SELECT ?r_subject ?r_label ?r_type ");
        if (detail == DetailArg.full) {
            qb.append("?r_created ?r_owner ?r_ownerLabel ?r_state ");
        }
        if (addResults != null) {
            qb.append(addResults);
        }
        qb.append(" WHERE {\n");
        qb.append("  ?r_subject <").append(REPO.HAS_WORKFLOW_STATE).append("> ?r_state .\n");
        if (state != null) {
            qb.append("  FILTER (?r_state = <").append(state).append(">)\n");
        }
        qb.append(" GRAPH ?atg {?r_subject a ?r_type }\n").append(" FILTER (?atg != <").append(REPO.NG_INFERRED).append(">)\n");
        if (type != null) {
            qb.append(" ?r_subject a <").append(type).append("> .\n");
        }
        qb.append("  OPTIONAL{ ?r_subject <").append(RDFS.LABEL).append("> ?r_label}\n");
        qb.append("  OPTIONAL{ ?r_subject <").append(DCTERMS.CREATED).append("> ?r_created }\n");
        qb.append("  OPTIONAL{ ?r_subject <").append(REPO.HAS_WORKFLOW_OWNER).append("> ?r_owner .\n");
        qb.append("    OPTIONAL{ ?r_owner <").append(RDFS.LABEL).append("> ?r_ownerLabel }} \n");
        if (unclaimed && owner != OwnerArg.all) {
            qb.append("  FILTER (!BOUND(?r_owner)");
            if (owner == OwnerArg.self) {
                qb.append(" || ?r_owner = <").append(Authentication.getPrincipalURI((HttpServletRequest)request)).append(">\n");
            }
            qb.append(")\n");
        } else if (!unclaimed) {
            qb.append("  FILTER (");
            if (owner == OwnerArg.self) {
                qb.append("?r_owner = <").append(Authentication.getPrincipalURI((HttpServletRequest)request)).append(">\n");
            } else if (owner == OwnerArg.all) {
                qb.append("BOUND(?r_owner)");
            } else {
                throw new BadRequestException("Illegal combination of options: specifying unclaimed=false and owner=none would never produce any results.");
            }
            qb.append(")\n");
        }
        if (addPattern != null) {
            qb.append(addPattern);
        }
        qb.append("}");
        if (addModifiers != null) {
            qb.append(" ").append(addModifiers);
        }
        String query = qb.toString();
        DatasetImpl ds = new DatasetImpl();
        if (workspace != null) {
            View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)ds, (URI)workspace);
        } else {
            View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)View.USER);
        }
        SPARQL.tupleQueryRequest((HttpServletRequest)request, (HttpServletResponse)response, (String)query, (String)format, (Dataset)ds);
    }
}

