/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet.admin;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.Role;
import org.eaglei.repository.model.User;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.admin.UpdateUser;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class UpdateUser
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(UpdateUser.class);
    private static final String[] PASS_THRU_ARGS = new String[]{"only_password", "standalone", "username"};

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        User user;
        request.setCharacterEncoding("UTF-8");
        String username = this.getParameter(request, "username", true);
        Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
        boolean onlyPassword = this.isParameterPresent(request, "only_password");
        String password = this.getParameter(request, "password", false);
        String passwordConfirm = this.getParameter(request, "password_confirm", false);
        String oldPassword = this.getParameter(request, "old_password", false);
        String first = this.getExactParameter(request, "first", false);
        String last = this.getExactParameter(request, "last", false);
        String mailbox = this.getExactParameter(request, "mailbox", false);
        String[] roleURI = this.getParameters(request, "role", false);
        User user2 = user = username == null ? null : User.findByUsername((HttpServletRequest)request, (String)username);
        if (action == Action.create) {
            if (user != null) {
                throw new BadRequestException("Cannot create the user '" + username + "', it already exists.");
            }
            if (username == null) {
                throw new BadRequestException("Username is required to create a new user.");
            }
        } else if (user == null) {
            throw new BadRequestException("Cannot update user '" + username + "', not found.");
        }
        if ((action == Action.create || action == Action.reinstate) && password == null) {
            throw new BadRequestException("You must enter a Password when creating or reinstating a user.");
        }
        if (!(password == null && passwordConfirm == null || password != null && passwordConfirm != null && password.equals(passwordConfirm))) {
            throw new BadRequestException("Password values do not match.");
        }
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            if (action == Action.update) {
                if (!Access.hasPermissionOnUser((HttpServletRequest)request, (String)username)) {
                    throw new ForbiddenException("Not allowed to modify user: " + username);
                }
            } else {
                throw new ForbiddenException("Only an Administrator may create, disable, or reinstate a user.");
            }
        }
        if (action == Action.create) {
            user = User.create((HttpServletRequest)request, (String)username, (String)password);
            this.mungUser(request, user, first, last, mailbox);
            this.mungRoles(request, user, roleURI);
            user.commit(request);
        } else if (action == Action.reinstate) {
            user.reinstate(password);
            user.commit(request);
        } else if (action == Action.update) {
            if (password != null) {
                if (!(Authentication.isSuperuser((HttpServletRequest)request) || oldPassword != null && user.authenticate(oldPassword))) {
                    throw new ForbiddenException("Old password does not match, you are not allowed to update your password without it.");
                }
                user.setPassword(request, password);
            }
            if (!onlyPassword) {
                this.mungUser(request, user, first, last, mailbox);
                if (Authentication.isSuperuser((HttpServletRequest)request)) {
                    this.mungRoles(request, user, roleURI);
                }
            }
            user.commit(request);
        } else if (action == Action.disable) {
            user.disable();
            user.commit(request);
        }
        this.redirectToJSP(request, response, action.toString() + "d user " + username, PASS_THRU_ARGS, new String[0]);
    }

    private boolean mungRoles(HttpServletRequest request, User user, String[] roleURI) throws ServletException {
        Role[] role = new Role[roleURI == null ? 0 : roleURI.length];
        if (roleURI != null) {
            for (int i = 0; i < roleURI.length; ++i) {
                role[i] = Role.find((HttpServletRequest)request, (URI)new URIImpl(roleURI[i]));
            }
        }
        return user.setRoles(request, role);
    }

    private boolean mungUser(HttpServletRequest request, User user, String first, String last, String mailbox) throws ServletException {
        log.debug((Object)("Updating user, change to: first='" + first + "', last='" + last + "'"));
        boolean changed = false;
        if (UpdateUser.wouldChange((String)first, (String)user.getFirstName())) {
            user.setFirstName(request, first);
            log.debug((Object)("Changed first name = " + first));
            changed = true;
        }
        if (UpdateUser.wouldChange((String)last, (String)user.getLastName())) {
            user.setLastName(request, last);
            log.debug((Object)("Changed last name = " + last));
            changed = true;
        }
        if (UpdateUser.wouldChange((String)mailbox, (String)user.getMbox())) {
            user.setMbox(request, mailbox);
            log.debug((Object)("Changed mbox = " + mailbox));
            changed = true;
        }
        return changed;
    }

    private static boolean wouldChange(String arg, String existing) {
        return arg != null && existing != null && !existing.equals(arg) || existing == null && arg.length() > 0;
    }
}

