<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@ page import="java.io.Writer" %>
<%@ page import="java.io.StringWriter" %>
<%@ page import="java.io.PrintWriter" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.HashMap" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%!
    private static final String NO_STATUS = "(status not set)";
    private static final Logger log = LogManager.getLogger("org.eaglei.repository.admin.error.jsp");
    private static final Map<String,String> genericMessage =  new HashMap<String,String>();
    static {
        genericMessage.put("NO_STATUS", "No status code found in response");
        genericMessage.put("400", "Bad Request");
        genericMessage.put("401", "Unauthorized");
        genericMessage.put("402", "Payment Required");
        genericMessage.put("403", "Forbidden");
        genericMessage.put("404", "Not Found");
        genericMessage.put("405", "Method Not Allowed");
        genericMessage.put("406", "Not Acceptable");
        genericMessage.put("407", "Proxy Authentication Required");
        genericMessage.put("408", "Request Timeout");
        genericMessage.put("409", "Conflict");
        genericMessage.put("410", "Gone");
        genericMessage.put("411", "Length Required");
        genericMessage.put("412", "Precondition Failed");
        genericMessage.put("413", "Request Entity Too Large");
        genericMessage.put("414", "Request-url Too Long");
        genericMessage.put("415", "Unsupported Media Type");
        genericMessage.put("417", "Expectation Failed");
        genericMessage.put("500", "Internal Server Error");
        genericMessage.put("501", "Not Implemented");
        genericMessage.put("502", "Bad Gateway");
        genericMessage.put("503", "Service Unavailable");
        genericMessage.put("504", "Gateway Timeout");
        genericMessage.put("505", "HTTP Version Not Supported");
    }
%>
<%
    log.debug("Entering error.jsp");
    try {
        Object rawStatus_code = request.getAttribute("javax.servlet.error.status_code");
        String status_code =  rawStatus_code == null ? NO_STATUS : rawStatus_code.toString();
        String uri = (String)request.getAttribute("javax.servlet.error.request_uri");
        String rawMessage = (String)request.getAttribute("javax.servlet.error.message");
        Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (exception == null) {
            exception = (Throwable)request.getAttribute("org.eaglei.repository.error.exception");
        }
        String description = (String)genericMessage.get(status_code);
        if (description == null) {
            description = "(No generic status description found)";
        }
        String message = null;
        if (rawMessage == null) {
            rawMessage = message = description;
        } else {
            message = StringEscapeUtils.escapeHtml(rawMessage);
        }
        log.debug("status_code="+status_code+", uri="+uri+", msg="+rawMessage);
        // for internal failures, leave a record in server log too.
        if (status_code.equals("500")) {
            log.error("Request status is Internal Server Error, stack trace follows:", exception);
        }
%>
  <head>
    <title>Data Repository - Error <%= status_code %></title>
    <style>
<!--
H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;}
H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;}
H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;}
BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;}
B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;}
P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}
A {color : black;}
A.name {color : black;}
HR {color : #525D76;}
.show { display: block; }
.hide { display: none; }
      -->
    </style>
  </head>
  <body>
    <h1>Repository HTTP Status <%= status_code %> - <%= message %></h1>
    <HR size="1" noshade="noshade"/>
    <p><b>type</b> Status report</p>
    <p>
      <b>Message</b>
      <u><%= message %></u>
    </p>
    <p>
      <b>Description</b>
      <u><%= description %></u>
    </p>
    <p>
      <b>More Details</b>
      <button type="button"
              onClick=" var stackTrace = document.getElementById('stackTrace');
                        if (stackTrace.className == 'hide') {
                            stackTrace.className = 'show';
                            textContent = 'Hide Stack Trace';
                        } else {
                            stackTrace.className = 'hide';
                            textContent = 'Show Stack Trace';
                        } ">Show Stack Trace</button>
      </p>
    <div id="stackTrace" class="hide">
     <h3>Stack Trace</h3>
     <pre>
      <%
        String stackTrace = "(not available)";
        if (exception != null) {
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            stackTrace = sw.toString();
        }
      %>
      <%= StringEscapeUtils.escapeHtml(stackTrace) %>
     </pre>
    <HR size="1" noshade="noshade"/>
  </body>
<%
    } catch (Throwable e) {
        log.error("Got exception during error.jsp processing, OH NOES:",e);
        System.err.println("Got exception during error.jsp processing, OH NOES: "+e);
    }
%>
</html>
