/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.model.WritableObjectModel;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
@HasContentCache
public final class NamedGraph
extends WritableObjectModel
implements Comparable<NamedGraph> {
    private static Logger log = LogManager.getLogger(NamedGraph.class);
    private static volatile Map<URI, NamedGraph> uriToNG = null;
    private static final String ngQuery = "SELECT DISTINCT * WHERE { ?namedGraphURI a <" + REPO.NAMED_GRAPH + "> . \n" + " OPTIONAL { ?namedGraphURI <" + RDFS.LABEL + "> ?namedGraphLabel } \n" + " OPTIONAL { ?namedGraphURI <" + REPO.NG_TYPE + "> ?typeURI } \n" + " OPTIONAL { ?namedGraphURI <" + REPO.HAS_READ_ACCESS + "> ?anon \n" + "            FILTER( ?anon = <" + REPO.ROLE_ANONYMOUS + "> )}}";
    private URI name;
    private String label;
    private NamedGraphType type;
    private boolean anonAccess;
    private boolean hasMetadata = false;

    private NamedGraph(URI name, String label, URI type, boolean anonAccess) {
        this.name = name;
        this.label = label;
        this.type = NamedGraphType.parse((URI)type);
        this.anonAccess = anonAccess;
        this.hasMetadata = true;
    }

    private NamedGraph(URI name) {
        this.name = name;
        this.hasMetadata = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decache() {
        Class<NamedGraph> clazz = NamedGraph.class;
        synchronized (NamedGraph.class) {
            uriToNG = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            log.debug((Object)"Cleared global NamedGraph cache map.");
            return;
        }
    }

    public void decacheInstance() {
        NamedGraph.decache();
    }

    public void update(HttpServletRequest request) throws ServletException {
        if (this.isDirty()) {
            NamedGraph.decache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<URI, NamedGraph> getMap(HttpServletRequest request) throws ServletException {
        Class<NamedGraph> clazz = NamedGraph.class;
        synchronized (NamedGraph.class) {
            if (uriToNG != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return uriToNG;
            }
            uriToNG = new HashMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                log.debug((Object)"Filling the global NamedGraph cache..");
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, ngQuery);
                q.setDataset((Dataset)SPARQL.InternalGraphs);
                q.setIncludeInferred(true);
                SPARQL.evaluateTupleQuery((String)ngQuery, (TupleQuery)q, (TupleQueryResultHandler)new NamedGraphHandler(uriToNG, null));
                RepositoryResult rr = null;
                try {
                    rr = rc.getContextIDs();
                    while (rr.hasNext()) {
                        Resource ctx = (Resource)rr.next();
                        if (!(ctx instanceof URI) || uriToNG.containsKey((URI)ctx)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found 'undocumented' named graph (context), name=" + ctx));
                        }
                        uriToNG.put((URI)ctx, new NamedGraph((URI)ctx));
                    }
                }
                finally {
                    rr.close();
                }
            }
            catch (MalformedQueryException e) {
                log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
                throw new ServletException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            return uriToNG;
        }
    }

    public static List<NamedGraph> findAll(HttpServletRequest request) throws ServletException {
        return new ArrayList<NamedGraph>(NamedGraph.getMap((HttpServletRequest)request).values());
    }

    public static NamedGraph find(HttpServletRequest request, URI name) throws ServletException {
        return NamedGraph.findOrCreate((HttpServletRequest)request, (URI)name, (boolean)false);
    }

    public static NamedGraph findOrCreate(HttpServletRequest request, URI name, boolean createp) throws ServletException {
        Map ngs = NamedGraph.getMap((HttpServletRequest)request);
        NamedGraph result = (NamedGraph)ngs.get(name);
        if (result == null) {
            if (createp) {
                result = new NamedGraph(name);
            } else {
                log.warn((Object)("Failed to find named graph or context for name=" + name));
            }
        }
        return result;
    }

    public URI getURI() {
        return this.name;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.name.getLocalName();
    }

    public NamedGraphType getType() {
        return this.type;
    }

    public URI getTypeURI() {
        return this.type == null ? null : this.type.getURI();
    }

    public String getTypeLabel() {
        return this.type == null ? null : this.type.getLabel();
    }

    public boolean isAnonymousReadable() {
        return this.anonAccess;
    }

    public long getSize(HttpServletRequest request) throws ServletException {
        try {
            return WithRepositoryConnection.get((ServletRequest)request).size(new Resource[]{this.name});
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public boolean isManaged() {
        return this.hasMetadata;
    }

    public void setLabel(HttpServletRequest request, String nl) throws ServletException {
        this.setMetadataInternal(request, RDFS.LABEL, (Value)new LiteralImpl(nl, XMLSchema.STRING));
        this.label = nl;
    }

    public void setType(HttpServletRequest request, URI nt) throws ServletException {
        NamedGraphType ntt = NamedGraphType.parse((URI)nt);
        if (ntt != null) {
            this.setType(request, ntt);
        }
    }

    public void setType(HttpServletRequest request, NamedGraphType nt) throws ServletException {
        this.setMetadataInternal(request, REPO.NG_TYPE, (Value)nt.getURI());
        this.type = nt;
    }

    private void setMetadataInternal(HttpServletRequest request, URI property, Value newVal) throws ServletException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            boolean hasType = rc.hasStatement((Resource)this.name, RDF.TYPE, (Value)REPO.NAMED_GRAPH, false, new Resource[]{REPO.NG_INTERNAL});
            if (hasType && rc.hasStatement((Resource)this.name, property, newVal, false, new Resource[]{REPO.NG_INTERNAL})) {
                log.debug((Object)("Nothing to set, graph=" + this.name + " already has " + property + " = " + newVal));
            } else {
                if (!hasType) {
                    rc.add((Resource)this.name, RDF.TYPE, (Value)REPO.NAMED_GRAPH, new Resource[]{REPO.NG_INTERNAL});
                    this.hasMetadata = true;
                }
                rc.remove((Resource)this.name, property, null, new Resource[]{REPO.NG_INTERNAL});
                rc.add((Resource)this.name, property, newVal, new Resource[]{REPO.NG_INTERNAL});
                this.setDirty(true);
                log.debug((Object)("Setting graph=" + this.name + ",  " + property + " = " + newVal));
            }
        }
        catch (OpenRDFException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public boolean equals(Object b) {
        return b instanceof NamedGraph && ((NamedGraph)b).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(NamedGraph o) {
        return this.name.toString().compareTo(o.name.toString());
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

