/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model.workflow;

import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.model.View;
import org.eaglei.repository.model.workflow.WorkflowAction;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public final class Workflow {
    private static Logger log = LogManager.getLogger(Workflow.class);
    private URI uri;
    private URI homeGraph = null;
    private URI state = null;
    private URI owner = null;
    private static final String wfQuery = "SELECT ?owner ?state ?home WHERE {\n GRAPH ?home { ?resource a ?type }\n ?resource <" + REPO.HAS_WORKFLOW_STATE + "> ?state\n" + " OPTIONAL{ ?resource <" + REPO.HAS_WORKFLOW_OWNER + "> ?owner }}";

    private Workflow(URI u) {
        this.uri = u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workflow find(HttpServletRequest request, URI resource) {
        Workflow result;
        block13: {
            result = new Workflow(resource);
            try {
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, wfQuery);
                DatasetImpl queryDS = new DatasetImpl();
                View.addGraphs((HttpServletRequest)request, (DatasetImpl)queryDS, (View)View.USER_RESOURCES);
                q.setDataset((Dataset)queryDS);
                q.setIncludeInferred(false);
                q.setBinding("resource", (Value)resource);
                TupleQueryResult qr = null;
                try {
                    qr = SPARQL.evaluateTupleQuery((String)wfQuery, (TupleQuery)q);
                    if (qr.hasNext()) {
                        BindingSet bs = (BindingSet)qr.next();
                        Value vowner = bs.getValue("owner");
                        if (vowner == null) {
                            log.debug((Object)("OK, Resource has no owner: " + resource.stringValue()));
                        } else if (vowner instanceof URI) {
                            result.owner = (URI)vowner;
                        } else {
                            throw new InternalServerErrorException("There is an error in the :hasWorkflowOwner data for resource=" + resource.stringValue());
                        }
                        Value vstate = bs.getValue("state");
                        if (vstate == null) {
                            throw new InternalServerErrorException("This resource has no Workflow State: " + resource.stringValue());
                        }
                        result.state = (URI)vstate;
                        result.homeGraph = (URI)bs.getValue("home");
                        break block13;
                    }
                    throw new NotFoundException("There is no resource for this URI, or it is not visible to you: " + resource.stringValue());
                }
                finally {
                    if (qr != null) {
                        qr.close();
                    }
                }
            }
            catch (RepositoryException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
            catch (OpenRDFException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        return result;
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getHomeGraph() {
        return this.homeGraph;
    }

    public URI getState() {
        return this.state;
    }

    public URI getOwner() {
        return this.owner;
    }

    public static Workflow create(HttpServletRequest request, URI resource, URI workspace) throws ServletException {
        log.debug((Object)("Creating new resource=" + resource.stringValue()));
        URI myself = Authentication.getPrincipalURI((HttpServletRequest)request);
        List ts = WorkflowTransition.findAccessibleByAttributes((HttpServletRequest)request, null, (URI)REPO.WFS_NEW, (URI)workspace, (URI)myself);
        if (ts.isEmpty()) {
            throw new ForbiddenException("Permission denied, you must have access to a transition from the New workflow state to create a new resource instance.");
        }
        if (ts.size() > 1) {
            log.warn((Object)("create() found multiple transitions from NEW state, choosing one arbitrarily. User=" + myself + ", workspace=" + workspace));
        }
        WorkflowTransition t = (WorkflowTransition)ts.iterator().next();
        Workflow result = new Workflow(resource);
        result.homeGraph = workspace;
        result.state = t.getFinal();
        result.setWorkflowState(request, t.getFinal());
        result.assertClaimInternal(request, myself);
        result.owner = myself;
        return result;
    }

    public void assertClaim(HttpServletRequest request, URI claimer) throws ServletException {
        log.debug((Object)("Asserting a claim on resource=" + this.uri.stringValue() + ", by user=" + claimer.stringValue()));
        if (this.owner != null) {
            throw new ConflictException("Resource is already claimed by " + (claimer.equals(this.owner) ? "the proposed owner." : " a different user."));
        }
        if (WorkflowTransition.findAccessibleByAttributes((HttpServletRequest)request, null, (URI)this.state, (URI)this.homeGraph, (URI)claimer).isEmpty()) {
            throw new ForbiddenException("Permission denied, you do not have access to any of the transitions from the resource instance's current workflow state.");
        }
        this.assertClaimInternal(request, claimer);
    }

    private void assertClaimInternal(HttpServletRequest request, URI claimer) throws ServletException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ASSERTING CLAIM, owner=" + claimer.stringValue() + ", resource=" + this.uri.stringValue()));
            }
            rc.add((Resource)this.uri, REPO.HAS_WORKFLOW_OWNER, (Value)claimer, new Resource[]{REPO.NG_METADATA});
            AccessGrant.addGrantAsAdministrator((HttpServletRequest)request, (URI)this.uri, (URI)claimer, (URI)Access.ADD.getURI());
            AccessGrant.addGrantAsAdministrator((HttpServletRequest)request, (URI)this.uri, (URI)claimer, (URI)Access.REMOVE.getURI());
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void releaseClaim(HttpServletRequest request) throws ServletException {
        if (this.owner == null) {
            throw new ConflictException("Resource is not claimed.");
        }
        if (!this.owner.equals(Authentication.getPrincipalURI((HttpServletRequest)request)) && !Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Permission denied, only the owner of a claim or the Administrator may release it.");
        }
        this.releaseClaimInternal(request);
    }

    private void releaseClaimInternal(HttpServletRequest request) throws ServletException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RELEASING CLAIM, resource=" + this.uri.stringValue()));
            }
            rc.remove((Resource)this.uri, REPO.HAS_WORKFLOW_OWNER, null, new Resource[]{REPO.NG_METADATA});
            if (!AccessGrant.removeGrantAsAdministrator((HttpServletRequest)request, (URI)this.uri, (URI)this.owner, (URI)Access.ADD.getURI())) {
                log.warn((Object)("Releasing workflow claim but WF Owner did NOT have ADD access to instance! resource=" + this.uri.stringValue()));
            }
            if (!AccessGrant.removeGrantAsAdministrator((HttpServletRequest)request, (URI)this.uri, (URI)this.owner, (URI)Access.REMOVE.getURI())) {
                log.warn((Object)("Releasing workflow claim but WF Owner did NOT have REMOVE access to instance! resource=" + this.uri.stringValue()));
            }
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void invokeTransition(HttpServletRequest request, URI transitionURI) throws ServletException {
        WorkflowTransition t = WorkflowTransition.find((HttpServletRequest)request, (URI)transitionURI);
        if (this.owner == null) {
            throw new ConflictException("Resource must be claimed to invoke a transition.");
        }
        URI myself = Authentication.getPrincipalURI((HttpServletRequest)request);
        if (!myself.equals(this.owner) && !Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("You must own the claim on the instance or be Administrator to invoke a transition.");
        }
        if (!Access.hasPermission((HttpServletRequest)request, (Resource)transitionURI, (Access)Access.READ)) {
            throw new ForbiddenException("You are not allowed to invoke this transition:" + transitionURI);
        }
        if (!t.getInitial().equals(this.state)) {
            throw new ConflictException("Resource's workflow state differs from expected initial state of this transition.");
        }
        this.releaseClaimInternal(request);
        this.setWorkflowState(request, t.getFinal());
        WorkflowAction action = t.getAction();
        if (action != null) {
            try {
                action.onTransition(request, this.uri, t.getActionParameter());
            }
            catch (Exception e) {
                log.error((Object)"Failed in workflow action: ", (Throwable)e);
                throw new ServletException("Failed in workflow action: ", (Throwable)e);
            }
        }
        new Provenance(this.uri).setModified(request, new Date());
    }

    private void setWorkflowState(HttpServletRequest request, URI newState) throws ServletException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.uri, REPO.HAS_WORKFLOW_STATE, null, new Resource[]{REPO.NG_METADATA});
            rc.add((Resource)this.uri, REPO.HAS_WORKFLOW_STATE, (Value)newState, new Resource[]{REPO.NG_METADATA});
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static boolean isWorkflowPredicate(URI uri) {
        return REPO.HAS_WORKFLOW_STATE.equals(uri) || REPO.HAS_WORKFLOW_OWNER.equals(uri);
    }
}

