/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;

public class RepositoryServlet
extends HttpServlet {
    private static Logger log = LogManager.getLogger(RepositoryServlet.class);
    private static final String R_FILE_PARAMETERS = "org.eaglei.repository.Request.File.Parameters";
    private static final String CS = "UTF-8";
    private static final int ARG_DISKFILE_THRESHOLD = 100000;

    protected String getExactParameter(HttpServletRequest request, String name, boolean required) {
        String result = null;
        List fileParameters = this.getFileParameters(request);
        if (fileParameters != null) {
            FileItem fi;
            Iterator i$ = fileParameters.iterator();
            while (i$.hasNext() && (!(fi = (FileItem)i$.next()).getFieldName().equals(name) || (result = fi.getString()) == null)) {
            }
        } else {
            result = request.getParameter(name);
        }
        if (required && result == null) {
            throw new BadRequestException("Missing required argument for: " + name);
        }
        return result;
    }

    protected String getParameter(HttpServletRequest request, String name, boolean required) {
        String result = this.getExactParameter(request, name, required);
        if (result != null && result.trim().length() == 0) {
            result = null;
        }
        return result;
    }

    protected String[] getParameters(HttpServletRequest request, String name, boolean required) {
        List fileParameters = this.getFileParameters(request);
        if (fileParameters != null) {
            ArrayList<String> lresult = new ArrayList<String>();
            for (FileItem fi : fileParameters) {
                String s;
                if (!fi.getFieldName().equals(name) || (s = fi.getString()).length() <= 0) continue;
                lresult.add(s);
            }
            if (lresult.isEmpty()) {
                if (required) {
                    throw new BadRequestException("Missing required argument(s) for: " + name);
                }
                return null;
            }
            return lresult.toArray(new String[lresult.size()]);
        }
        String[] result = request.getParameterValues(name);
        if (result != null && result.length == 1 && result[0].length() == 0) {
            result = null;
        }
        if (required && result == null) {
            throw new BadRequestException("Missing required argument(s) for: " + name);
        }
        return result;
    }

    protected boolean isParameterPresent(HttpServletRequest request, String name) {
        List fileParameters = this.getFileParameters(request);
        if (fileParameters != null) {
            for (FileItem fi : fileParameters) {
                if (!fi.getFieldName().equals(name)) continue;
                return true;
            }
        } else {
            return request.getParameter(name) != null;
        }
        return false;
    }

    protected boolean getParameterAsBoolean(HttpServletRequest request, String name, boolean defaultValue, boolean required) {
        return Utils.parseBooleanParameter((String)this.getParameter(request, name, required), (String)name, (boolean)required, (boolean)defaultValue);
    }

    protected URI getParameterAsURI(HttpServletRequest request, String name, boolean required) {
        return Utils.parseURI((String)this.getParameter(request, name, required), (String)name, (boolean)required);
    }

    protected String getParameterContentType(HttpServletRequest request, String name) {
        List fileParameters = this.getFileParameters(request);
        if (fileParameters != null) {
            for (FileItem fi : fileParameters) {
                if (!fi.getFieldName().equals(name)) continue;
                return fi.getContentType();
            }
        }
        return null;
    }

    protected Reader getParameterAsReader(HttpServletRequest request, String name, boolean required) {
        Reader result = null;
        List fileParameters = this.getFileParameters(request);
        if (fileParameters != null) {
            for (FileItem fi : fileParameters) {
                if (!fi.getFieldName().equals(name)) continue;
                try {
                    String csn = Utils.contentTypeGetCharset((String)fi.getContentType(), (String)CS);
                    log.debug((Object)("For param=" + name + ", reading serialized RDF from stream with charset=" + csn));
                    result = new InputStreamReader(fi.getInputStream(), Charset.forName(csn));
                    break;
                }
                catch (IOException e) {
                    throw new BadRequestException("Failed reading argument=" + name + ", I/O Exception: " + e);
                }
                catch (IllegalCharsetNameException e) {
                    throw new BadRequestException("Failed reading argument=" + name + ", Illegal character set name in content-type spec: " + e);
                }
                catch (UnsupportedCharsetException e) {
                    throw new BadRequestException("Failed reading argument=" + name + ", Unsupported character set name in content-type spec: " + e);
                }
            }
        } else {
            String pv = request.getParameter(name);
            if (pv != null) {
                result = new StringReader(pv);
            }
        }
        if (required && result == null) {
            throw new BadRequestException("Missing required argument for: " + name);
        }
        return result;
    }

    protected Enum getParameterAsKeyword(HttpServletRequest request, String name, Class argType, Enum defaultValue, boolean required) {
        return Utils.parseKeywordArg((Class)argType, (String)this.getParameter(request, name, required), (String)name, (boolean)required, (Enum)defaultValue);
    }

    private List<FileItem> getFileParameters(HttpServletRequest request) {
        List fileParameters = (ArrayList)request.getAttribute(R_FILE_PARAMETERS);
        if (fileParameters == null) {
            try {
                request.setCharacterEncoding(CS);
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    ServletFileUpload upload = new ServletFileUpload();
                    upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                    fileParameters = upload.parseRequest(request);
                } else {
                    fileParameters = new ArrayList();
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
                throw new BadRequestException("Unacceptable encoded character in argument data", (Throwable)e);
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                throw new BadRequestException("failed parsing multipart request", (Throwable)e);
            }
            request.setAttribute(R_FILE_PARAMETERS, fileParameters);
        }
        return fileParameters.isEmpty() ? null : fileParameters;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long startMs;
        boolean finished;
        String reqURI;
        block21: {
            block19: {
                reqURI = req.getRequestURI();
                finished = false;
                startMs = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("============== Starting Request " + reqURI));
                }
                super.service(req, resp);
                finished = true;
                if (!finished) break block19;
                Lifecycle.getInstance().commitLastModified(req);
                break block21;
            }
            Lifecycle.getInstance().clearLastModified(req);
            try {
                WithRepositoryConnection.get((ServletRequest)req).rollback();
            }
            catch (RepositoryException re) {
                log.warn((Object)("Failed in rollback after error: " + (Object)((Object)re)));
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)String.format("============== Ending Request %s (%,d mSec elapsed)", reqURI, System.currentTimeMillis() - startMs));
        return;
        catch (ErrorSendingException e) {
            block22: {
                block20: {
                    req.setAttribute("org.eaglei.repository.error.exception", (Object)e);
                    if (resp.isCommitted()) {
                        log.fatal((Object)"Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
                    }
                    try {
                        resp.sendError(e.getStatus(), e.getMessage());
                    }
                    catch (IllegalStateException ie) {
                        log.error((Object)("Cannot convert Status Exception to appropriate status because response is in wrong state.  Original exception=" + e.toString()), (Throwable)ie);
                    }
                    if (!finished) break block20;
                    {
                        catch (Throwable throwable) {
                            if (finished) {
                                Lifecycle.getInstance().commitLastModified(req);
                            } else {
                                Lifecycle.getInstance().clearLastModified(req);
                                try {
                                    WithRepositoryConnection.get((ServletRequest)req).rollback();
                                }
                                catch (RepositoryException re) {
                                    log.warn((Object)("Failed in rollback after error: " + (Object)((Object)re)));
                                }
                            }
                            if (!log.isDebugEnabled()) throw throwable;
                            log.debug((Object)String.format("============== Ending Request %s (%,d mSec elapsed)", reqURI, System.currentTimeMillis() - startMs));
                            throw throwable;
                        }
                    }
                    Lifecycle.getInstance().commitLastModified(req);
                    break block22;
                }
                Lifecycle.getInstance().clearLastModified(req);
                try {
                    WithRepositoryConnection.get((ServletRequest)req).rollback();
                }
                catch (RepositoryException re) {
                    log.warn((Object)("Failed in rollback after error: " + (Object)((Object)re)));
                }
            }
            if (!log.isDebugEnabled()) return;
            log.debug((Object)String.format("============== Ending Request %s (%,d mSec elapsed)", reqURI, System.currentTimeMillis() - startMs));
            return;
            catch (ServletException e2) {
                if (!resp.isCommitted()) throw e2;
                log.fatal((Object)"Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
                throw e2;
                catch (RuntimeException e3) {
                    if (!resp.isCommitted()) throw e3;
                    log.fatal((Object)"Exception thrown after response was committed so the status MAY FALSELY INDICATE SUCCESS.");
                    throw e3;
                }
            }
        }
    }

    protected void redirectToJSP(HttpServletRequest request, HttpServletResponse response, String message, String[] passThru, String ... more) throws ServletException, IOException {
        String referrer = request.getHeader("Referer");
        if (referrer != null && referrer.indexOf(".jsp") >= 0) {
            log.debug((Object)("Got referrer = " + referrer));
            URL from = new URL(referrer);
            StringBuilder redir = new StringBuilder();
            redir.append(from.getProtocol()).append("://").append(from.getHost());
            if (from.getPort() >= 0) {
                redir.append(":").append(String.valueOf(from.getPort()));
            }
            redir.append(from.getPath());
            redir.append("?message=").append(URLEncoder.encode(message, CS));
            for (String p : passThru) {
                String pv = this.getExactParameter(request, p, false);
                if (pv == null) continue;
                redir.append("&").append(p).append("=").append(URLEncoder.encode(pv, CS));
            }
            for (int i = 0; i < more.length; i += 2) {
                redir.append("&").append(more[i]).append("=").append(URLEncoder.encode(more[i + 1], CS));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Redirecting to = " + redir.toString()));
            }
            response.sendRedirect(response.encodeRedirectURL(redir.toString()));
        }
    }
}

