package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.model.Role;
import org.eaglei.repository.model.User;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.NotFoundException;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.Configuration;
import org.apache.commons.lang.StringEscapeUtils;

public final class editUserPortlet_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    // return null if param is empty string
    private String getNonEmptyParameter(HttpServletRequest request, String name)
    {
        String result = request.getParameter(name);
        if (result != null && result.length() == 0)
            return null;
        return result;
    }
    private String acceptCharset = "UTF-8";

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(2);
    _jspx_dependants.add("/repository/admin/../head.jsp");
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n");
      out.write('\n');

    // feedback message about status of last operation
    request.setCharacterEncoding(acceptCharset);
    String message = request.getParameter("message");
    boolean messageSuccess = true;

    boolean standalone = request.getParameter("standalone") != null;
    boolean onlyPassword = request.getParameter("only_password") != null;
    boolean createAuth = request.getParameter("create_auth") != null;
    String username = getNonEmptyParameter(request, "username");

    try {
        // Get user metadata object UNLESS putting up form to create new user
        // (If  createAuth is true and username is given, we're creating RDF
        // metadata for an "undocumented" auth user.)
        //
        // then sanity check by function:
        // - new user: createAuth && username == null
        // - reinstate: createAuth && username != null (check uu != null)
        // - edit uesr: !createAuth, check uu != null
        User uu = null;
        if (!(createAuth && username == null)) {
            if (username == null) {
                username = Authentication.getAuthenticatedUsername(request);
                if (username == null)
                    throw new BadRequestException("Not creating, and there is no authenticated user found to edit.");
            }
            uu = User.findByUsername(request, username);
            if (uu == null) {
                throw new NotFoundException("No user account found for username '"+username+"'");

            }
        }


        // are we editing current user?
        boolean currentUser = request.getParameter("username") == null ||
            (uu != null && uu.getUsername().equals(Authentication.getAuthenticatedUsername(request)));

        // page title
        String title = null;
        if (createAuth) {
            if (username == null)
                title = "Creating a New User";
            else
                title = "Reinstating: <tt>"+StringEscapeUtils.escapeHtml(username)+"</tt>";
        } else {
            title = "Editing "+(currentUser ? "Current " : "")+"User: <tt>"+StringEscapeUtils.escapeHtml(username)+"</tt>";
        }

      out.write("\n  <head>\n");

        if (standalone) {

      out.write("\n              ");
      out.write("\n\n\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n<style type=\"text/css\">\n BODY { background-color: ");
      out.print( StringEscapeUtils.escapeHtml(Configuration.getInstance().getConfigurationProperty("eaglei.repository.admin.backgroundColor", "lightyellow")) );
      out.write("; }\n .ei_required { color: red; }\n</style>\n");
      out.write("\n              <title>Eagle-I Data Repository - Edit User Metadata</title>\n              <style type=\"text/css\">\n                  h2,h3 { margin: .5em 0; }\n                  .disabled { color: gray; }\n                  .ei_required { color: red; }\n                  .eaglei_passwdForm form { margin: 10px 0; }\n                  .eaglei_passwdForm label { margin: 0 20px 5px 20px; }\n                  .eaglei_passwdForm input { margin: 5px 20px;  }\n              </style>\n\n");

        // NOT standalone
        } else {

      out.write("\n              <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n              <link REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"/repository/styles/i.css\">\n");

        }

      out.write("\n  </head>\n  <body>\n");

        if (standalone) {

      out.write("\n              ");
      out.write('\n');
      out.write("\n\n\n<hr/>\n  <table border=\"0\" width=\"100%\" >\n    <tr>\n      <td width=\"30%\">\n        <a href=\"/repository/admin/\">\n          <img border=\"0\" alt=\"Institutional Logo\" align=\"right\" src=\"");
      out.print( Configuration.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" />\n        </a>\n      </td>\n      <td width=\"70%\"><div align=\"center\">\n");

        String pageTitle = (String)pageContext.getAttribute("eaglei.repository.pageTitle");
        String repoTitle = Configuration.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)");
        String mainTitle = null;
        String subTitle = null;
        if (pageTitle == null) {
            mainTitle = repoTitle;
            subTitle = "Data Repository Administration";
        } else {
            mainTitle = pageTitle;
            subTitle = repoTitle;
        }

      out.write("\n            <font size=\"+1\" color=\"black\">\n              ");
      out.print( StringEscapeUtils.escapeHtml(mainTitle) );
      out.write("</p>\n            </font>\n        </div>\n        <div align=\"center\" style=\"margin-top: 0.5em;\">");
      out.print( StringEscapeUtils.escapeHtml(subTitle) );
      out.write("</div>\n      </td>\n    </tr>\n  </table>\n<hr/>\n");
      out.write("\n              <h2>");
      out.print( title );
      out.write("</h2>\n");

                if (uu != null && uu.getURI() != null) {

      out.write("\n                    <h3>URI: <tt>");
      out.print( StringEscapeUtils.escapeHtml(uu.getURI().stringValue()) );
      out.write("</tt></h3>\n");

                }

      out.write("\n              <span class=\"ei_required\"><i>Input fields labelled in <b>RED</b> are <b>required</b></i></span>\n");

            if (message != null) {

      out.write("\n            <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n                  ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("</font>\n            </h3>\n");

            }
        }

      out.write("\n    <div class=\"eaglei_passwdForm\">\n     <form method=\"POST\" action=\"/repository/admin/updateUser\" accept-charset=\"");
      out.print( acceptCharset );
      out.write("\">\n       <input type=\"hidden\" name=\"action\" value=\"");
      out.print( createAuth ? (username == null ? "create" : "reinstate") : "update" );
      out.write("\"/>\n");

        if (standalone) {

      out.write("\n            <input type=\"hidden\" name=\"standalone\"/>\n");

        }
        if (onlyPassword) {

      out.write("\n            <input type=\"hidden\" name=\"only_password\" value=\"true\"/>\n            <input type=\"hidden\" name=\"username\" value=\"");
      out.print( Utils.escapeHTMLAttribute(username) );
      out.write("\"/>\n");

        } else {
            String first = null;
            String last = null;
            String mailbox = null;
            if (uu != null) {
                first = uu.getFirstName();
                last = uu.getLastName();
                mailbox = uu.getMbox();
            }
            if (createAuth && username == null) {

      out.write("\n                <label for=\"id_username\"><span class=\"ei_required\"><b>Username:</b> </span></label>\n                <input type=\"text\" name=\"username\" id=\"id_username\" size=\"30\" value=\"");
      out.print( username == null ?  "" :  Utils.escapeHTMLAttribute(username) );
      out.write("\"/>\n                <br/>\n");

            } else {

      out.write("\n                <input type=\"hidden\" name=\"username\" value=\"");
      out.print( Utils.escapeHTMLAttribute(username) );
      out.write("\"/>\n");

            }

      out.write("\n            <label for=\"id_first\"><b>First Name:</b> </label>\n            <input type=\"text\" name=\"first\" id=\"id_first\" size=\"30\" value=\"");
      out.print( first == null ?  "" :  Utils.escapeHTMLAttribute(first) );
      out.write("\"/>\n            <br/>\n            <label for=\"id_last\"><b>Last Name:</b> </label>\n            <input type=\"text\" name=\"last\" id=\"id_last\" size=\"30\" value=\"");
      out.print( last == null ? "" : Utils.escapeHTMLAttribute(last) );
      out.write("\"/>\n            <br/>\n            <label for=\"id_mailbox\"><b>Mailbox:</b> </label>\n            <input type=\"text\" name=\"mailbox\" id=\"id_mailbox\" size=\"40\" value=\"");
      out.print( mailbox == null ? "" : Utils.escapeHTMLAttribute(mailbox) );
      out.write("\"/>\n");

        }

        // if this is changing our own password, request old password first:
        if (!createAuth && currentUser) {

      out.write("\n        <br/>\n        <label for=\"id_old_password\">\n          <span><b>Your Current Password:</b> </span>\n        </label>\n        <input type=\"password\" name=\"old_password\" id=\"id_old_password\" size=\"20\"/>\n");

        }

      out.write("\n        <br/>\n");

        boolean pwDisabled = !createAuth && !currentUser && uu != null && !uu.isLoginable();
        if (pwDisabled) {

      out.write("\n        <span><i>Note: This user is currently <b>disabled</b>.\n          You must reinstate them to set a password and allow them to login.\n        </i></span>\n        <br/>\n");

        }

      out.write("\n        <label for=\"id_password\">\n          <span class=\"");
      out.print( pwDisabled ? "disabled" : "" );
      out.write(' ');
      out.print( createAuth ? "ei_required" : "" );
      out.write("\"><b>");
      out.print( createAuth ? "" : "Change " );
      out.write("Password:</b> </span>\n        </label>\n        <input type=\"password\" ");
      out.print( pwDisabled ? "disabled" : "" );
      out.write(" name=\"password\" id=\"id_password\" size=\"20\"/>\n        <br/>\n        <label for=\"id_password_confirm\">\n          <span class=\"");
      out.print( pwDisabled ? "disabled" : "" );
      out.write(' ');
      out.print( createAuth ? "ei_required" : "" );
      out.write("\"><b>Confirm Password:</b> </span>\n        </label>\n        <input type=\"password\" ");
      out.print( pwDisabled ? "disabled" : "" );
      out.write(" name=\"password_confirm\" id=\"id_password_confirm\" size=\"20\"/>\n");

        if (!onlyPassword) {
            String disabled = Authentication.isSuperuser(request) ? "" : "disabled ";
            Collection<Role> roles = Role.findAllUserRoles(request);
            Collections.sort((List<Role>)roles);

      out.write("\n            <br/>\n            <label for=\"id_role\" style=\"vertical-align: top;\">\n              <b>Roles: </b>\n            </label>\n            <select name=\"role\" id=\"id_role\" ");
      out.print( disabled );
      out.write("\n                    multiple=\"true\" size=\"");
      out.print( roles.size() > 6 ? 6 : roles.size() );
      out.write('"');
      out.write('>');
      out.write('\n');

            // check role membership with kludge to accomodate users who
            // are only defined in Auth'n DB but yet might have Superuser role.
            for (Role r : roles) {
                boolean has = false;
                if (uu != null) {
                    has = uu.hasRoleP(r.getURI());
                } else if (r.isSuperuser()) {
                    if (!createAuth && currentUser) {
                        has = Authentication.isSuperuser(request);
                    }
                }

      out.write("\n                <option ");
      out.print( disabled );
      out.write(' ');
      out.print( has ? "selected" : "" );
      out.write(" value=\"");
      out.print( Utils.escapeHTMLAttribute(r.getURI().stringValue()) );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml(r.getLabel()) );
      out.write("</option>\n");

            }

      out.write("\n            </select>\n            <br/><label><i>Use CTRL-click or COMMAND-click to select / deselect multiple Roles.</i></label>\n            <br/>\n");

        }

      out.write("\n        <br/>&nbsp;&nbsp;&nbsp;&nbsp;\n        <button type=\"reset\">Reset Form</button>\n        &nbsp;&nbsp;&nbsp;&nbsp;\n        <button name=\"submit\" value=\"submit\" type=\"submit\">Submit</button>\n     </form>\n    </div>\n");

        if (standalone) {
            if (Authentication.isSuperuser(request)) {

      out.write("\n                <a href=\"/repository/admin/users.jsp\">Back to User List page</a>\n                <br/>\n                <br/>\n                <a href=\"/repository/admin/editUserPortlet.jsp?standalone=true&amp;create_auth\">Create a New User Account</a>\n                <br/>\n                <br/>\n");

            }

      out.write("\n            <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n");

        }
    } catch (IllegalArgumentException e) {
        response.sendError(response.SC_BAD_REQUEST, "Illegal argument: "+e.getMessage());
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n  </body>\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
