package org.eaglei.repository.servlet.admin;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

import org.openrdf.model.URI;

import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.NotFoundException;

/**
 * Modify the metadata for a Named Graph. This servlet exists primarily
 * to serve the Edit Named graph page in the admin JSP UI.  Of course
 * it can be used by itself, but beware of weird behavior when its
 * referrer is a .JSP URL - it will indicate success by redirecting back
 * to the JSP.
 *
 * Method: POST only.
 *
 *   REQUIRED ARGS:
 *    uri = URI of the object
 *   optional:
 *    label
 *    type
 *
 * @author Larry Stone
 * Started March 2011
 */
public class UpdateNamedGraph extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(UpdateNamedGraph.class);

    // args to pass through to JSP
    private static final String PASS_THRU_ARGS[] = {};

    /** {@inheritDoc} */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        URI uri = getParameterAsURI(request, "uri", true);
        String label = getParameter(request, "label", false);
        URI type = getParameterAsURI(request, "type", false);

        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This service is only for use by administrators.");

        // sanity-check args
        NamedGraph ng = NamedGraph.find(request, uri);
        if (ng == null)
            throw new NotFoundException("This URI is not a named graph or managed context: "+uri.stringValue());

        NamedGraphType ngt = null;
        if (type != null) {
            ngt = NamedGraphType.find(request, type);
            if (ngt == null)
                throw new BadRequestException("This type is not a URI of a Named Graph Type: "+type.stringValue());
        }

        ng.setLabel(request, label);
        ng.setType(request, ngt);
        ng.commit(request);

        redirectToJSP(request, response, "Modified the named graph metadata.",
                      PASS_THRU_ARGS, "uri", uri.stringValue());
    }
}
