package org.eaglei.repository.util;

import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.RDFHandlerWrapper;

/**
 * RDF handler that appends the results of multiple parses into one
 * "output" handler.. call startRDF() exactly once, and require
 * the application to call reallyEndRDF().
 *
 * @author lcs
 */
public class AppendingRDFHandler extends RDFHandlerWrapper
{
    private boolean doStart = true;

    /**
     * Constructor
     * @param deferTo the wrapped RDFHandler
     */
    public AppendingRDFHandler(RDFHandler deferTo)
    {
        super(deferTo);
    }

    /** {@inheritDoc} */
    @Override
    public void startRDF()
        throws RDFHandlerException
    {
        if (doStart) {
            doStart = false;
            super.startRDF();
        }
    }

    /** {@inheritDoc} */
    @Override
    public void endRDF()
        throws RDFHandlerException
    {
    }

    /** {@inheritDoc} */
    public void reallyEndRDF()
        throws RDFHandlerException
    {
        super.endRDF();
    }
}
