/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.eaglei.repository.util.Utils;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Configuration {
    private static Logger log = LogManager.getLogger(Configuration.class);
    private static final String LOG_REPO_ROOT = "org.eaglei.repository";
    private static final String LOG_OPENRDF_ROOT = "org.openrdf";
    private static final String SVN_BRANCHES_PREFIX = "branches/";
    private static final String SVN_TAGS_PREFIX = "tags/";
    private static final String REPO_HOME = "org.eaglei.repository.home";
    public static final String NAMESPACE = "eaglei.repository.namespace";
    public static final String LOGDIR = "eaglei.repository.log.dir";
    public static final String SESAMEDIR = "eaglei.repository.sesame.dir";
    public static final String SESAMEINDEXES = "eaglei.repository.sesame.indexes";
    public static final String TITLE = "eaglei.repository.title";
    public static final String INSTANCE_XSLT = "eaglei.repository.instance.xslt";
    public static final String INSTANCE_CSS = "eaglei.repository.instance.css";
    public static final String INSTANCE_JS = "eaglei.repository.instance.js";
    public static final String DATAMODEL_SOURCE = "eaglei.repository.datamodel.source";
    private static Configuration instance = null;
    private String defaultNamespace = null;
    private org.apache.commons.configuration.Configuration configuration = null;
    private Properties buildProperties = null;

    private Configuration() {
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    private static void printError(String msg) {
        System.err.println("***ERROR*** (at " + new Date().toString() + ") eagle-i Configuration: " + msg);
    }

    private static void printInfo(String msg) {
        System.err.println("***INFO*** (at " + new Date().toString() + ") eagle-i Configuration: " + msg);
    }

    public void initialize() throws IOException {
        File pf;
        File home = this.getHomeDirectory();
        Configuration.printInfo((String)("Configuring with Eagle-I Repository Home dir = " + home.toString()));
        if (!home.exists()) {
            if (!home.mkdirs()) {
                Configuration.printError((String)("Failed to create repository home directory, configured path = " + home));
                Configuration.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
            }
        } else if (!home.isDirectory()) {
            Configuration.printError((String)("Path configured as repository home is not a directory: " + home));
            Configuration.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
        }
        if (!(pf = new File(home, "configuration.properties")).exists()) {
            try {
                Utils.copyStream((InputStream)this.getClass().getClassLoader().getResourceAsStream("default.configuration.properties"), (OutputStream)new FileOutputStream(pf));
            }
            catch (IOException e) {
                try {
                    pf.delete();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                Configuration.printError((String)("Failed to copy default configuration file to repository home dir: " + e));
            }
        }
        PropertiesConfiguration literalConfiguration = null;
        try {
            log.debug((Object)("Loading configuration from file=" + pf));
            this.configuration = new PropertiesConfiguration(pf);
            literalConfiguration = new PropertiesConfiguration();
            literalConfiguration.setListDelimiter('\u0000');
            literalConfiguration.load(pf);
        }
        catch (Exception e) {
            Configuration.printError((String)("Failed to read configuration, file=" + pf + ": " + e.toString()));
        }
        Properties lp = new Properties();
        Iterator pi = literalConfiguration.getKeys("log4j");
        while (pi.hasNext()) {
            String k = (String)pi.next();
            lp.setProperty(k, literalConfiguration.getString(k));
        }
        this.setupDefaultLogging(home, lp);
    }

    private void setPropertyUnlessOverride(Properties lp, String key, String value) {
        if (!lp.containsKey(key)) {
            lp.setProperty(key, value);
        }
    }

    private void setupDefaultLogging(File home, Properties lp) throws IOException {
        String logPath = this.configuration.getString("eaglei.repository.log.dir");
        File logDir = logPath == null ? new File(home, "logs") : new File(logPath);
        Configuration.printInfo((String)("Set up default log4j config: logfile directory: " + logDir.toString()));
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        Logger repoRoot = LogManager.getLogger((String)"org.eaglei.repository");
        Configuration.printInfo((String)("Got " + String.valueOf(lp.size()) + " initial log4j properties from repo configuration."));
        this.setPropertyUnlessOverride(lp, "log4j.logger.org.eaglei.repository", "INFO, repository");
        this.setPropertyUnlessOverride(lp, "log4j.additivity.org.eaglei.repository", "false");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository", RollingFileAppender.class.getName());
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.File", new File(logDir, "repository.log").toString());
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.ImmediateFlush", "false");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.BufferedIO", "true");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.Append", "true");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.Encoding", "UTF-8");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.layout", PatternLayout.class.getName());
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.layout.ConversionPattern", "%d{ISO8601} T=%t %p %c - %m%n");
        this.setPropertyUnlessOverride(lp, "log4j.logger.org.openrdf", "WARN, repository");
        Configuration.printInfo((String)("Configuring log4j with properties: " + lp.toString()));
        PropertyConfigurator.configure((Properties)lp);
        Enumeration rae = repoRoot.getAllAppenders();
        if (!rae.hasMoreElements()) {
            Configuration.printError((String)"The org.eaglei.repository logger has no appenders!  This may result in no log records. Check your log4j configuration properties.");
        }
        while (rae.hasMoreElements()) {
            AppenderSkeleton ra = (AppenderSkeleton)rae.nextElement();
            Configuration.printInfo((String)("Activating log4j appender \"" + ra.getName() + "\" for logger " + "org.eaglei.repository"));
            ra.activateOptions();
        }
        log.debug((Object)("logger " + repoRoot.getName() + " additivity=" + repoRoot.getAdditivity()));
    }

    public String getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            String cfg = this.configuration.getString("eaglei.repository.namespace");
            if (cfg != null) {
                log.debug((Object)("Got raw configured default namespace=" + cfg));
                try {
                    URI juri = new URI(cfg);
                    if (!juri.isAbsolute()) {
                        log.error((Object)("The configured namespace prefix must be an absolute URI: eaglei.repository.namespace = " + cfg));
                    } else if (juri.getPath() == null) {
                        log.error((Object)("The configured namespace prefix must include a path ending with a slash ('/'): eaglei.repository.namespace = " + cfg));
                    } else if (!juri.getPath().endsWith("/")) {
                        log.error((Object)("The configured namespace prefix must end with a slash ('/'): eaglei.repository.namespace = " + cfg));
                    } else {
                        String scheme = juri.getScheme();
                        if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) {
                            this.defaultNamespace = cfg;
                        } else {
                            log.error((Object)("The configured namespace prefix must be an absolute URI: eaglei.repository.namespace = " + cfg));
                        }
                    }
                }
                catch (URISyntaxException e) {
                    log.error((Object)("The configured namespace prefix has illegal URI syntax: eaglei.repository.namespace = " + cfg + ": " + e));
                }
            }
            if (this.defaultNamespace == null) {
                try {
                    this.defaultNamespace = "http://" + InetAddress.getLocalHost().getHostName() + "/i/";
                }
                catch (UnknownHostException e) {
                    log.error((Object)"Failed to get hostname for default URI prefix", (Throwable)e);
                    this.defaultNamespace = "http://failed-to-get-local-host-name/i/";
                }
                if (cfg == null) {
                    log.warn((Object)"Default Namespace Prefix URI not configured.  You really should set a configuration value for eaglei.repository.namespace");
                }
                log.warn((Object)("Using emergency default for namespace prefix URI (probably wrong) = " + this.defaultNamespace));
            }
        }
        return this.defaultNamespace;
    }

    public String getConfigurationProperty(String key) {
        return this.configuration.getString(key);
    }

    public String getConfigurationProperty(String key, String dflt) {
        String result = this.configuration.getString(key);
        return result == null ? dflt : result;
    }

    public String[] getConfigurationPropertyArray(String key, String[] dfault) {
        return this.configuration.containsKey(key) ? this.configuration.getStringArray(key) : dfault;
    }

    public boolean getConfigurationPropertyAsBoolean(String key, boolean dflt) {
        String result = this.configuration.getString(key);
        return result == null ? dflt : Boolean.parseBoolean(result);
    }

    public int getConfigurationPropertyAsInt(String key, int dflt) {
        String result = this.configuration.getString(key);
        if (result == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Failed parsing integer from configuration value for key=" + key + ", illegal value was: \"" + result + "\", returning: " + dflt));
            return dflt;
        }
    }

    public String getProjectVersion() {
        return this.getBuildProperties().getProperty("version");
    }

    public String getRevision() {
        return this.getBuildProperties().getProperty("revision");
    }

    public String getBranch() {
        String branch = this.getBuildProperties().getProperty("branch");
        if (branch == null) {
            log.warn((Object)"Cannot find build property \"branch\".");
            return null;
        }
        if (branch.startsWith("branches/")) {
            int nextSlash = branch.indexOf(47, "branches/".length());
            return nextSlash < 0 ? branch.substring("branches/".length()) : branch.substring("branches/".length(), nextSlash);
        }
        if (branch.startsWith("tags/")) {
            int nextSlash = branch.indexOf(47, "tags/".length());
            return nextSlash < 0 ? branch.substring("tags/".length()) : branch.substring("tags/".length(), nextSlash);
        }
        if (!branch.equals("trunk") && !branch.startsWith("${")) {
            log.warn((Object)("Build property \"branch\" has unexpected value: \"" + branch + "\""));
        }
        return null;
    }

    public String getTimestamp() {
        return this.getBuildProperties().getProperty("timestamp");
    }

    private Properties getBuildProperties() {
        if (this.buildProperties == null) {
            this.buildProperties = new Properties();
            try {
                this.buildProperties.load(this.getClass().getClassLoader().getResourceAsStream("build.properties"));
            }
            catch (IOException e) {
                log.error((Object)"Failed loading build.properties: ", (Throwable)e);
            }
        }
        return this.buildProperties;
    }

    public File getHomeDirectory() throws IOException {
        String home = System.getProperty("org.eaglei.repository.home");
        File result = null;
        boolean haveSysProp = home != null;
        result = !haveSysProp ? new File(System.getProperty("user.home"), "eaglei" + File.separator + "repository") : new File(home);
        if (!result.exists() && !result.mkdirs()) {
            log.fatal((Object)("The configured home directory does not exist: " + result.toString()));
            throw new IOException("The configured home directory does not exist: " + result.toString());
        }
        if (!result.isDirectory()) {
            log.fatal((Object)("The configured home directory is not a directory or is protected: " + result.toString()));
            throw new IOException("The configured home directory is not a directory or is protected: " + result.toString());
        }
        log.debug((Object)("repository home directory = " + result.toString()));
        if (!haveSysProp) {
            System.setProperty("org.eaglei.repository.home", result.toString());
        }
        return result;
    }

    public String getSesameVersion() throws IOException {
        String result = null;
        Package rcp = RepositoryConnection.class.getPackage();
        if (rcp == null) {
            log.debug((Object)("Cannot get Sesame version from package, no package for class " + RepositoryConnection.class.getName()));
        } else {
            result = rcp.getImplementationVersion();
            if (result == null) {
                log.debug((Object)("Cannot get Sesame version, package has no ImplementationVersion: " + rcp.getName()));
            } else {
                return result;
            }
        }
        String classRes = "/" + RepositoryConnection.class.getName().replace('.', '/') + ".class";
        URL rurl = RepositoryConnection.class.getResource(classRes);
        if (rurl == null) {
            log.warn((Object)("Failed to find Sesame class resource path=" + classRes));
        } else {
            log.debug((Object)("Got sesame class resource URL =" + rurl));
            String surl = rurl.toString();
            if (surl.startsWith("jar:")) {
                Pattern ep = Pattern.compile("jar:([^!]+)!.*");
                log.debug((Object)("Groveling jar URL with pattern=\"" + ep.pattern() + "\""));
                Matcher em = ep.matcher(surl);
                if (em.matches()) {
                    String jarURLspec = em.group(1);
                    log.debug((Object)("Got jar URL = " + jarURLspec));
                    result = Utils.getMavenVersionFromJar((String)jarURLspec);
                    if (result != null) {
                        return result;
                    }
                } else {
                    log.warn((Object)("Failed matching jar URL regex on Sesame class URL; pattern=\"" + ep.pattern() + "\" against owl resource URL=" + surl));
                }
            } else {
                log.warn((Object)("Sesame Class Resource URL is NOT in Jar scheme: " + surl));
            }
        }
        return "(unknown)";
    }

    public File getSesameDirectory() throws IOException {
        File sesDir;
        String sesPath = this.getConfigurationProperty("eaglei.repository.sesame.dir");
        File file = sesDir = sesPath == null ? new File(this.getHomeDirectory(), "sesame") : new File(sesPath);
        if (!sesDir.exists()) {
            sesDir.mkdirs();
        }
        return sesDir;
    }
}

