/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
@HasContentCache
public enum NamedGraphType {
    ontology(REPO.NGTYPE_ONTOLOGY),
    metadata(REPO.NGTYPE_METADATA),
    workspace(REPO.NGTYPE_WORKSPACE),
    published(REPO.NGTYPE_PUBLISHED),
    internal(REPO.NGTYPE_INTERNAL);

    private static Logger log;
    private URI uri = null;
    private String label = null;
    private static volatile Map<URI, NamedGraphType> uriToNGT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decache() {
        Class<NamedGraphType> clazz = NamedGraphType.class;
        synchronized (NamedGraphType.class) {
            uriToNGT = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<URI, NamedGraphType> getMap(HttpServletRequest request) {
        Class<NamedGraphType> clazz = NamedGraphType.class;
        synchronized (NamedGraphType.class) {
            if (uriToNGT != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return uriToNGT;
            }
            uriToNGT = new HashMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                log.debug((Object)"Filling the NamedGraphType cache..");
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                for (NamedGraphType ngt : NamedGraphType.values()) {
                    URI subject = ngt.getURI();
                    uriToNGT.put(subject, ngt);
                    RepositoryResult rr = rc.getStatements((Resource)subject, RDFS.LABEL, null, false, new Resource[]{REPO.NG_REPO_ONTOLOGY});
                    try {
                        if (rr.hasNext()) {
                            ngt.label = Utils.valueAsString((Value)((Statement)rr.next()).getObject());
                            log.debug((Object)("Found label for uri=" + ngt.getURI() + ", label=\"" + ngt.label + "\""));
                            continue;
                        }
                        log.warn((Object)("Cannot find label, substituting default for uri=" + ngt.getURI()));
                        ngt.label = ngt.defaultLabel();
                    }
                    finally {
                        rr.close();
                    }
                }
            }
            catch (RepositoryException e) {
                log.error((Object)e);
                throw new InternalServerErrorException((Throwable)e);
            }
            return uriToNGT;
        }
    }

    private NamedGraphType(URI u) {
        this.uri = u;
    }

    public URI getURI() {
        return this.uri;
    }

    public static NamedGraphType parse(String v) {
        try {
            return NamedGraphType.valueOf((String)v);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static NamedGraphType parse(URI v) {
        for (NamedGraphType t : NamedGraphType.values()) {
            if (!t.uri.equals(v)) continue;
            return t;
        }
        return null;
    }

    private String defaultLabel() {
        String result = this.toString();
        return String.format("%C%s", Character.valueOf(result.charAt(0)), result.substring(1));
    }

    public String getLabel() {
        return this.label == null ? this.defaultLabel() : this.label;
    }

    public static NamedGraphType find(HttpServletRequest request, URI subject) throws ServletException {
        return (NamedGraphType)NamedGraphType.getMap((HttpServletRequest)request).get(subject);
    }

    public static List<NamedGraphType> findAll(HttpServletRequest request) throws ServletException {
        return new ArrayList<NamedGraphType>(NamedGraphType.getMap((HttpServletRequest)request).values());
    }

    static {
        log = LogManager.getLogger(NamedGraphType.class);
        uriToNGT = null;
    }
}

