/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.model.Transporter;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.DuplicateArg;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

public class TransportAccessGrant
implements Transporter {
    private static Logger log = LogManager.getLogger(TransportAccessGrant.class);
    private static final String IMPORT_GRANTS_QUERY = "SELECT DISTINCT ?subject WHERE { ?subject ?access ?agent }";

    public void authorizeExport(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Export of access grants requires administrator privileges.");
        }
    }

    public void authorizeImport(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Import of access grants requires administrator privileges.");
        }
    }

    public void doExport(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            RDFWriter out = Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            out.startRDF();
            if (includes.isEmpty()) {
                throw new BadRequestException("Export of grants requires an include list of URIs");
            }
            if (!excludes.isEmpty()) {
                throw new BadRequestException("Export of grants does not support an exclude list");
            }
            for (String iu : includes) {
                URIImpl uri = new URIImpl(iu);
                for (Statement s : AccessGrant.exportGrants((URI)uri, (Iterable)AccessGrant.getGrants((HttpServletRequest)request, (URI)uri))) {
                    out.handleStatement(s);
                }
            }
            out.endRDF();
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, DuplicateArg duplicate, boolean transform, boolean ignoreACL) throws ServletException, IOException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, IMPORT_GRANTS_QUERY);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            TupleQueryResult qr = null;
            try {
                qr = SPARQL.evaluateTupleQuery((String)IMPORT_GRANTS_QUERY, (TupleQuery)q);
                while (qr.hasNext()) {
                    BindingSet bs = (BindingSet)qr.next();
                    URI uri = (URI)bs.getValue("subject");
                    String us = uri.stringValue();
                    if (excludes.contains(us)) {
                        log.debug((Object)("SKIP IMPORT GRANT because of exclude: uri=" + us));
                        continue;
                    }
                    if (!includes.isEmpty() && !includes.contains(us)) {
                        log.debug((Object)("SKIP IMPORT GRANT because of include: uri=" + us));
                        continue;
                    }
                    for (Statement s : AccessGrant.importGrants((HttpServletRequest)request, (RepositoryConnection)content, (URI)uri, (URI)uri)) {
                        log.debug((Object)("Adding access grant statement: " + s));
                        rc.add(s, new Resource[]{REPO.NG_INTERNAL});
                    }
                }
            }
            finally {
                if (qr != null) {
                    qr.close();
                }
            }
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }
}

