/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.model.workflow;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.AccessGrant;
import org.eaglei.repository.model.Transporter;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.DuplicateArg;
import org.eaglei.repository.util.HandlerBadRequest;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

public class TransportWorkflowTransition
implements Transporter {
    private static Logger log = LogManager.getLogger(TransportWorkflowTransition.class);

    public void authorizeExport(HttpServletRequest request) throws ServletException {
        if (Authentication.getAuthenticatedUsername((HttpServletRequest)request) == null) {
            throw new ForbiddenException("Export of WFTs requires an authenticated user login.");
        }
    }

    public void authorizeImport(HttpServletRequest request) throws ServletException {
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Import of WFTs requires administrator privileges.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            RDFWriter out = Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            out.startRDF();
            for (WorkflowTransition t : WorkflowTransition.findAll((HttpServletRequest)request)) {
                URI tu = t.getURI();
                String tus = tu.stringValue();
                String tl = t.getLabel();
                if (excludes.contains(tl) || excludes.contains(tus)) {
                    log.debug((Object)("SKIP TRANSITION because of exclude: " + t));
                    continue;
                }
                if (includes.isEmpty() || includes.contains(tl) || includes.contains(tus)) {
                    RepositoryResult rr = null;
                    try {
                        rr = rc.getStatements((Resource)tu, null, null, false, new Resource[]{REPO.NG_INTERNAL});
                        while (rr.hasNext()) {
                            out.handleStatement((Statement)rr.next());
                        }
                    }
                    finally {
                        rr.close();
                    }
                    for (Statement s : AccessGrant.exportGrants((URI)tu, (Iterable)AccessGrant.getGrants((HttpServletRequest)request, (URI)tu))) {
                        out.handleStatement(s);
                    }
                    continue;
                }
                log.debug((Object)("SKIP TRANSITION because of include: " + t));
            }
            out.endRDF();
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void doImport(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, DuplicateArg duplicate, boolean transform, boolean ignoreACL) throws ServletException, IOException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, WorkflowTransition.SIMPLE_TRANSITION_QUERY);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(false);
            ArrayList result = new ArrayList();
            SPARQL.evaluateTupleQuery((String)WorkflowTransition.SIMPLE_TRANSITION_QUERY, (TupleQuery)q, (TupleQueryResultHandler)new WorkflowTransition.WFTHandler(result));
            HashSet<URI> existingURI = new HashSet<URI>();
            HashMap<String, URI> existingLabel = new HashMap<String, URI>();
            for (WorkflowTransition e : WorkflowTransition.findAll((HttpServletRequest)request)) {
                URI u = e.getURI();
                existingURI.add(u);
                existingLabel.put(e.getLabel(), u);
            }
            for (WorkflowTransition t : result) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("import Transition: Got raw result: " + t));
                }
                URI tu = t.getURI();
                String us = tu.stringValue();
                String ls = t.getLabel();
                if (excludes.contains(us) || excludes.contains(ls)) {
                    log.debug((Object)("SKIP IMPORT TRANSITION because of exclude: uri=" + us + ", label=" + ls));
                    continue;
                }
                if (!(includes.isEmpty() || includes.contains(us) || includes.contains(ls))) {
                    log.debug((Object)("SKIP IMPORT TRANSITION because of include: uri=" + us + ", label=" + ls));
                    continue;
                }
                URI du = null;
                if (existingURI.contains(tu)) {
                    du = tu;
                } else if (existingLabel.containsKey(ls)) {
                    du = (URI)existingLabel.get(ls);
                }
                if (du != null) {
                    log.debug((Object)("Found a duplicate Transition uri=" + du.stringValue()));
                    if (duplicate == DuplicateArg.ignore) {
                        log.debug((Object)("SKIPPING duplicate Transition, input uri=" + us));
                        continue;
                    }
                    if (duplicate == DuplicateArg.abort) {
                        throw new HandlerBadRequest("Import contains a duplicate Transition for existing Transition uri=" + du.stringValue());
                    }
                    if (duplicate == DuplicateArg.replace) {
                        WorkflowTransition orig = WorkflowTransition.find((HttpServletRequest)request, (URI)du);
                        orig.delete(request);
                    }
                }
                URI nu = t.write(request, transform);
                if (ignoreACL) continue;
                for (Statement s : AccessGrant.importGrants((HttpServletRequest)request, (RepositoryConnection)content, (URI)tu, (URI)nu)) {
                    log.debug((Object)("Adding access grant stm: " + s));
                    rc.add(s, new Resource[]{REPO.NG_INTERNAL});
                }
            }
        }
        catch (HandlerBadRequest e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }
}

