/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.model.DataModel;
import org.eaglei.repository.model.View;
import org.eaglei.repository.servlet.EmailContact;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;

public class EmailContact
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(EmailContact.class);
    private static final String CONFIG_POSTMASTER = "eaglei.repository.postmaster";
    private static final String CONFIG_MTA_HOST = "eaglei.repository.mail.host";
    private static final String CONFIG_MTA_PORT = "eaglei.repository.mail.port";
    private static final String CONFIG_MTA_SSL = "eaglei.repository.mail.ssl";
    private static final String CONFIG_MTA_USERNAME = "eaglei.repository.mail.username";
    private static final String CONFIG_MTA_PASSWORD = "eaglei.repository.mail.password";
    private static final String postmaster = Configuration.getInstance().getConfigurationProperty("eaglei.repository.postmaster");
    private static final String mtaHost = Configuration.getInstance().getConfigurationProperty("eaglei.repository.mail.host", "localhost");
    private static final String mtaPort = Configuration.getInstance().getConfigurationProperty("eaglei.repository.mail.port");
    private static final String mtaUsername = Configuration.getInstance().getConfigurationProperty("eaglei.repository.mail.username");
    private static final String mtaPassword = Configuration.getInstance().getConfigurationProperty("eaglei.repository.mail.password");
    private static final boolean mtaSSL = Configuration.getInstance().getConfigurationPropertyAsBoolean("eaglei.repository.mail.ssl", false);
    private static final String emailQuery = DataModel.CONTACT_EMAIL_QUERY.getString();
    private static final String[] emailQueryVars = DataModel.CONTACT_EMAIL_BINDINGS.getArrayOfString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        URI uri = this.getParameterAsURI(request, "uri", true);
        String clientIP = this.getParameter(request, "client_ip", true);
        String fromName = this.getParameter(request, "from_name", true);
        String fromEmail = this.getParameter(request, "from_email", true);
        String subject = this.getParameter(request, "subject", false);
        String message = this.getParameter(request, "message", false);
        boolean testMode = this.isParameterPresent(request, "test_mode");
        if (emailQuery == null || emailQueryVars == null) {
            throw new ServletException("Configuration error, email contact query is not configured correctly.");
        }
        int at = fromEmail.indexOf(64);
        if (at < 0 || fromEmail.indexOf(46, at) < 0) {
            throw new BadRequestException("Bad value for the required arg 'from_email', must be a valid email address.");
        }
        if (postmaster == null) {
            throw new InternalServerErrorException("Repository configuration is missing the required property: eaglei.repository.postmaster");
        }
        String referrer = request.getHeader("Referer");
        if (referrer == null) {
            throw new BadRequestException("This service may only be called from another page (to set the referer).");
        }
        URL backLink = new URL(referrer);
        log.debug((Object)("Got Referer = " + referrer));
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (!rc.hasStatement((Resource)uri, RDF.TYPE, null, false, new Resource[0])) {
                throw new NotFoundException("Subject not found in this repository: " + uri.toString());
            }
            String label = null;
            RepositoryResult rr = rc.getStatements((Resource)uri, RDFS.LABEL, null, false, new Resource[0]);
            try {
                while (rr.hasNext()) {
                    Statement s = (Statement)rr.next();
                    Value rl = s.getObject();
                    if (!(rl instanceof Literal)) continue;
                    label = ((Literal)rl).getLabel();
                    break;
                }
            }
            finally {
                rr.close();
            }
            String myHost = request.getServerName();
            StringBuilder body = new StringBuilder();
            body.append("This message was generated by the eagle-i server on ").append(myHost).append("\n");
            body.append("An eagle-i visitor, ").append(fromName).append(", wishes to contact the owner of this resource:\n").append("  Label: ").append(label == null ? "" : label).append("\n    URI: ").append(uri.stringValue()).append("\n");
            body.append("\nClient remote IP address = ").append(clientIP).append("\n");
            body.append("\nMessage from ").append(fromName).append(":\n--------------------------------------------------\n").append(message == null ? "(no message)" : message);
            body.append("\n--------------------------------------------------\n");
            SimpleEmail msg = new SimpleEmail();
            msg.setCharset("UTF-8");
            msg.setMsg(body.toString());
            msg.setFrom(fromEmail, fromName);
            msg.addReplyTo(fromEmail, fromName);
            msg.setBounceAddress(postmaster);
            msg.setSubject(subject == null ? "Inquiry from eagle-i" : subject);
            if (testMode) {
                msg.addTo(postmaster);
            }
            DatasetImpl ds = new DatasetImpl();
            View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)View.USER_RESOURCES);
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, emailQuery);
            q.setDataset((Dataset)ds);
            q.clearBindings();
            q.setBinding("subject", (Value)uri);
            SPARQL.evaluateTupleQuery((String)emailQuery, (TupleQuery)q, (TupleQueryResultHandler)new EmailQueryHandler(this, uri, (Email)msg, testMode, null));
            msg.setHostName(mtaHost);
            if (mtaSSL) {
                msg.setSSL(true);
                if (mtaUsername != null && mtaPassword == null || mtaUsername == null && mtaPassword != null) {
                    throw new InternalServerErrorException("Bad configuraiton, must have BOTH username and password for mail server.");
                }
                if (mtaUsername != null && mtaPassword != null) {
                    msg.setAuthentication(mtaUsername, mtaPassword);
                }
                if (mtaPort != null) {
                    msg.setSslSmtpPort(mtaPort);
                }
            } else if (mtaPort != null) {
                try {
                    int p = Integer.parseInt(mtaPort);
                    msg.setSmtpPort(p);
                }
                catch (NumberFormatException e) {
                    throw new BadRequestException(e.toString(), (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                msg.buildMimeMessage();
                MimeMessage mm = msg.getMimeMessage();
                if (mm == null) {
                    log.error((Object)"Failed getMimeMessage!");
                } else {
                    mm.writeTo((OutputStream)baos);
                    log.debug((Object)("Msg = " + baos.toString()));
                }
            }
            msg.send();
            String redir = backLink.getProtocol() + "://" + backLink.getHost() + (backLink.getPort() < 0 ? "" : ":" + String.valueOf(backLink.getPort())) + backLink.getPath() + "?sent=true&uri=" + URLEncoder.encode(uri.stringValue(), Charset.defaultCharset().name()) + "&test_mode=" + String.valueOf(testMode);
            log.debug((Object)("Redirecting to: " + redir));
            response.sendRedirect(redir);
        }
        catch (MessagingException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (EmailException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ String[] access$100() {
        return emailQueryVars;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ String access$300() {
        return postmaster;
    }
}

