/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Lifecycle;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.servlet.Internal;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class Internal
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Internal.class);
    private static final String MEDIA_TYPE = "text/plain";
    private static final URI[] UPGRADEABLE_GRAPHS = new URI[]{REPO.NAMESPACE_URI, REPO.NG_QUERY};

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        if (this.isParameterPresent(request, "action")) {
            throw new BadRequestException("The 'action' argument is not allowed in the GET method, use POST.");
        }
        URI name = this.getParameterAsURI(request, "name", false);
        String format = this.getParameter(request, "format", false);
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            ArrayList<BindingSet> result = new ArrayList<BindingSet>(1);
            if (name == null) {
                for (URI n : UPGRADEABLE_GRAPHS) {
                    result.add(this.makeRow(rc, n));
                }
            } else {
                result.add(this.makeRow(rc, name));
            }
            SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, result);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    private BindingSet makeRow(RepositoryConnection rc, URI name) throws IOException, RepositoryException, RDFParseException, RDFHandlerException {
        String available = Lifecycle.getInitFileVersion((URI)name);
        String loaded = Utils.getVersionInfo((RepositoryConnection)rc, (URI)name, (URI)name);
        MapBindingSet bs = new MapBindingSet(3);
        ValueFactory vf = rc.getValueFactory();
        bs.addBinding("name", (Value)name);
        bs.addBinding("loaded", loaded == null ? null : vf.createLiteral(loaded));
        bs.addBinding("available", available == null ? null : vf.createLiteral(available));
        return bs;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
        String query = this.getParameter(request, "query", false);
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("Administrator privileges required.");
        }
        if (action == Action.decache) {
            Lifecycle.decacheAll();
        } else if (action == Action.read) {
            URI name = this.getParameterAsURI(request, "name", true);
            String path = Lifecycle.getGraphInitFile((URI)name);
            if (path == null) {
                throw new BadRequestException("There is no initializer for graph named: " + name);
            }
            response.setContentType(MEDIA_TYPE);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + path + "\"");
            Utils.copyStream((InputStream)this.getClass().getClassLoader().getResourceAsStream(path), (OutputStream)response.getOutputStream());
        } else {
            if (action == Action.query) {
                if (query == null) {
                    throw new BadRequestException("Missing required argument 'query'");
                }
                String[] rawNames = this.getParameters(request, "name", false);
                if (rawNames == null) {
                    throw new BadRequestException("Missing required argument 'name'");
                }
                SailRepository mr = null;
                RepositoryConnection mrc = null;
                try {
                    mr = new SailRepository((Sail)new MemoryStore());
                    mr.initialize();
                    mrc = mr.getConnection();
                    for (String rawName : rawNames) {
                        URI name = Utils.parseURI((String)rawName, (String)"name", (boolean)true);
                        String path = Lifecycle.getGraphInitFile((URI)name);
                        mrc.add(this.getClass().getClassLoader().getResourceAsStream(path), "", RDFFormat.N3, new Resource[0]);
                    }
                    RDFFormat rf = Formats.getRDFOutputFormatForMIMEType((String)MEDIA_TYPE);
                    response.setContentType(MEDIA_TYPE);
                    GraphQuery q = mrc.prepareGraphQuery(QueryLanguage.SPARQL, query);
                    SPARQL.evaluateGraphQuery((String)query, (GraphQuery)q, (RDFHandler)Rio.createWriter((RDFFormat)rf, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")));
                }
                catch (OpenRDFException e) {
                    log.error((Object)"Failed loading initializer or in query: ", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
                finally {
                    try {
                        if (mrc != null && mrc.isOpen()) {
                            mrc.close();
                        }
                        if (mr != null) {
                            mr.shutDown();
                        }
                    }
                    catch (RepositoryException e) {
                        log.error((Object)"Failed while closing temporary repo of import content: ", (Throwable)e);
                        throw new ServletException((Throwable)e);
                    }
                }
            }
            if (action == Action.load) {
                String[] rawNames = this.getParameters(request, "name", false);
                if (rawNames == null) {
                    throw new BadRequestException("Missing required argument 'name'");
                }
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                try {
                    for (String rawName : rawNames) {
                        URI name = Utils.parseURI((String)rawName, (String)"name", (boolean)true);
                        log.debug((Object)("Updating internal graph, name=" + name));
                        rc.clear(new Resource[]{name});
                        Lifecycle.getInstance().loadEmptyGraphFromInit(rc, name, false);
                    }
                    rc.commit();
                    response.setStatus(201);
                }
                catch (OpenRDFException e) {
                    log.error((Object)e);
                    throw new ServletException((Throwable)e);
                }
            } else {
                throw new BadRequestException("Unrecognized action value: " + action);
            }
        }
    }
}

