/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Configuration;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.util.SPARQL;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.impl.MapBindingSet;

public class New
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(New.class);
    private static String[] columnNames = new String[]{"new"};

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String rawcount = this.getParameter(request, "count", false);
        String format = this.getParameter(request, "format", false);
        int count = 1;
        if (rawcount != null) {
            try {
                count = Integer.parseInt(rawcount);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("The 'count' argument was not an integer: " + count, (Throwable)e);
            }
        }
        if (count <= 0) {
            throw new BadRequestException("The 'count' argument was not an integer greater than 0: " + count);
        }
        log.debug((Object)("Got /new GET request, count=" + count));
        UUID[] uuids = RIDGenerator.getInstance().newIDs(count);
        ArrayList<MapBindingSet> results = new ArrayList<MapBindingSet>(uuids.length);
        for (UUID uuid : uuids) {
            MapBindingSet bs = new MapBindingSet(1);
            bs.addBinding(columnNames[0], (Value)new URIImpl(Configuration.getInstance().getDefaultNamespace() + uuid.toString()));
            results.add(bs);
        }
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, results);
    }
}

