/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.DataModel;
import org.eaglei.repository.model.EditToken;
import org.eaglei.repository.model.NamedGraph;
import org.eaglei.repository.model.NamedGraphType;
import org.eaglei.repository.model.Provenance;
import org.eaglei.repository.model.View;
import org.eaglei.repository.model.workflow.Workflow;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.Update;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.HttpStatusException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.util.WithRepositoryConnection;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class Update
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Update.class);
    private static final String embeddedInstanceQuery = "SELECT DISTINCT ?ei WHERE { ?subject ?p ?ei . ?ei a ?eit . ?eit <" + DataModel.EMBEDDED_INSTANCE_PREDICATE.toString() + "> <" + DataModel.EMBEDDED_INSTANCE_OBJECT.toString() + "> }";
    private static final String isEmbeddedInstanceQuery = "ASK  WHERE { ?subject a ?eit . ?eit <" + DataModel.EMBEDDED_INSTANCE_PREDICATE.toString() + "> <" + DataModel.EMBEDDED_INSTANCE_OBJECT.toString() + "> }";
    private static final String poachedEmbeddedInstanceQuery = "ASK  WHERE { ?subject ?p ?ei . \n ?ei a ?eit . \n ?eit <" + DataModel.EMBEDDED_INSTANCE_PREDICATE.toString() + "> <" + DataModel.EMBEDDED_INSTANCE_OBJECT.toString() + "> .\n" + " ?s2 ?p2 ?ei FILTER(?s2 != ?subject)}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block33: {
            request.setCharacterEncoding("UTF-8");
            URI uri = this.getParameterAsURI(request, "uri", true);
            Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
            URI tokenURI = this.getParameterAsURI(request, "token", false);
            URI wsURI = this.getParameterAsURI(request, "workspace", false);
            String format = this.getParameter(request, "format", false);
            boolean bypassSanity = this.isParameterPresent(request, "bypassSanity");
            Reader deleteReader = this.getParameterAsReader(request, "delete", false);
            String deleteContentType = this.getParameterContentType(request, "delete");
            Reader insertReader = this.getParameterAsReader(request, "insert", false);
            String insertContentType = this.getParameterContentType(request, "insert");
            if (action == Action.create && wsURI == null) {
                throw new BadRequestException("The 'workspace' argument is required when creating a new instance.");
            }
            try {
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                ValueFactory vf = rc.getValueFactory();
                DatasetImpl ds = new DatasetImpl();
                View.addGraphs((HttpServletRequest)request, (DatasetImpl)ds, (View)View.USER);
                if (action == Action.create) {
                    if (rc.hasStatement((Resource)uri, RDF.TYPE, null, false, new Resource[0])) {
                        throw new BadRequestException("This resource already exists so 'create' is not allowed: " + uri);
                    }
                } else {
                    URI homeGraph = this.getHomeGraph(rc, uri, (Dataset)ds);
                    if (homeGraph == null) {
                        throw new NotFoundException("Resource not found in this repository: " + uri.toString());
                    }
                    if (wsURI == null) {
                        wsURI = homeGraph;
                    } else if (!wsURI.equals(homeGraph)) {
                        throw new BadRequestException("Resource not found in specified workspace, its home graph is: " + homeGraph.toString());
                    }
                }
                log.debug((Object)("Final workspace URI = " + wsURI.toString()));
                NamedGraph wng = NamedGraph.find((HttpServletRequest)request, (URI)wsURI);
                if (wng == null) {
                    throw new BadRequestException("Invalid workspace, this is not a named graph: " + wsURI);
                }
                NamedGraphType wngt = wng.getType();
                if (wngt != NamedGraphType.published && wngt != NamedGraphType.workspace) {
                    throw new BadRequestException("Resource is not in an appropriate workspace, ws = " + wsURI);
                }
                if (action == Action.gettoken) {
                    this.doGetToken(request, response, uri, format);
                    break block33;
                }
                HashSet<URI> embeddedInstances = new HashSet<URI>();
                DatasetImpl qds = new DatasetImpl();
                View.addWorkspaceGraphs((HttpServletRequest)request, (DatasetImpl)qds, (URI)wsURI);
                if (bypassSanity && !Authentication.isSuperuser((HttpServletRequest)request)) {
                    throw new ForbiddenException("Bypassing sanity checks requires Administrator privilege.");
                }
                if (action == Action.create) {
                    if (deleteReader != null) {
                        throw new BadRequestException("Delete is not allowed when creating a new resource.");
                    }
                    if (insertReader == null) {
                        throw new BadRequestException("Request to create an instance must include the insert graph.");
                    }
                }
                EditToken token = null;
                if (action == Action.update) {
                    if (insertReader != null && !Access.hasPermission((HttpServletRequest)request, (Resource)uri, (Access)Access.ADD)) {
                        throw new ForbiddenException("User is not permitted to insert into resource instance: " + uri);
                    }
                    if (deleteReader != null && !Access.hasPermission((HttpServletRequest)request, (Resource)uri, (Access)Access.REMOVE)) {
                        throw new ForbiddenException("User is not permitted to delete from resource instance: " + uri);
                    }
                    token = EditToken.find((HttpServletRequest)request, (URI)uri);
                    if (token == null) {
                        log.info((Object)("Update was not accepted because token was already gone: " + uri));
                        throw new ConflictException("The resource instance you were updating has already been changed, so this update cannot be accepted since it would undo the previous update. If you still wish to make changes to this resource, you must open it for editing again: " + uri);
                    }
                    if (!token.getURI().equals(tokenURI)) {
                        log.info((Object)("Update was not accepted because token did not match: " + uri + ", current token=" + token));
                        throw new ConflictException("The resource instance you were updating has already been changed, AND ANOTHER UPDATE IS IN PROGRESS.  This update cannot be accepted since it would undo the previous update.  If you still wish to make changes to this resource, you must open it for editing again, but be warned that an update session was started at " + token.getCreated() + " by the user " + token.getCreatorLabel());
                    }
                    TupleQueryResult qr = null;
                    try {
                        TupleQuery eiq = rc.prepareTupleQuery(QueryLanguage.SPARQL, embeddedInstanceQuery);
                        eiq.setDataset((Dataset)qds);
                        eiq.setBinding("subject", (Value)uri);
                        qr = SPARQL.evaluateTupleQuery((String)embeddedInstanceQuery, (TupleQuery)eiq);
                        while (qr.hasNext()) {
                            URI ei = (URI)((BindingSet)qr.next()).getValue("ei");
                            log.debug((Object)("  Found embedded instance=" + ei));
                            embeddedInstances.add(ei);
                        }
                    }
                    finally {
                        if (qr != null) {
                            qr.close();
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initial embeddedInstances = " + Utils.collectionDeepToString(embeddedInstances)));
                }
                Graph removes = null;
                Graph inserts = null;
                insertHandler ih = null;
                if (deleteReader != null) {
                    String ct;
                    removeHandler rh = new removeHandler(this, rc, uri, embeddedInstances, wsURI);
                    String string = ct = deleteContentType == null ? format : deleteContentType;
                    if (ct == null) {
                        throw new BadRequestException("No content-type specified for delete graph");
                    }
                    removes = this.parseGraph(deleteReader, "delete", Utils.contentTypeGetMIMEType((String)ct), (graphHandler)rh, vf);
                }
                if (insertReader != null) {
                    String ct;
                    ih = new insertHandler(this, rc, action, uri, embeddedInstances, wsURI);
                    String string = ct = insertContentType == null ? format : insertContentType;
                    if (ct == null) {
                        throw new BadRequestException("No content-type specified for insert graph");
                    }
                    inserts = this.parseGraph(insertReader, "insert", Utils.contentTypeGetMIMEType((String)ct), (graphHandler)ih, vf);
                }
                this.doCreateOrUpdate(request, response, action, uri, wsURI, token, removes, inserts, embeddedInstances, (Dataset)qds, ih, bypassSanity);
            }
            catch (UnsupportedOperationException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void doCreateOrUpdate(HttpServletRequest request, HttpServletResponse response, Action action, URI subject, URI wsURI, EditToken token, Graph removes, Graph inserts, Set<URI> embeddedInstances, Dataset qds, insertHandler ih, boolean bypassSanity) throws ServletException, OpenRDFException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        if (removes != null && inserts != null) {
            Iterator ri = removes.iterator();
            while (ri.hasNext()) {
                Statement rs = (Statement)ri.next();
                if (!inserts.contains((Object)rs)) continue;
                ri.remove();
                log.debug((Object)("Optimized out statement remove+insert: " + rs));
                if (inserts.remove((Object)rs)) continue;
                log.debug((Object)("Failed to remove statement from inserts too: " + rs));
            }
        }
        if (action == Action.create) {
            Workflow wf = Workflow.create((HttpServletRequest)request, (URI)subject, (URI)wsURI);
            log.debug((Object)("Started New WorkFlow on resource inst=" + subject + ", WF state=" + wf.getState()));
        }
        if (removes != null) {
            rc.remove((Iterable)removes, new Resource[]{wsURI});
        }
        if (inserts != null) {
            rc.add((Iterable)inserts, new Resource[]{wsURI});
        }
        log.info((Object)(action + ": Deleted " + String.valueOf(removes == null ? 0 : removes.size()) + " statements and added " + String.valueOf(inserts == null ? 0 : inserts.size()) + " statements for " + subject + " in workspace " + wsURI.toString()));
        if (action == Action.create && this.isEmbeddedInstanceClass(rc, qds, subject)) {
            throw new BadRequestException("You may not create an independent instance of a class that is only expected to be an Embedded Instance.");
        }
        if (ih != null) {
            embeddedInstances.addAll(insertHandler.access$000((insertHandler)ih));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Final (almost) embeddedInstances = " + Utils.collectionDeepToString(embeddedInstances)));
        }
        HashSet<URI> deletedEmbeddedInstances = new HashSet<URI>();
        Iterator<URI> eii = embeddedInstances.iterator();
        while (eii.hasNext()) {
            URI eis = eii.next();
            if (this.isEmbeddedInstanceClass(rc, qds, eis)) continue;
            if (rc.hasStatement((Resource)eis, RDF.TYPE, null, false, new Resource[0])) {
                throw new BadRequestException("This update attempts to create an Embedded Instance of an inappropriate class, subject=" + eis);
            }
            if (rc.hasStatement((Resource)eis, null, null, false, new Resource[0])) {
                throw new BadRequestException("This update would leave an incompletely deleted Embedded Instance, subject=" + eis);
            }
            log.debug((Object)("Recording deleted embedded instance URI=" + eis));
            deletedEmbeddedInstances.add(eis);
            eii.remove();
        }
        for (URI eis : embeddedInstances) {
            if (rc.hasStatement((Resource)subject, null, (Value)eis, false, new Resource[]{wsURI})) continue;
            if (bypassSanity) {
                log.warn((Object)("Allowing update that leaves an orphaned Embedded Instance: resource=" + subject + ", EIsubject=" + eis));
                continue;
            }
            throw new BadRequestException("This update would leave an orphaned Embedded Instance, subject=" + eis);
        }
        for (URI eis : deletedEmbeddedInstances) {
            if (rc.hasStatement((Resource)subject, null, (Value)eis, false, new Resource[]{wsURI})) {
                throw new BadRequestException("This update would leave broken (widow) reference to a deleted Embedded Instance, subject was=" + eis);
            }
            if (!rc.hasStatement((Resource)eis, null, null, false, new Resource[]{wsURI})) continue;
            throw new BadRequestException("This update would leave an incompletely deleted (ghost) Embedded Instance, subject was=" + eis);
        }
        if (!embeddedInstances.isEmpty()) {
            BooleanQuery q = rc.prepareBooleanQuery(QueryLanguage.SPARQL, poachedEmbeddedInstanceQuery);
            q.setIncludeInferred(true);
            q.setDataset(qds);
            q.setBinding("subject", (Value)subject);
            if (SPARQL.evaluateBooleanQuery((String)poachedEmbeddedInstanceQuery, (BooleanQuery)q)) {
                if (bypassSanity) {
                    log.warn((Object)("Allowing update that creates a reference to one or more of another Resource Instance's Embedded Instances, resource=" + subject));
                } else {
                    throw new BadRequestException("This update would create a reference to one or more of another Resource Instance's Embedded Instances");
                }
            }
        }
        if (action == Action.update) {
            if (rc.hasStatement((Resource)subject, null, null, false, new Resource[]{wsURI})) {
                if (!rc.hasStatement((Resource)subject, RDF.TYPE, null, false, new Resource[]{wsURI})) {
                    throw new BadRequestException("This update request would leave the resource instance without any rdf:type statements, which is not allowed unless ALL statements are removed.");
                }
            } else {
                log.info((Object)("Deleted resource: " + subject));
            }
            token.clear(request);
        }
        if (inserts != null || removes != null) {
            List provenanceStms;
            Date now = new Date();
            Provenance p = new Provenance(subject);
            if (action == Action.create) {
                if (insertHandler.access$100((insertHandler)ih)) {
                    p.setMediated(request, now);
                } else {
                    p.setCreated(request, now);
                }
                response.setStatus(201);
            } else {
                p.setModified(request, now);
            }
            List list = provenanceStms = ih == null ? null : insertHandler.access$200((insertHandler)ih);
            if (provenanceStms != null && !provenanceStms.isEmpty()) {
                rc.add((Iterable)provenanceStms, new Resource[]{Provenance.PROVENANCE_GRAPH});
            }
        } else {
            throw new BadRequestException("Request must include at least one of the insert or delete graphs.");
        }
        rc.commit();
    }

    private boolean isEmbeddedInstanceClass(RepositoryConnection rc, Dataset qds, URI subject) throws RepositoryException, QueryEvaluationException, MalformedQueryException {
        BooleanQuery q = rc.prepareBooleanQuery(QueryLanguage.SPARQL, isEmbeddedInstanceQuery);
        q.setIncludeInferred(true);
        q.setDataset(qds);
        q.setBinding("subject", (Value)subject);
        return SPARQL.evaluateBooleanQuery((String)isEmbeddedInstanceQuery, (BooleanQuery)q);
    }

    private void doGetToken(HttpServletRequest request, HttpServletResponse response, URI uri, String format) throws ServletException, IOException, RepositoryException {
        boolean created = false;
        EditToken et = EditToken.find((HttpServletRequest)request, (URI)uri);
        if (et == null) {
            created = true;
            et = EditToken.create((HttpServletRequest)request, (URI)uri);
            WithRepositoryConnection.get((ServletRequest)request).commit();
        }
        ArrayList<MapBindingSet> results = new ArrayList<MapBindingSet>(1);
        MapBindingSet bs = new MapBindingSet(5);
        bs.addBinding("token", (Value)et.getURI());
        bs.addBinding("created", (Value)new LiteralImpl(et.getCreated(), XMLSchema.DATETIME));
        bs.addBinding("creator", (Value)et.getCreator());
        bs.addBinding("creatorLabel", (Value)new LiteralImpl(et.getCreatorLabel()));
        bs.addBinding("new", (Value)new BooleanLiteralImpl(created));
        results.add(bs);
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, results);
    }

    private Graph parseGraph(Reader graphStream, String mode, String rawFormat, graphHandler gh, ValueFactory vf) throws ServletException, IOException {
        if (rawFormat == null) {
            throw new BadRequestException("Content-type (MIME Type) of the insert argument was not specified.");
        }
        RDFFormat rf = RDFFormat.forMIMEType((String)rawFormat);
        if (rf == null) {
            throw new HttpStatusException(415, "MIME type of " + mode + " argument is not supported: \"" + rawFormat + "\"");
        }
        RDFParser parser = Rio.createParser((RDFFormat)rf, (ValueFactory)vf);
        parser.setRDFHandler((RDFHandler)gh);
        try {
            parser.parse(graphStream, "");
        }
        catch (RDFParseException e) {
            throw new BadRequestException("Error parsing " + mode + " statements: " + e.toString(), (Throwable)e);
        }
        catch (RDFHandlerException e) {
            throw new ServletException((Throwable)e);
        }
        return graphHandler.access$300((graphHandler)gh);
    }

    private URI getHomeGraph(RepositoryConnection rc, URI instance, Dataset ds) throws RepositoryException {
        URI result = Utils.getHomeGraph((RepositoryConnection)rc, (URI)instance);
        if (result != null && (ds.getDefaultGraphs().contains(result) || ds.getNamedGraphs().contains(result))) {
            return result;
        }
        return null;
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }
}

