/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.model.Access;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.util.SPARQL;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.impl.MapBindingSet;

public class WorkflowTransitions
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(WorkflowTransitions.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String format = this.getParameter(request, "format", false);
        URI workspace = this.getParameterAsURI(request, "workspace", false);
        log.debug((Object)("workspace parameter = " + workspace));
        ArrayList<MapBindingSet> result = new ArrayList<MapBindingSet>();
        for (WorkflowTransition t : WorkflowTransition.findAll((HttpServletRequest)request)) {
            URI tw = t.getWorkspace();
            if (workspace == null || tw == null || tw.equals(workspace)) {
                URI subject = t.getURI();
                boolean allowed = Access.hasPermission((HttpServletRequest)request, (Resource)subject, (Access)Access.READ);
                MapBindingSet nbs = new MapBindingSet(10);
                nbs.addBinding("subject", (Value)subject);
                nbs.addBinding("label", (Value)new LiteralImpl(t.getLabel()));
                nbs.addBinding("initial", (Value)t.getInitial());
                nbs.addBinding("initialLabel", (Value)new LiteralImpl(t.getInitialLabel()));
                nbs.addBinding("final", (Value)t.getFinal());
                nbs.addBinding("finalLabel", (Value)new LiteralImpl(t.getFinalLabel()));
                String comment = t.getComment();
                nbs.addBinding("description", (Value)(comment == null ? null : new LiteralImpl(comment)));
                nbs.addBinding("workspace", (Value)tw);
                String wl = t.getWorkspaceLabel();
                nbs.addBinding("workspaceLabel", (Value)(wl == null ? null : new LiteralImpl(wl)));
                nbs.addBinding("allowed", (Value)BooleanLiteralImpl.valueOf((boolean)allowed));
                result.add(nbs);
                continue;
            }
            log.debug((Object)("Skipping because of WORKSPACE restriction: " + t));
        }
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, result);
    }
}

