/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet.admin;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.auth.Authentication;
import org.eaglei.repository.model.workflow.WorkflowTransition;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.eaglei.repository.servlet.admin.UpdateTransition;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.openrdf.model.URI;

public class UpdateTransition
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(UpdateTransition.class);
    private static final String[] PASS_THRU_ARGS = new String[0];

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        Action action = (Action)this.getParameterAsKeyword(request, "action", Action.class, null, true);
        URI uri = this.getParameterAsURI(request, "uri", false);
        String label = this.getParameter(request, "label", false);
        String comment = this.getParameter(request, "comment", false);
        URI workspace = this.getParameterAsURI(request, "workspace", false);
        URI initialState = this.getParameterAsURI(request, "initial", false);
        URI finalState = this.getParameterAsURI(request, "final", false);
        String tAction = this.getParameter(request, "tAction", false);
        String tActionParameter = this.getParameter(request, "tActionParameter", false);
        String order = this.getParameter(request, "order", false);
        if (!Authentication.isSuperuser((HttpServletRequest)request)) {
            throw new ForbiddenException("This service is only for use by administrators.");
        }
        if (uri == null && action != Action.create) {
            throw new BadRequestException("Value for 'uri' is required when action is not create.");
        }
        if (action == Action.create || action == Action.update) {
            if (label == null) {
                throw new BadRequestException("Value for 'label' is required when creating or updating.");
            }
            if (finalState == null) {
                throw new BadRequestException("Value for 'final' is required when creating or updating.");
            }
            if (initialState == null) {
                throw new BadRequestException("Value for 'initial' is required when creating or updating.");
            }
        }
        String message = null;
        WorkflowTransition result = null;
        if (action == Action.delete) {
            result = WorkflowTransition.find((HttpServletRequest)request, (URI)uri);
            result.delete(request);
            message = "Deleted transition \"" + result.getLabel() + "\"";
        } else {
            if (action == Action.create) {
                result = WorkflowTransition.create((HttpServletRequest)request, (URI)uri, (String)label, (String)comment, (URI)initialState, (URI)finalState);
                uri = result.getURI();
                message = "Created a new Transition.";
            } else if (action == Action.update) {
                result = WorkflowTransition.find((HttpServletRequest)request, (URI)uri);
                result.setLabel(request, label);
                result.setComment(request, comment);
                result.setInitial(request, initialState);
                result.setFinal(request, finalState);
                message = "Modified transition \"" + result.getLabel() + "\"";
            }
            result.setOrder(request, order);
            result.setWorkspace(request, workspace);
            result.setAction(request, tAction);
            result.setActionParameter(request, tActionParameter);
        }
        if (result != null) {
            result.commit(request);
        }
        this.redirectToJSP(request, response, message, PASS_THRU_ARGS, new String[]{"uri", uri.stringValue()});
    }
}

