/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.status.NotAcceptableException;
import org.eaglei.repository.util.Formats;
import org.eaglei.repository.util.Utils;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Formats {
    private static final Logger log = LogManager.getLogger(Formats.class);
    private static final String[] rdfPreferred = new String[]{"application/rdf+xml", "text/plain"};
    private static final String[] htmlPreferred = new String[]{"text/html", "application/xhtml+xml"};
    private static final String[] booleanPreferred = new String[]{"application/sparql-results+xml", "text/boolean"};
    private static final String[] tuplePreferred = new String[]{"application/sparql-results+xml", "text/plain"};
    private static final Set<String> mtRDF = new HashSet();
    private static final Set<String> mtTuple = new HashSet();
    private static final Set<String> mtBoolean = new HashSet();

    private Formats() {
    }

    public static String negotiateRDFContent(HttpServletRequest request, String format) {
        return Formats.negotiateContent((HttpServletRequest)request, (String)format, null, (Collection)mtRDF, (String[])rdfPreferred);
    }

    public static String negotiateTupleContent(HttpServletRequest request, String format) {
        return Formats.negotiateContent((HttpServletRequest)request, (String)format, null, (Collection)mtTuple, (String[])tuplePreferred);
    }

    public static String negotiateBooleanContent(HttpServletRequest request, String format) {
        return Formats.negotiateContent((HttpServletRequest)request, (String)format, null, (Collection)mtBoolean, (String[])booleanPreferred);
    }

    public static String negotiateHTMLorRDFContent(HttpServletRequest request, String format) {
        return Formats.negotiateContent((HttpServletRequest)request, (String)format, (String[])htmlPreferred, (Collection)mtRDF, (String[])rdfPreferred);
    }

    private static String negotiateContent(HttpServletRequest request, String format, String[] priority, Collection<String> formats, String[] preferred) {
        String accept = request.getHeader("Accept");
        if (format != null) {
            if (formats != null && formats.contains(format)) {
                return format;
            }
            throw new NotAcceptableException("The requested response format is not available: " + format);
        }
        if (accept != null) {
            ArrayList<acceptClause> al = new ArrayList<acceptClause>();
            for (String a : accept.trim().split("\\s*,\\s*")) {
                try {
                    al.add(new acceptClause(a.trim()));
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)("Ignoring illegal format in Accept: header, section=\"" + a + "\": " + e));
                }
            }
            Collections.sort(al);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Accept sorted = " + Utils.collectionDeepToString(al)));
                log.debug((Object)("Offers preferred = " + Arrays.deepToString(preferred) + ", all = " + (formats == null ? "null" : Utils.collectionDeepToString(formats))));
            }
            acceptClause priorityResult = null;
            String priorityResultMIMEType = null;
            if (priority != null) {
                block3: for (acceptClause ac : al) {
                    for (String pf : priority) {
                        if (!ac.match(pf)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Matched PRIORITY format=" + pf + " for accept clause=" + ac));
                        }
                        priorityResult = ac;
                        priorityResultMIMEType = pf;
                        break block3;
                    }
                }
            }
            for (acceptClause ac : al) {
                if (priorityResult != null && acceptClause.access$000((acceptClause)ac) <= acceptClause.access$000(priorityResult)) {
                    return priorityResultMIMEType;
                }
                for (String pref : preferred) {
                    if (!ac.match(pref)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Matched PREFERRED format=" + pref + " for accept clause=" + ac));
                    }
                    return pref;
                }
                if (formats == null) continue;
                for (String f : formats) {
                    if (!ac.match(f)) continue;
                    log.debug((Object)("Matched format=" + f + " for accept clause=" + ac));
                    return f;
                }
            }
            throw new NotAcceptableException("None of the available response formats is acceptable to the request.");
        }
        if (priority != null) {
            return priority[0];
        }
        if (preferred != null) {
            return preferred[0];
        }
        throw new NotAcceptableException("The request did not specify any acceptable response formats and there is no default.");
    }

    public static RDFFormat getRDFOutputFormatForMIMEType(String mime) {
        return (RDFFormat)RDFWriterRegistry.getInstance().getFileFormatForMIMEType(mime);
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static {
        for (RDFWriterFactory w : RDFWriterRegistry.getInstance().getAll()) {
            RDFFormat rf = w.getRDFFormat();
            for (String mt : rf.getMIMETypes()) {
                mtRDF.add(mt);
                log.debug((Object)("Adding RDF Serialization: mime=" + mt + ", format=" + rf));
            }
        }
        for (RDFWriterFactory w : TupleQueryResultWriterRegistry.getInstance().getAll()) {
            TupleQueryResultFormat tf = w.getTupleQueryResultFormat();
            for (String mt : tf.getMIMETypes()) {
                mtTuple.add(mt);
                log.debug((Object)("Adding Tuple serialization: mime=" + mt + ", format=" + tf));
            }
        }
        for (BooleanQueryResultFormat bff : BooleanQueryResultFormat.values()) {
            for (String mt : bff.getMIMETypes()) {
                mtBoolean.add(mt);
                log.debug((Object)("Adding Boolean serialization: mime=" + mt + ", format=" + bff));
            }
        }
    }
}

