<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  Admin - display and edit the properties of a single Named Graph
   -  Also offer link to the page to edit its ACL.
   -  REQUIRED ARGS:
   -   uri = (uri) name of the named graph
  --%>
<%@ page import="java.io.IOException" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.eaglei.repository.model.NamedGraph" %>
<%@ page import="org.eaglei.repository.model.NamedGraphType" %>
<%@ page import="org.eaglei.repository.model.Provenance" %>
<%@ page import="org.eaglei.repository.vocabulary.DCTERMS" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.BadRequestException" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
  <head>
    <%@ include file="../head.jsp" %>
    <title>Eagle-I Data Repository Admin - Edit Named Graph Metadata</title>
  </head>
<%!
    // output a provenance "entry" for created or modified, they are similar.
    private void provEntry(HttpServletRequest request, JspWriter out, Provenance p, String label, String when, String who)
        throws IOException
    {
        if (when == null)
            return;
        String whoLabel = null;
        if (who != null)
            whoLabel = p.getField(request, Utils.parseURI(who, "who", true));
        out.append("<li><b>").append(label).append(":</b> <tt>").
            append(when).append("</tt>");
        if (who != null) {
            out.append(", by ");
            if (whoLabel == null)
                out.append(who);
            else
                out.append("<a href=\"").append(who).append("\">").
                    append(whoLabel).append("</a>");
        }
        out.append("</li>");
    }
%>
<%
    try {
        // sanity-check args
        request.setCharacterEncoding("UTF-8");
        URI uri = Utils.parseURI(request.getParameter("uri"), "uri", true);

        // feedback message about status of any chosen operation
        String message = request.getParameter("message");
        boolean messageSuccess = true;

        NamedGraph ng = NamedGraph.find(request, uri);
        if (ng == null)
            throw new BadRequestException("This URI is not a named graph or managed context: "+uri.stringValue());
        String label = ng.getLabel();
        if (label == null)
            label = "";
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2 align="center">Edit Named Graph Metadata</h2>
    <h3 align="center"><tt><%= StringEscapeUtils.escapeHtml( uri.stringValue()) %></tt></h3>
<%
    if (message != null) {
%>
      <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
     </h3>
<%
    }
%>

<%
    Provenance p = new Provenance(uri);
    String created = p.getField(request, DCTERMS.CREATED);
    String creator = p.getField(request, DCTERMS.CREATOR);
    String modified = p.getField(request, DCTERMS.MODIFIED);
    String contributor = p.getField(request, DCTERMS.CONTRIBUTOR);
    String sourceIdentifier = p.getField(request, DCTERMS.SOURCE_IDENTIFIER);
    String sourceModified = p.getField(request, DCTERMS.SOURCE_MODIFIED);
    if (created != null || modified != null || sourceIdentifier != null) {
%>
    <h3>Provenance Metadata:</h3>
    <ul>
<%
        provEntry(request, out, p, "Created", created, creator);
        provEntry(request, out, p, "Last modified", modified, contributor);
%>

<%
        if (sourceIdentifier != null) {
%>
        <li><b>From:</b> <tt><%= StringEscapeUtils.escapeHtml( sourceIdentifier) %></tt>
<%
            if (sourceModified != null) {
%>, last modified <tt><%= StringEscapeUtils.escapeHtml( sourceModified) %></tt>
<%
            }
%>
        </li>
<%
        }
%>
    </ul>
<%
    }
%>

    <form method="POST" action="/repository/admin/updateNamedGraph">
      <fieldset style="width: 80%; align: center;">
       <legend><b>Modify Named Graph Properties</b></legend>
       <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri.stringValue()) %>"/>
       <p><b>Label:</b> <input type="text" name="label" size="50" value="<%= Utils.escapeHTMLAttribute(label) %>"/>
       </p>
       <p><b>Named Graph Type:</b> <select name="type">
<%
    if (ng.getType() == null) {
%>
          <option selected="t" value=""> --none-- </option>
<%
    }
    for (NamedGraphType t : NamedGraphType.findAll(request)) {
%>
          <option <%= t == ng.getType() ? "selected=\"t\"" : "" %>
            value="<%= Utils.escapeHTMLAttribute(t.getURI().stringValue()) %>">
            <%= StringEscapeUtils.escapeHtml(t.getLabel()) %>
          </option>
<%
    }
%>
        </select>
        </p>
        <div width="50%" align="left">
          <div width="50%" align="center">
            <button type="reset">Reset Form</button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <button name="submit" value="submit" type="submit">Submit</button>
          </div>
        </div>
      </fieldset>
    </form>

    <form  action="/repository/admin/editGrants.jsp">
      <fieldset style="width: 80%; align: center;">
       <legend><b>Change Named Graph Access</b></legend>
      <input type="hidden" name="type" value="Named Graph" />
      <input type="hidden" name="label" value="<%= Utils.escapeHTMLAttribute(label) %>"/>
      <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(ng.getURI().stringValue()) %>"/>
      <button type="submit">Edit ACL</button><i> (Leaves this page)</i>
     </fieldset>
    </form>
    <p></p>
    <p>
    <a href="/repository/admin/namedGraphs.jsp">Return to Named Graphs</a>
    </p>
    <p>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
    </p>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
