<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  Admin - display and edit the properties of a single Role
   -  REQUIRED ARGS:
   -   uri - OR - create
   -  ARGS TO CHANGE PROPERTIES:
   -   label = textual label for the graph
   -   comment = description
   -   submit
  --%>
<%@ page import="javax.servlet.http.HttpServletResponse" %>

<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="org.eaglei.repository.model.Role" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>
<%@ page import="org.eaglei.repository.util.Utils" %>

  <head>
    <%@ include file="../head.jsp" %>
    <title>Eagle-I Data Repository Admin - Edit Access Role</title>
  </head>

<%
    try {
        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        request.setCharacterEncoding("UTF-8");
        // feedback message about status of any chosen operation
        String message = request.getParameter("message");
        boolean messageSuccess = true;

        boolean createp = request.getParameter("create") != null;
        String uri = request.getParameter("uri");
        if (uri != null && uri.trim().length() == 0)
            uri = null;

        // sanity-check args
        if (!createp && uri == null) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST, "Missing the required argument 'uri'");
            return;
        }

        String label = "";
        String comment = "";
        if (!createp) {
            Role r = Role.find(request, Utils.parseURI(uri, "uri", true));
            label = r.getLabel();
            comment = r.getComment();
            if (comment == null)
                comment = "";
        }
        String action = createp ? "create" : "update";
        String verb = createp ? "Create" : "Edit";

        // required-style - only turn on 'red' on when creating new Role
        String reqStyle = createp ? "class=\"ei_required\"" : "";
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2 align="center"><%= verb %> Access Role</h2>
<%
    if (uri != null) {
%>
    <h3 align="center"><tt><%= StringEscapeUtils.escapeHtml(uri) %></tt></h3>
<%
    }
    if (message != null) {
%>
      <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
     </h3>
<%
    }
%>

    <form accept-charset="UTF-8" method="POST" action="/repository/admin/updateRole">
      <input type="hidden" name="action" value="<%= action %>"/>
      <fieldset style="width: 80%; align: center;">
       <legend><b>Enter Role Properties</b></legend>
<%
    if (createp) {
%>
       <input type="hidden" name="create" value="true"/>
       <p><b>URI:</b> <input type="text" name="uri" size="50" value=""/>
       <br><i>This is <b>optional</b>, only fill in if you want a specific URI for the Role.
            It must not be used for any other object.</i>
       </p>
<%
    } else {
%>
       <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(uri) %>"/>
<%
    }
%>
       <p><span <%= reqStyle %>><b>Label:</b></span> <input type="text" name="label" size="50" value="<%= Utils.escapeHTMLAttribute(label) %>"/>
<%
    if (createp) {
%>
       <br><i>REQUIRED when creating a new Role.</i>
<%
    }
%>
       </p>
       <p><b>Description:</b> <input type="text" name="comment" size="80" value="<%= Utils.escapeHTMLAttribute(comment) %>"/>
       </p>
        <div width="50%" align="left">
          <div width="50%" align="center">
            <button type="reset">Reset Form</button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <button name="submit" value="submit" type="submit">Submit</button>
          </div>
        </div>
      </fieldset>
    </form>

    <p></p>
    <p>
    <a href="/repository/admin/roles.jsp">Return to list of Access Roles</a>
    </p>
    <p>
    <a href="/repository/admin/editRole.jsp?create">Create a New Role</a>
    </p>
    <p>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
    </p>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
