<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  "Portal" (or frame-content) page to change user password, and
   -  optionally, other user metadata.
   -
   -  Invocation Modes:
   -    1. Password change: when "only_password" arg is present (no value
   -       needed) to get a form that only offers inputs to change the password.
   -    2. Create/reinstate auth user: When create_auth is present,
   -       add a new auth user and require new password to be supplied.
   -    3. Standalone:  Invoking this page with the "standalone" arg
   -       presents it as a regular repository admin-UI page so we can
   -       use it outside of the frame in the data tools
   -
   -  OPTIONAL ARGS: (also passed through form)
   -   username  - principal name of user to change, defaults to authenticated
   -   only_password - if specified, do not include other metadata inputs.
   -   create_auth - create a new authUser record, requires password
   -   standalone - flag to put up a whole standalone UI
   -  Args set by form:
   -   old_password - current (old) password, required for user changing own pw
   -   password - new password
   -   password_confirm - must match new password
   -   first - first name
   -   last - last name
   -   mailbox - mailbox
   -   role - multiple values, URI of roles to apply to user
   -   submit - present when "submit" button is pressed
   -
   -  @author Larry Stone
   -  Started Jul 2010, @version $Id: $
  --%>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.Collections" %>
<%@ page import="java.util.List" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.model.Role" %>
<%@ page import="org.eaglei.repository.model.User" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.status.BadRequestException" %>
<%@ page import="org.eaglei.repository.status.NotFoundException" %>
<%!
    // return null if param is empty string
    private String getNonEmptyParameter(HttpServletRequest request, String name)
    {
        String result = request.getParameter(name);
        if (result != null && result.length() == 0)
            return null;
        return result;
    }
    private String acceptCharset = "UTF-8";
%>
<%
    // feedback message about status of last operation
    request.setCharacterEncoding(acceptCharset);
    String message = request.getParameter("message");
    boolean messageSuccess = true;

    boolean standalone = request.getParameter("standalone") != null;
    boolean onlyPassword = request.getParameter("only_password") != null;
    boolean createAuth = request.getParameter("create_auth") != null;
    String username = getNonEmptyParameter(request, "username");

    try {
        // Get user metadata object UNLESS putting up form to create new user
        // (If  createAuth is true and username is given, we're creating RDF
        // metadata for an "undocumented" auth user.)
        //
        // then sanity check by function:
        // - new user: createAuth && username == null
        // - reinstate: createAuth && username != null (check uu != null)
        // - edit uesr: !createAuth, check uu != null
        User uu = null;
        if (!(createAuth && username == null)) {
            if (username == null) {
                username = Authentication.getAuthenticatedUsername(request);
                if (username == null)
                    throw new BadRequestException("Not creating, and there is no authenticated user found to edit.");
            }
            uu = User.findByUsername(request, username);
            if (uu == null) {
                throw new NotFoundException("No user account found for username '"+username+"'");

            }
        }


        // are we editing current user?
        boolean currentUser = request.getParameter("username") == null ||
            (uu != null && uu.getUsername().equals(Authentication.getAuthenticatedUsername(request)));

        // page title
        String title = null;
        if (createAuth) {
            if (username == null)
                title = "Creating a New User";
            else
                title = "Reinstating: <tt>"+StringEscapeUtils.escapeHtml(username)+"</tt>";
        } else {
            title = "Editing "+(currentUser ? "Current " : "")+"User: <tt>"+StringEscapeUtils.escapeHtml(username)+"</tt>";
        }
%>
  <head>
<%
        if (standalone) {
%>
              <%@ include file="../head.jsp" %>
              <title>Eagle-I Data Repository - Edit User Metadata</title>
              <style type="text/css">
                  h2,h3 { margin: .5em 0; }
                  .disabled { color: gray; }
                  .ei_required { color: red; }
                  .eaglei_passwdForm form { margin: 10px 0; }
                  .eaglei_passwdForm label { margin: 0 20px 5px 20px; }
                  .eaglei_passwdForm input { margin: 5px 20px;  }
              </style>

<%
        // NOT standalone
        } else {
%>
              <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
              <link REL="stylesheet" TYPE="text/css" HREF="/repository/styles/i.css">
<%
        }
%>
  </head>
  <body>
<%
        if (standalone) {
%>
              <%@ include file="/repository/admin/banner.jsp" %>
              <h2><%= title %></h2>
<%
                if (uu != null && uu.getURI() != null) {
%>
                    <h3>URI: <tt><%= StringEscapeUtils.escapeHtml(uu.getURI().stringValue()) %></tt></h3>
<%
                }
%>
              <span class="ei_required"><i>Input fields labelled in <b>RED</b> are <b>required</b></i></span>
<%
            if (message != null) {
%>
            <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
                  <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %></font>
            </h3>
<%
            }
        }
%>
    <div class="eaglei_passwdForm">
     <form method="POST" action="/repository/admin/updateUser" accept-charset="<%= acceptCharset %>">
       <input type="hidden" name="action" value="<%= createAuth ? (username == null ? "create" : "reinstate") : "update" %>"/>
<%
        if (standalone) {
%>
            <input type="hidden" name="standalone"/>
<%
        }
        if (onlyPassword) {
%>
            <input type="hidden" name="only_password" value="true"/>
            <input type="hidden" name="username" value="<%= Utils.escapeHTMLAttribute(username) %>"/>
<%
        } else {
            String first = null;
            String last = null;
            String mailbox = null;
            if (uu != null) {
                first = uu.getFirstName();
                last = uu.getLastName();
                mailbox = uu.getMbox();
            }
            if (createAuth && username == null) {
%>
                <label for="id_username"><span class="ei_required"><b>Username:</b> </span></label>
                <input type="text" name="username" id="id_username" size="30" value="<%= username == null ?  "" :  Utils.escapeHTMLAttribute(username) %>"/>
                <br/>
<%
            } else {
%>
                <input type="hidden" name="username" value="<%= Utils.escapeHTMLAttribute(username) %>"/>
<%
            }
%>
            <label for="id_first"><b>First Name:</b> </label>
            <input type="text" name="first" id="id_first" size="30" value="<%= first == null ?  "" :  Utils.escapeHTMLAttribute(first) %>"/>
            <br/>
            <label for="id_last"><b>Last Name:</b> </label>
            <input type="text" name="last" id="id_last" size="30" value="<%= last == null ? "" : Utils.escapeHTMLAttribute(last) %>"/>
            <br/>
            <label for="id_mailbox"><b>Mailbox:</b> </label>
            <input type="text" name="mailbox" id="id_mailbox" size="40" value="<%= mailbox == null ? "" : Utils.escapeHTMLAttribute(mailbox) %>"/>
<%
        }

        // if this is changing our own password, request old password first:
        if (!createAuth && currentUser) {
%>
        <br/>
        <label for="id_old_password">
          <span><b>Your Current Password:</b> </span>
        </label>
        <input type="password" name="old_password" id="id_old_password" size="20"/>
<%
        }
%>
        <br/>
<%
        boolean pwDisabled = !createAuth && !currentUser && uu != null && !uu.isLoginable();
        if (pwDisabled) {
%>
        <span><i>Note: This user is currently <b>disabled</b>.
          You must reinstate them to set a password and allow them to login.
        </i></span>
        <br/>
<%
        }
%>
        <label for="id_password">
          <span class="<%= pwDisabled ? "disabled" : "" %> <%= createAuth ? "ei_required" : "" %>"><b><%= createAuth ? "" : "Change " %>Password:</b> </span>
        </label>
        <input type="password" <%= pwDisabled ? "disabled" : "" %> name="password" id="id_password" size="20"/>
        <br/>
        <label for="id_password_confirm">
          <span class="<%= pwDisabled ? "disabled" : "" %> <%= createAuth ? "ei_required" : "" %>"><b>Confirm Password:</b> </span>
        </label>
        <input type="password" <%= pwDisabled ? "disabled" : "" %> name="password_confirm" id="id_password_confirm" size="20"/>
<%
        if (!onlyPassword) {
            String disabled = Authentication.isSuperuser(request) ? "" : "disabled ";
            Collection<Role> roles = Role.findAllUserRoles(request);
            Collections.sort((List<Role>)roles);
%>
            <br/>
            <label for="id_role" style="vertical-align: top;">
              <b>Roles: </b>
            </label>
            <select name="role" id="id_role" <%= disabled %>
                    multiple="true" size="<%= roles.size() > 6 ? 6 : roles.size() %>">
<%
            // check role membership with kludge to accomodate users who
            // are only defined in Auth'n DB but yet might have Superuser role.
            for (Role r : roles) {
                boolean has = false;
                if (uu != null) {
                    has = uu.hasRoleP(r.getURI());
                } else if (r.isSuperuser()) {
                    if (!createAuth && currentUser) {
                        has = Authentication.isSuperuser(request);
                    }
                }
%>
                <option <%= disabled %> <%= has ? "selected" : "" %> value="<%= Utils.escapeHTMLAttribute(r.getURI().stringValue()) %>"><%= StringEscapeUtils.escapeHtml(r.getLabel()) %></option>
<%
            }
%>
            </select>
            <br/><label><i>Use CTRL-click or COMMAND-click to select / deselect multiple Roles.</i></label>
            <br/>
<%
        }
%>
        <br/>&nbsp;&nbsp;&nbsp;&nbsp;
        <button type="reset">Reset Form</button>
        &nbsp;&nbsp;&nbsp;&nbsp;
        <button name="submit" value="submit" type="submit">Submit</button>
     </form>
    </div>
<%
        if (standalone) {
            if (Authentication.isSuperuser(request)) {
%>
                <a href="/repository/admin/users.jsp">Back to User List page</a>
                <br/>
                <br/>
                <a href="/repository/admin/editUserPortlet.jsp?standalone=true&amp;create_auth">Create a New User Account</a>
                <br/>
                <br/>
<%
            }
%>
            <a href="/repository/admin/index.jsp">Return to Admin top level</a>
<%
        }
    } catch (IllegalArgumentException e) {
        response.sendError(response.SC_BAD_REQUEST, "Illegal argument: "+e.getMessage());
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
  </body>
</html>
