<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -
   - Transitions Admin paeg - present a list with columns:
   -   1. Label (which is also a link to edit the transition)
   -   2.  description
   -   3.  workspace
   -   4.  initial state
   -   5.  final state
   -   6.  delete button
   -
   -  Args:
   -   mine - if arg present, show only my accessible transitions
   -     NOTE: This is a kludge for the convenience of testing only!
  --%>

<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="org.eaglei.repository.util.Utils" %>
<%@ page import="org.eaglei.repository.model.Access" %>
<%@ page import="org.eaglei.repository.auth.Authentication" %>
<%@ page import="org.eaglei.repository.model.workflow.WorkflowTransition" %>
<%@ page import="org.eaglei.repository.model.workflow.ErrorAction" %>
<%@ page import="org.eaglei.repository.status.ErrorSendingException" %>
<%@ page import="org.eaglei.repository.status.ForbiddenException" %>

  <head>
    <%@ include file="../head.jsp" %>
    <title>Eagle-I Data Repository Admin - Manage Workflow Transitions</title>
  </head>
<%
    // MUST call this before getting any parameters
    request.setCharacterEncoding("UTF-8");
    // feedback message about status of any chosen operation
    String message = request.getParameter("message");
    boolean messageSuccess = true;

    try {
        if (!Authentication.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        boolean mine = request.getParameter("mine") != null;
%>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Manage Workflow Transitions</h2>

<%
        if (message != null) {
%>
    <h3><font color="<%= messageSuccess ? "GREEN" : "RED" %>">
          <%= messageSuccess ? "Success" : "FAILED" %>: <%= StringEscapeUtils.escapeHtml(message) %>
          </font>
    </h3>
<%
        }
%>
     <h3>&#x26ab; <a href="/repository/admin/editTransition.jsp?create">
         Create a New Workflow Transition</a>
     </h3>
    <h3>&#x26ab; Manage Existing Workflow Transitions</h3>
    <!-- columns: label, comment, delete? -->
    <div style="margin: 0px 0px 0px 30px;">
    <table border="1">
    <tr>
      <th>Transition</th>
      <th>Description</th>
      <th>Workspace</th>
      <th>Initial State</th>
      <th>Final State</th>
      <th colspan="2">Actions</th>
    </tr>
<%
    for (WorkflowTransition t : WorkflowTransition.findAccessibleByAttributes(request, null, null, null, mine ? Authentication.getPrincipalURI(request) : null)) {
        String turi = t.getURI().stringValue();
        String euri = Utils.urlEncode(turi);
        String rc = t.getComment();
        String wl = t.getWorkspaceLabel();
        String il = t.getInitialLabel();
        String fl = t.getFinalLabel();
        String tl = t.getLabel();
        // be sure there are no single or double-quotes to screw up javascript
        String deleteLabel = Utils.escapeHTMLAttribute(tl.replace("\"", "`").replace("'","`"));
 %>
        <tr>
          <td>
            <a href="/repository/admin/editTransition.jsp?uri=<%= Utils.escapeHTMLAttribute(euri) %>">
                  <tt><%= StringEscapeUtils.escapeHtml(tl) %></tt>
            </a>
          </td>

          <td>
            <%=  rc == null ? "&nbsp;" : StringEscapeUtils.escapeHtml(rc) %>
<%
            if (t.isErrorAction()) {
 %>
            <br/>
            <span style="color: red; font-style: italic;">
             <%= ((ErrorAction)t.getAction()).getMessage() %>
            </span>
<%
            }
 %>
          </td>

          <td>
            <%=  wl == null ? "<i>all</i>" : StringEscapeUtils.escapeHtml(wl) %>
          </td>

          <td>
            <%=  il == null ? "<i>ERROR - missing initial state</i>" : StringEscapeUtils.escapeHtml(il) %>
          </td>

          <td>
            <%=  fl == null ? "<i>ERROR - missing final state</i>" : StringEscapeUtils.escapeHtml(fl) %>
          </td>

          <td>
              <form style="margin: 0pt;" action="/repository/admin/editGrants.jsp">
                <input type="hidden" name="type" value="Workflow Transition" />
                <input type="hidden" name="label" value="<%= Utils.escapeHTMLAttribute(tl) %>"/>
                <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(turi) %>"/>
                <input type="hidden" name="lock_access" value="<%= Utils.escapeHTMLAttribute(Access.READ.getURI().stringValue()) %>"/>
                <button type="submit">Edit ACL</button></form>
          </td>

          <td>
    <form action="/repository/admin/updateTransition" method="POST"
          onclick="javascript:return confirm('Are you SURE you want to delete Transition &quot;<%= deleteLabel %>&quot; ?  It CANNOT be un-done.')">
      <input type="hidden" name="uri" value="<%= Utils.escapeHTMLAttribute(turi) %>"/>
      <input type="hidden" name="action" value="delete"/>
      <button name="submit" value="submit" type="submit">&#x2620 <i>Delete</i></button>
    </form>
          </td>
        </tr>
<%
    }
 %>
    </table>
    <i>Click on Transition's label to edit its properties.</i>
    </div>

    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
<%
    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }
%>
</html>
